<?php

declare(strict_types=1);

use UddoktaPay\Installer\Core\Application;

// PHP Version Check
if (version_compare(PHP_VERSION, '8.2.0') < 0) {
    exit('Current PHP version is '.PHP_VERSION.'! PHP version required for running UddoktaPay is PHP 8.2. Please check and upgrade your current PHP version.');
}
// ionCube Loader Check
if (! function_exists('ioncube_loader_version')) {
    exit('ionCube Loader function is missing! UddoktaPay requires ionCube Loader function to run, Please check and enable the extension or Contact with hosting provider.');
}

// ionCube Version Check
$ionVersion = ioncube_loader_version();
$versionParts = explode('.', $ionVersion);
$normalizedVersion = implode('.', array_pad(array_slice($versionParts, 0, 3), 3, '0'));

if (version_compare($normalizedVersion, '12.0.0') < 0) {
    exit("Current ionCube Loader version is {$normalizedVersion}! minimum ionCube Loader version required for running UddoktaPay is 12.0.0. Please check and upgrade your current ionCube Loader version or Contact with hosting provider.");
}

require __DIR__.'/installer/vendor/autoload.php';

try {
    (new Application(dirname(__DIR__)))->run();
} catch (Throwable $e) {
    http_response_code(500);
    echo 'Installation failed: '.$e->getMessage();
}
