<?php

declare(strict_types=1);

use App\Constants\Status;
use App\Enums\MfsPaymentType;
use App\Enums\MfsTransactionStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('mfs_transactions', function (Blueprint $table): void {
            $table->id();
            $table->foreignId('device_id')->nullable();
            $table->string('payment_method')->index();
            $table->enum('type', [MfsPaymentType::PERSONAL, MfsPaymentType::MERCHANT, MfsPaymentType::AGENT])->default(MfsPaymentType::PERSONAL);
            $table->string('phone_number')->index();
            $table->string('transaction_id')->index()->unique();
            $table->decimal('amount', 28, 2)->default(Status::AMOUNT);
            $table->decimal('balance', 28, 2)->default(Status::AMOUNT);
            $table->string('ref')->nullable();
            $table->text('note')->nullable();
            $table->enum('status', [MfsTransactionStatus::APPROVED, MfsTransactionStatus::PENDING, MfsTransactionStatus::USED])->default(MfsTransactionStatus::APPROVED);
            $table->timestamps();
            $table->softDeletes();
            $table->index(['payment_method', 'type', 'transaction_id', 'status'], 'mfs_transactions_trx_verify_index');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('mfs_transactions', function (Blueprint $table): void {
            $table->dropIfExists();
        });
    }
};
