<?php

declare(strict_types=1);

use App\Constants\Status;
use App\Enums\GatewayMode;
use App\Enums\GatewayStatus;
use App\Enums\GatewayType;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('gateways', function (Blueprint $table): void {
            $table->id();
            $table->foreignId('brand_id')->index();
            $table->string('name');
            $table->string('display_name');
            $table->string('image')->nullable();
            $table->string('currency');
            $table->string('symbol');
            $table->string('alias')->index();
            $table->string('group');
            $table->string('code');
            $table->decimal('min_amount', 28, 8)->unsigned()->default(Status::ENABLE);
            $table->decimal('max_amount', 28, 8)->unsigned()->default(Status::AMOUNT);
            $table->decimal('percent_charge', 5, 2)->unsigned()->default(Status::DEFAULT_AMOUNT);
            $table->decimal('fixed_charge', 28, 8)->unsigned()->default(Status::AMOUNT);
            $table->boolean('has_qr_code')->default(false);
            $table->text('qr_code')->nullable();
            $table->text('parameters')->nullable();
            $table->text('gateway_parameters')->nullable();
            $table->text('extra')->nullable();
            $table->text('description')->nullable();
            $table->integer('order_column')->default(Status::NO);
            $table->tinyInteger('is_automatic')->default(Status::YES)->index();
            $table->enum('type', [GatewayType::MFS, GatewayType::GLOBAL, GatewayType::BANK])->default(GatewayType::BANK)->index();
            $table->enum('mode', [GatewayMode::LIVE, GatewayMode::MANUAL, GatewayMode::PERSONAL, GatewayMode::MERCHANT, GatewayMode::AGENT])->default(GatewayMode::LIVE)->index();
            $table->tinyInteger('status')->default(GatewayStatus::ENABLE)->index();
            $table->timestamps();
            $table->unique(['brand_id', 'code']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('gateways', function (Blueprint $table): void {
            $table->dropIfExists();
        });
    }
};
