<?php

declare(strict_types=1);

use App\Constants\Status;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('faqs', function (Blueprint $table): void {
            $table->id();
            $table->foreignId('brand_id')->index();
            $table->text('title');
            $table->longText('content');
            $table->integer('order_column')->default(Status::NO);
            $table->tinyInteger('status')->default(Status::ENABLE)->index();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('faqs', function (Blueprint $table): void {
            $table->dropIfExists();
        });
    }
};
