<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('invoices', function (Blueprint $table): void {
            $table->id();
            $table->foreignId('brand_id')->index();
            $table->foreignId('customer_id')->nullable()->index();
            $table->string('track_id')->index();
            $table->string('currency')->index();
            $table->string('shipping_amount')->default(0);
            $table->longText('notes')->nullable();
            $table->string('status', 30)->default('unpaid');
            $table->dateTime('due_date')->nullable();
            $table->timestamps();
            $table->unique(['brand_id', 'track_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('invoices', function (Blueprint $table): void {
            $table->dropIfExists();
        });
    }
};
