<?php

declare(strict_types=1);

use App\Constants\Status;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('invoice_items', function (Blueprint $table): void {
            $table->id();
            $table->foreignId('brand_id')->index();
            $table->foreignId('invoice_id')->index();
            $table->longText('description');
            $table->integer('quantity')->default(Status::YES);
            $table->decimal('amount', 28, 8)->default(Status::AMOUNT);
            $table->decimal('discount', 28, 8)->default(Status::AMOUNT);
            $table->decimal('vat', 5, 2)->default(Status::AMOUNT);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('invoice_items', function (Blueprint $table): void {
            $table->dropIfExists();
        });
    }
};
