<?php

declare(strict_types=1);

use App\Enums\DeviceStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('devices', function (Blueprint $table): void {
            $table->id();
            $table->string('device_id')->index()->unique();
            $table->string('device_name');
            $table->string('device_model');
            $table->string('android_version');
            $table->string('app_version');
            $table->string('sim')->nullable();
            $table->enum('status', [DeviceStatus::CONNECTED, DeviceStatus::DISCONNECTED])->default(DeviceStatus::CONNECTED)->index();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('devices');
    }
};
