<?php

declare(strict_types=1);

use App\Constants\Status;
use App\Enums\PaymentLinkStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payment_links', function (Blueprint $table): void {
            $table->id();
            $table->foreignId('brand_id')->index();
            $table->string('track_id')->index();
            $table->string('product_name');
            $table->text('product_description')->nullable();
            $table->integer('quantity')->unsigned()->default(Status::DEFAULT);
            $table->longText('form_data')->nullable();
            $table->string('currency', 45);
            $table->decimal('amount', 28, 8)->default(Status::AMOUNT);
            $table->boolean('status')->default(PaymentLinkStatus::ENABLE);
            $table->dateTime('expires_at')->nullable();
            $table->timestamps();
            $table->unique(['brand_id', 'track_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payment_links');
    }
};
