<?php

declare(strict_types=1);

use App\Enums\GatewayMode;
use App\Enums\GatewayStatus;
use App\Enums\GatewayType;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // drop gateway id
        if (Schema::hasColumn('gateways', 'predefined_gateway_id')) {
            Schema::table('gateways', function (Blueprint $table): void {
                $table->dropColumn('predefined_gateway_id');
            });
        }

        // Check if predefined_gateways table exists
        if (Schema::hasTable('predefined_gateways')) {
            Schema::drop('predefined_gateways');
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Create predefined_gateways table if it doesn't exist
        if (! Schema::hasTable('predefined_gateways')) {
            Schema::create('predefined_gateways', function (Blueprint $table): void {
                $table->id();
                $table->string('name');
                $table->string('currency');
                $table->string('symbol');
                $table->string('alias')->unique();
                $table->string('group');
                $table->boolean('has_qr_code')->default(false);
                $table->enum('type', [GatewayType::MFS, GatewayType::GLOBAL, GatewayType::BANK])->default(GatewayType::BANK);
                $table->enum('mode', [GatewayMode::LIVE, GatewayMode::MANUAL, GatewayMode::PERSONAL, GatewayMode::MERCHANT, GatewayMode::AGENT])->default(GatewayMode::LIVE)->index();
                $table->tinyInteger('status')->default(GatewayStatus::ENABLE);
                $table->timestamps();
            });
        }

        // Add predefined_gateway_id column to gateways table if it doesn't exist
        if (! Schema::hasColumn('gateways', 'predefined_gateway_id')) {
            Schema::table('gateways', function (Blueprint $table): void {
                $table->foreignId('predefined_gateway_id')->nullable()->after('brand_id');
            });
        }
    }
};
