<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('update_logs', function (Blueprint $table): void {
            $table->string('backup_path')->nullable()->after('error_details');
            $table->timestamp('rolled_back_at')->nullable()->after('backup_path');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('update_logs', function (Blueprint $table): void {
            $table->dropColumn(['backup_path', 'rolled_back_at']);
        });
    }
};
