<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        DB::table('gateways')
            ->where('type', 'mfs')
            ->whereIn('mode', ['personal', 'agent', 'merchant'])
            ->update(['has_qr_code' => true]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::table('gateways')
            ->where('type', 'mfs')
            ->whereIn('mode', ['personal', 'agent', 'merchant'])
            ->update(['has_qr_code' => false]);
    }
};
