<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('payments', function (Blueprint $table): void {
            // Base currency discount fields after 'amount'
            $table->after('amount', function (Blueprint $table): void {
                $table->decimal('fixed_discount', 28, 8)->default(0);
                $table->decimal('percent_discount', 28, 8)->default(0);
                $table->decimal('total_discount', 28, 8)->default(0);
            });

            // Merchant currency discount fields after 'merchant_amount'
            $table->after('merchant_amount', function (Blueprint $table): void {
                $table->decimal('merchant_fixed_discount', 28, 8)->default(0);
                $table->decimal('merchant_percent_discount', 28, 8)->default(0);
                $table->decimal('merchant_total_discount', 28, 8)->default(0);
            });

            // Gateway currency discount fields after 'gateway_amount'
            $table->after('gateway_amount', function (Blueprint $table): void {
                $table->decimal('gateway_fixed_discount', 28, 8)->default(0);
                $table->decimal('gateway_percent_discount', 28, 8)->default(0);
                $table->decimal('gateway_total_discount', 28, 8)->default(0);
            });
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('payments', function (Blueprint $table): void {
            $table->dropColumn([
                'fixed_discount',
                'percent_discount',
                'total_discount',
                'merchant_fixed_discount',
                'merchant_percent_discount',
                'merchant_total_discount',
                'gateway_fixed_discount',
                'gateway_percent_discount',
                'gateway_total_discount',
            ]);
        });
    }
};
