<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('gateways', function (Blueprint $table): void {
            $table->decimal('percent_discount', 5, 2)->default(0)->after('fixed_charge');
            $table->decimal('fixed_discount', 28, 8)->default(0)->after('percent_discount');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('gateways', function (Blueprint $table): void {
            $table->dropColumn([
                'percent_discount',
                'fixed_discount',
            ]);
        });
    }
};
