<div wire:poll.{{ $validatingLicense ? "3" : "30" }}s="$dispatch('$refresh')">
    <x-filament-panels::page>
        <div class="space-y-6">
            {{-- License Status Overview --}}
            <x-filament::section>
                <x-slot name="heading">
                    <div class="flex items-center justify-between">
                        <span>License Status</span>
                        @if ($licenseInfo && isset($licenseInfo["validated_at"]))
                            <span class="text-xs text-gray-500">
                                Last validated:
                                {{ \Carbon\Carbon::parse($licenseInfo["validated_at"])->diffForHumans() }}
                            </span>
                        @endif
                    </div>
                </x-slot>

                <div class="grid grid-cols-1 gap-6 md:grid-cols-2 lg:grid-cols-3">
                    {{-- License Status Card --}}
                    <div
                        class="bg-white-50 dark:bg-white-900/20 flex items-center space-x-3 rounded-lg border border-gray-200 p-4 dark:border-gray-800"
                    >
                        <div class="flex-shrink-0">
                            @if ($licenseActive && ! $licenseExpired)
                                <x-heroicon-o-shield-check class="text-success-500 h-8 w-8" />
                            @elseif ($licenseExpired)
                                <x-heroicon-o-exclamation-triangle class="text-danger-500 h-8 w-8" />
                            @else
                                <x-heroicon-o-shield-exclamation class="text-warning-500 h-8 w-8" />
                            @endif
                        </div>
                        <div class="min-w-0 flex-1">
                            <p class="text-sm font-medium text-gray-900 dark:text-white">Status</p>
                            <p class="text-lg font-semibold">
                                @if ($licenseActive && ! $licenseExpired)
                                    <span class="text-success-600 dark:text-success-400">Active</span>
                                @elseif ($licenseExpired)
                                    <span class="text-danger-600 dark:text-danger-400">Expired</span>
                                @else
                                    <span class="text-warning-600 dark:text-warning-400">Inactive</span>
                                @endif
                            </p>
                            @if ($licenseInfo && isset($licenseInfo["license_type"]))
                                <p class="text-xs text-gray-500 capitalize">
                                    {{ str_replace("_", " ", $licenseInfo["license_type"]) }}
                                </p>
                            @endif
                        </div>
                    </div>

                    {{-- Customer Info Card --}}
                    @if ($licenseInfo && isset($licenseInfo["customer_name"]))
                        <div
                            class="bg-white-50 dark:bg-white-900/20 flex items-center space-x-3 rounded-lg border border-gray-200 p-4 dark:border-gray-800"
                        >
                            <div class="flex-shrink-0">
                                <x-heroicon-o-user class="text-primary-500 h-8 w-8" />
                            </div>
                            <div class="min-w-0 flex-1">
                                <p class="text-sm font-medium text-gray-900 dark:text-white">Licensed To</p>
                                <p class="text-primary-600 dark:text-primary-400 truncate text-lg font-semibold">
                                    {{ $licenseInfo["customer_name"] }}
                                </p>
                                @if (isset($licenseInfo["customer_email"]))
                                    <p class="truncate text-xs text-gray-500">
                                        {{ $licenseInfo["customer_email"] }}
                                    </p>
                                @endif
                            </div>
                        </div>
                    @endif

                    {{-- Expiration Card --}}
                    @if ($licenseInfo && isset($licenseInfo["expires_at"]))
                        <div
                            class="bg-white-50 dark:bg-white-900/20 flex items-center space-x-3 rounded-lg border border-gray-200 p-4 dark:border-gray-800"
                        >
                            <div class="flex-shrink-0">
                                @if ($licenseExpired)
                                    <x-heroicon-o-clock class="text-danger-500 h-8 w-8" />
                                @else
                                    @php
                                        $daysUntilExpiry = \Carbon\Carbon::parse(
                                            $licenseInfo["expires_at"],
                                        )->diffInDays(now());
                                        $isExpiringSoon = $daysUntilExpiry <= 30;
                                    @endphp

                                    <x-heroicon-o-calendar
                                        class="{{ $isExpiringSoon ? 'text-warning-500' : 'text-success-500' }} h-8 w-8"
                                    />
                                @endif
                            </div>
                            <div class="min-w-0 flex-1">
                                <p class="text-sm font-medium text-gray-900 dark:text-white">
                                    {{ $licenseExpired ? "Expired" : "Expires" }}
                                </p>
                                <p
                                    class="{{ $licenseExpired ? "text-danger-600 dark:text-danger-400" : "text-gray-600 dark:text-gray-400" }} text-lg font-semibold"
                                >
                                    {{ \Carbon\Carbon::parse($licenseInfo["expires_at"])->format("M j, Y") }}
                                </p>
                                <p class="text-xs text-gray-500">
                                    {{ \Carbon\Carbon::parse($licenseInfo["expires_at"])->diffForHumans() }}
                                </p>
                            </div>
                        </div>
                    @endif

                    {{-- Never Expires Card --}}
                    @if ($licenseInfo && (! isset($licenseInfo["expires_at"]) || ! $licenseInfo["expires_at"]))
                        <div
                            class="bg-white-50 dark:bg-white-900/20 flex items-center space-x-3 rounded-lg border border-gray-200 p-4 dark:border-gray-800"
                        >
                            <div class="flex-shrink-0">
                                <x-heroicon-o-rocket-launch class="text-success-500 h-8 w-8" />
                            </div>
                            <div class="min-w-0 flex-1">
                                <p class="text-sm font-medium text-gray-900 dark:text-white">Expiration</p>
                                <p class="text-success-600 dark:text-success-400 text-lg font-semibold">
                                    Never Expires
                                </p>
                                <p class="text-xs text-gray-500">Lifetime License</p>
                            </div>
                        </div>
                    @endif
                </div>
            </x-filament::section>

            {{-- No License Found --}}
            @if (! $licenseActive && ! $licenseInfo && ! $validatingLicense)
                <x-filament::section>
                    <div class="py-12 text-center">
                        <x-heroicon-o-key class="text-warning-500 mx-auto h-20 w-20" />
                        <h3 class="mt-6 text-xl font-semibold text-gray-900 dark:text-white">No License Found</h3>
                        <p class="mx-auto mt-3 max-w-md text-gray-600 dark:text-gray-400">
                            Please validate your license to activate this software and access all features.
                        </p>
                        <div class="mt-6 space-y-2 text-sm text-gray-500">
                            <div class="flex items-center justify-center space-x-2">
                                <x-heroicon-o-check class="h-4 w-4" />
                                <span>Enter your license key using the "Validate License" button above</span>
                            </div>
                            <div class="flex items-center justify-center space-x-2">
                                <x-heroicon-o-check class="h-4 w-4" />
                                <span>Contact support if you need assistance</span>
                            </div>
                        </div>
                    </div>
                </x-filament::section>
            @endif

            {{-- License Expired Warning --}}
            @if ($licenseExpired && $licenseInfo)
                <x-filament::section>
                    <x-slot name="heading">
                        <div class="flex items-center space-x-2">
                            <x-heroicon-o-exclamation-triangle class="text-danger-500 h-5 w-5" />
                            <span>License Expired</span>
                        </div>
                    </x-slot>

                    <div
                        class="bg-danger-50 border-danger-200 dark:bg-danger-900/20 dark:border-danger-800 rounded-lg border p-4"
                    >
                        <div class="space-y-3">
                            <div class="flex items-start space-x-3">
                                <x-heroicon-o-exclamation-triangle
                                    class="text-danger-500 mt-0.5 h-5 w-5 flex-shrink-0"
                                />
                                <div class="text-sm">
                                    <p class="text-danger-800 dark:text-danger-200 font-medium">
                                        Your License Has Expired
                                    </p>
                                    <p class="text-danger-700 dark:text-danger-300 mt-1">
                                        Your license expired on
                                        {{ \Carbon\Carbon::parse($licenseInfo["expires_at"])->format("M j, Y") }}.
                                        Please renew your license to continue using this software.
                                    </p>
                                </div>
                            </div>
                            <div class="bg-danger-100 dark:bg-danger-800/30 mt-4 rounded-md p-3">
                                <p class="text-danger-800 dark:text-danger-200 text-sm font-medium">
                                    ⚠️ Some features may be disabled until your license is renewed
                                </p>
                            </div>
                        </div>
                    </div>
                </x-filament::section>
            @endif

            {{-- Domain Information --}}
            @if ($licenseInfo && isset($licenseInfo["allowed_domains"]))
                <x-filament::section>
                    <x-slot name="heading">Domain Authorization</x-slot>

                    <div class="space-y-4">
                        @if (is_null($licenseInfo["max_domains"]))
                            <div
                                class="rounded-lg border border-purple-200 bg-purple-50 p-4 dark:border-purple-800 dark:bg-purple-900/20"
                            >
                                <div class="flex items-center space-x-3">
                                    <x-heroicon-o-cpu-chip class="h-5 w-5 text-purple-500" />
                                    <div class="text-sm">
                                        <p class="font-medium text-purple-800 dark:text-purple-200">
                                            Unlimited Authorized Domains
                                        </p>
                                        <p class="mt-1 text-purple-700 dark:text-purple-300">
                                            This license allows access from any domain without restrictions.
                                        </p>
                                    </div>
                                </div>
                            </div>
                        @else
                            <div class="space-y-3">
                                <h4 class="text-sm font-medium text-gray-900 dark:text-white">Authorized Domains</h4>
                                <div class="grid grid-cols-1 gap-3 md:grid-cols-2 lg:grid-cols-3">
                                    @foreach ($licenseInfo["allowed_domains"] as $domain)
                                        @php
                                            $isCurrentDomain = $domain === request()->getHost();
                                        @endphp

                                        <div
                                            class="{{ $isCurrentDomain ? "border-success-200 bg-success-50 dark:border-success-800 dark:bg-success-900/20" : "border-gray-200 bg-gray-50 dark:border-gray-700 dark:bg-gray-800" }} flex items-center space-x-3 rounded-lg border p-3"
                                        >
                                            @if ($isCurrentDomain)
                                                <x-heroicon-o-check-circle
                                                    class="text-success-500 h-4 w-4 flex-shrink-0"
                                                />
                                            @else
                                                <x-heroicon-o-globe-alt class="h-4 w-4 flex-shrink-0 text-gray-400" />
                                            @endif
                                            <div class="min-w-0 flex-1">
                                                <p
                                                    class="{{ $isCurrentDomain ? "text-success-800 dark:text-success-200" : "text-gray-900 dark:text-white" }} truncate text-sm font-medium"
                                                >
                                                    {{ $domain }}
                                                </p>
                                                @if ($isCurrentDomain)
                                                    <p class="text-success-600 dark:text-success-400 text-xs">
                                                        Current Domain
                                                    </p>
                                                @endif
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                    </div>
                </x-filament::section>
            @endif

            {{-- API Domains Section --}}
            @if ($licenseInfo && isset($licenseInfo["allowed_api_domains"]))
                <x-filament::section>
                    <x-slot name="heading">API Access Domains</x-slot>

                    <div class="space-y-4">
                        @if (is_null($licenseInfo["max_api_domains"]))
                            <div
                                class="rounded-lg border border-purple-200 bg-purple-50 p-4 dark:border-purple-800 dark:bg-purple-900/20"
                            >
                                <div class="flex items-center space-x-3">
                                    <x-heroicon-o-cpu-chip class="h-5 w-5 text-purple-500" />
                                    <div class="text-sm">
                                        <p class="font-medium text-purple-800 dark:text-purple-200">
                                            Unlimited API Access
                                        </p>
                                        <p class="mt-1 text-purple-700 dark:text-purple-300">
                                            This license allows API access from any domain without restrictions.
                                        </p>
                                    </div>
                                </div>
                            </div>
                        @else
                            <div class="space-y-3">
                                <h4 class="text-sm font-medium text-gray-900 dark:text-white">
                                    Authorized API Domains
                                </h4>
                                <p class="text-xs text-gray-600 dark:text-gray-400">
                                    Domains authorized to make API calls to this panel
                                </p>
                                <div class="grid grid-cols-1 gap-3 md:grid-cols-2 lg:grid-cols-3">
                                    @foreach ($licenseInfo["allowed_api_domains"] as $domain)
                                        @php
                                            $isCurrentDomain = $domain === request()->getHost();
                                        @endphp

                                        <div
                                            class="{{ $isCurrentDomain ? "border-purple-200 bg-purple-50 dark:border-purple-800 dark:bg-purple-900/20" : "border-gray-200 bg-gray-50 dark:border-gray-700 dark:bg-gray-800" }} flex items-center space-x-3 rounded-lg border p-3"
                                        >
                                            @if ($isCurrentDomain)
                                                <x-heroicon-o-check-circle
                                                    class="h-4 w-4 flex-shrink-0 text-purple-500"
                                                />
                                            @else
                                                <x-heroicon-o-cpu-chip class="h-4 w-4 flex-shrink-0 text-gray-400" />
                                            @endif
                                            <div class="min-w-0 flex-1">
                                                <p
                                                    class="{{ $isCurrentDomain ? "text-purple-800 dark:text-purple-200" : "text-gray-900 dark:text-white" }} truncate text-sm font-medium"
                                                >
                                                    {{ $domain }}
                                                </p>
                                                @if ($isCurrentDomain)
                                                    <p class="text-xs text-purple-600 dark:text-purple-400">
                                                        Current API Domain
                                                    </p>
                                                @endif
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                    </div>
                </x-filament::section>
            @endif

            {{-- Addons Section --}}
            @if ($addons && count($addons) > 0)
                <x-filament::section>
                    <x-slot name="heading">Available Addons</x-slot>

                    <div class="grid grid-cols-1 gap-4 md:grid-cols-2 lg:grid-cols-3">
                        @foreach ($addons as $addon)
                            <div
                                class="rounded-lg border border-green-200 bg-green-50 p-4 dark:border-green-800 dark:bg-green-900/20"
                            >
                                <div class="flex items-start justify-between">
                                    <div class="flex items-center space-x-3">
                                        <div class="flex-shrink-0">
                                            <div
                                                class="bg-success-100 dark:bg-success-900/30 flex h-8 w-8 items-center justify-center rounded-full"
                                            >
                                                <x-heroicon-o-puzzle-piece
                                                    class="text-success-600 dark:text-success-400 h-4 w-4"
                                                />
                                            </div>
                                        </div>
                                        <div class="min-w-0 flex-1">
                                            <p class="text-sm font-semibold text-gray-900 dark:text-white">
                                                {{ $addon["name"] ?? $addon["slug"] }}
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </x-filament::section>
            @endif

            {{-- License Details --}}
            @if ($licenseInfo)
                <x-filament::section>
                    <x-slot name="heading">License Information</x-slot>

                    <div class="grid grid-cols-1 gap-4 md:grid-cols-2 lg:grid-cols-3">
                        {{-- License Key --}}
                        <div
                            class="bg-white-50 dark:bg-white-900/20 rounded-lg border border-gray-200 p-4 dark:border-gray-800"
                        >
                            <div class="mb-2 flex items-center space-x-2">
                                <div class="bg-primary-500 h-2 w-2 rounded-full"></div>
                                <span class="text-xs font-medium tracking-wide text-gray-500 uppercase">
                                    License Key
                                </span>
                            </div>
                            <p class="font-mono text-sm text-gray-900 dark:text-white">
                                {{ isset($licenseInfo["license_key"]) ? substr($licenseInfo["license_key"], 0, 8) . "..." . substr($licenseInfo["license_key"], -4) : "Hidden" }}
                            </p>
                        </div>

                        {{-- License Type --}}
                        @if (isset($licenseInfo["license_type"]))
                            <div
                                class="bg-white-50 dark:bg-white-900/20 rounded-lg border border-gray-200 p-4 dark:border-gray-800"
                            >
                                <div class="mb-2 flex items-center space-x-2">
                                    <div class="h-2 w-2 rounded-full bg-blue-500"></div>
                                    <span class="text-xs font-medium tracking-wide text-gray-500 uppercase">
                                        License Type
                                    </span>
                                </div>
                                <p class="text-sm font-semibold text-gray-900 capitalize dark:text-white">
                                    {{ str_replace("_", " ", $licenseInfo["license_type"]) }}
                                </p>
                            </div>
                        @endif

                        {{-- Validation Method --}}
                        @if (isset($licenseInfo["validation_method"]))
                            <div
                                class="bg-white-50 dark:bg-white-900/20 rounded-lg border border-gray-200 p-4 dark:border-gray-800"
                            >
                                <div class="mb-2 flex items-center space-x-2">
                                    <div
                                        class="{{ $licenseInfo["validation_method"] === "online" ? "bg-success-500" : "bg-warning-500" }} h-2 w-2 rounded-full"
                                    ></div>
                                    <span class="text-xs font-medium tracking-wide text-gray-500 uppercase">
                                        Last Validation
                                    </span>
                                </div>
                                <p class="text-sm font-semibold text-gray-900 capitalize dark:text-white">
                                    {{ $licenseInfo["validation_method"] }}
                                </p>
                            </div>
                        @endif

                        {{-- Offline Usage Count --}}
                        @if (isset($licenseInfo["offline_usage_count"]) && $licenseInfo["offline_usage_count"] > 0)
                            <div
                                class="bg-white-50 dark:bg-white-900/20 rounded-lg border border-gray-200 p-4 dark:border-gray-800"
                            >
                                <div class="mb-2 flex items-center space-x-2">
                                    <div class="h-2 w-2 rounded-full bg-orange-500"></div>
                                    <span class="text-xs font-medium tracking-wide text-gray-500 uppercase">
                                        Offline Usage
                                    </span>
                                </div>
                                <p class="text-sm font-semibold text-gray-900 dark:text-white">
                                    {{ $licenseInfo["offline_usage_count"] }}/10 times
                                </p>
                            </div>
                        @endif
                    </div>
                </x-filament::section>
            @endif
        </div>
    </x-filament-panels::page>
</div>
