<div wire:poll.{{ $updateInProgress ? "3" : "30" }}s="refreshProgress" class="space-y-6">
    <x-filament-panels::page>
        {{-- Up to date --}}
        @if ((! $updateAvailable && ! $updateInProgress && $updateInfo) || is_null($updateInfo))
            <x-filament::section>
                <div class="py-12 text-center">
                    <div class="relative">
                        <x-heroicon-o-check-circle class="text-success-500 mx-auto h-20 w-20" />
                        <div class="absolute inset-0 flex items-center justify-center">
                            <div class="bg-success-500 h-12 w-12 animate-ping rounded-full opacity-20"></div>
                        </div>
                    </div>
                    <h3 class="mt-6 text-xl font-bold text-gray-900 dark:text-white">Your application is up to date</h3>
                    <p class="mt-3 text-gray-600 dark:text-gray-400">
                        You’re on the latest version. No action required.
                    </p>
                    <div class="mt-4 flex items-center justify-center gap-4 text-sm text-gray-500">
                        <span>Current: v{{ $updateInfo["current_version"] ?? "Unknown" }}</span>
                        <span>•</span>
                        <span>Last checked: {{ $lastCheckedAt ?? now()->format("M j, Y H:i") }}</span>
                    </div>
                </div>
            </x-filament::section>
        @endif

        {{-- Cards --}}
        @if (($updateAvailable || $updateInProgress) && $updateInfo)
            <x-filament::section>
                <x-slot name="heading">
                    <div class="flex items-center justify-between">
                        <span class="flex items-center gap-2">
                            <x-heroicon-o-arrow-path class="text-primary-500 h-5 w-5" />
                            <span>System Overview</span>
                        </span>
                        <span class="text-xs text-gray-500">
                            Current: v{{ $updateInfo["current_version"] ?? "—" }}
                            <span class="mx-1">•</span>
                            Latest: v{{ $updateInfo["latest_version"] ?? "—" }}
                        </span>
                    </div>
                </x-slot>

                <div class="grid grid-cols-1 gap-4 md:grid-cols-3">
                    {{-- Current Version --}}
                    <div
                        class="bg-white-50 dark:bg-white-900/20 flex items-center gap-3 rounded-lg border border-gray-200 p-4 dark:border-gray-800"
                    >
                        <x-heroicon-o-computer-desktop class="h-8 w-8 text-blue-500" />
                        <div>
                            <p class="text-sm font-medium text-gray-900 dark:text-white">Current Version</p>
                            <p class="text-lg font-semibold">
                                {{ $updateInfo["current_version"] ?? "Unknown" }}
                            </p>
                        </div>
                    </div>

                    {{-- New Version --}}
                    <div
                        class="bg-white-50 dark:bg-white-900/20 flex items-center gap-3 rounded-lg border border-gray-200 p-4 dark:border-gray-800"
                    >
                        <x-heroicon-o-arrow-up-circle class="h-8 w-8 text-emerald-500" />
                        <div>
                            <p class="text-sm font-medium text-gray-900 dark:text-white">New Version</p>
                            <p class="text-lg font-semibold">
                                {{ $updateInfo["latest_version"] ?? ($updateAvailable ? "Unknown" : $updateInfo["current_version"] ?? "Unknown") }}
                            </p>
                        </div>
                    </div>

                    {{-- Update Status --}}
                    <div
                        class="bg-white-50 dark:bg-white-900/20 flex items-center gap-3 rounded-lg border border-gray-200 p-4 dark:border-gray-800"
                    >
                        @if ($updateInProgress)
                            <x-heroicon-o-arrow-path class="h-8 w-8 animate-spin text-amber-500" />
                        @elseif ($updateAvailable)
                            <x-heroicon-o-exclamation-triangle class="h-8 w-8 text-amber-500" />
                        @else
                            <x-heroicon-o-shield-check class="h-8 w-8 text-green-500" />
                        @endif
                        <div>
                            <p class="text-sm font-medium text-gray-900 dark:text-white">Update Status</p>
                            <p class="text-lg font-semibold">
                                @if ($updateInProgress)
                                    <span class="text-amber-600">In Progress</span>
                                @endif

                                @if ($updateAvailable && ! $updateInProgress)
                                    <span class="text-amber-600">Update Available</span>
                                @endif

                                @if (! $updateAvailable && ! $updateInProgress)
                                    <span class="text-green-600">Up to Date</span>
                                @endif
                            </p>
                            @if ($updateInProgress && $currentUpdate)
                                <p class="text-xs text-gray-500 capitalize">
                                    {{ $currentUpdate->status->label() }}
                                </p>
                            @endif
                        </div>
                    </div>
                </div>
            </x-filament::section>
        @endif

        {{-- Progress --}}
        @if ($updateInProgress && $currentUpdate)
            <x-filament::section>
                <x-slot name="heading">
                    <div class="flex items-center gap-2">
                        <x-heroicon-o-arrow-path class="h-5 w-5 animate-spin text-amber-500" />
                        <span class="font-semibold">Update in Progress</span>
                        @if ($currentUpdate->version)
                            <span class="text-xs text-gray-500">v{{ $currentUpdate->version }}</span>
                        @endif
                    </div>
                </x-slot>

                <div class="space-y-4">
                    <div class="flex justify-between text-sm">
                        <span class="flex items-center gap-1 text-gray-700 dark:text-gray-300">
                            <x-heroicon-o-chart-bar class="text-primary-500 h-4 w-4" />
                            Overall Progress
                        </span>
                        <span class="font-medium">{{ $currentUpdate->progress_percentage ?? 0 }}%</span>
                    </div>

                    <div class="h-4 w-full overflow-hidden rounded-full bg-gray-200 dark:bg-gray-700">
                        <div
                            class="from-primary-500 to-primary-600 h-4 rounded-full bg-gradient-to-r transition-all duration-700 ease-out"
                            style="width: {{ $currentUpdate->progress_percentage ?? 0 }}%"
                        ></div>
                    </div>

                    <div
                        class="flex flex-wrap items-center justify-between gap-3 text-xs text-gray-500 dark:text-gray-400"
                    >
                        <div class="flex items-center gap-1 capitalize">
                            <x-heroicon-o-information-circle class="h-4 w-4 text-gray-400" />
                            <span>{{ $currentUpdate->status?->label() ?? "Preparing" }}</span>
                        </div>
                        @if ($currentUpdate->started_at)
                            <div class="flex items-center gap-1">
                                <x-heroicon-o-clock class="h-4 w-4 text-gray-400" />
                                <span>Running {{ $currentUpdate->started_at->diffForHumans(null, true) }}</span>
                            </div>
                        @endif
                    </div>

                    @if ($currentUpdate->status_message)
                        <div
                            class="mt-2 flex items-center gap-2 rounded-lg bg-gray-50 p-3 text-sm text-gray-600 dark:bg-gray-800/60 dark:text-gray-300"
                        >
                            <x-heroicon-o-chat-bubble-left-right class="h-4 w-4 text-gray-400" />
                            <span class="italic">{{ $currentUpdate->status_message }}</span>
                        </div>
                    @endif
                </div>
            </x-filament::section>
        @endif

        {{-- Release Notes --}}
        @if (! $updateInProgress && $updateAvailable && ! empty($updateInfo["release_info"]["changelog"] ?? ""))
            <x-filament::section>
                <x-slot name="heading">
                    <div class="flex items-center gap-3">
                        <div
                            class="flex h-8 w-8 items-center justify-center rounded-lg bg-gradient-to-br from-purple-500 to-purple-600"
                        >
                            <x-heroicon-o-document-text class="h-4 w-4 text-white" />
                        </div>
                        <div>
                            <span class="text-lg font-semibold">Release Notes</span>
                            <p class="text-sm text-gray-500 dark:text-gray-400">What's new in this version</p>
                        </div>
                    </div>
                </x-slot>
                <div class="prose prose-sm prose-gray dark:prose-invert max-w-none space-y-4">
                    <div class="js-markdown">
                        {!! \Illuminate\Support\Str::markdown($updateInfo["release_info"]["changelog"]) !!}
                    </div>
                </div>
            </x-filament::section>
        @endif
    </x-filament-panels::page>

    {{--
        <style>
        /* ---------------- Headings (h2/h3) with badges ---------------- */
        .prose :is(h2, h3) {
        font-weight: 600;
        margin-top: 2rem;
        margin-bottom: 1rem;
        position: relative;
        padding-left: 2.5rem;
        display: flex;
        align-items: center;
        color: rgb(31 41 55);
        }
        
        .prose h2 {
        font-size: 1.125rem;
        }
        
        .prose h3 {
        font-size: 1rem;
        }
        
        .dark .prose :is(h2, h3) {
        color: rgb(229 231 235);
        }
        
        .prose :is(h2, h3)::before {
        content: '';
        position: absolute;
        left: 0;
        top: .125rem;
        width: 1.5rem;
        height: 1.5rem;
        border-radius: .5rem;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #fff;
        font-size: .875rem;
        background: rgb(139 92 246);
        }
        
        .prose :is(h2, h3)[data-type="added"]::before {
        background: linear-gradient(135deg, rgb(16 185 129), rgb(5 150 105));
        content: '✨';
        }
        
        .prose :is(h2, h3)[data-type="fixed"]::before {
        background: linear-gradient(135deg, rgb(59 130 246), rgb(37 99 235));
        content: '🔧';
        }
        
        .prose :is(h2, h3)[data-type="removed"]::before {
        background: linear-gradient(135deg, rgb(239 68 68), rgb(220 38 38));
        content: '🗑️';
        }
        
        .prose :is(h2, h3)[data-type="changed"]::before {
        background: linear-gradient(135deg, rgb(245 158 11), rgb(217 119 6));
        content: '📝';
        }
        
        .prose :is(h2, h3)[data-type="updated"]::before {
        background: linear-gradient(135deg, rgb(139 92 246), rgb(124 58 237));
        content: '⬆️';
        }
        
        /* ---------------- Body text / links / images ---------------- */
        .prose p {
        color: rgb(55 65 81);
        line-height: 1.7;
        margin: .85rem 0;
        }
        
        .dark .prose p {
        color: rgb(209 213 219);
        }
        
        .prose strong {
        color: rgb(17 24 39);
        font-weight: 700;
        }
        
        .dark .prose strong {
        color: #fff;
        }
        
        .prose a {
        color: rgb(79 70 229);
        text-underline-offset: 3px;
        text-decoration-thickness: 2px;
        }
        
        .prose a:hover {
        text-decoration: underline;
        }
        
        .dark .prose a {
        color: rgb(165 180 252);
        }
        
        .prose img {
        border-radius: .5rem;
        max-width: 100%;
        height: auto;
        }
        
        /* ---------------- Lists & task lists ---------------- */
        .prose ul,
        .prose ol {
        margin: 1rem 0 1rem 1rem;
        }
        
        .prose ul {
        list-style: none;
        padding-left: 0;
        }
        
        .prose ul>li {
        position: relative;
        padding-left: 1.25rem;
        margin: .5rem 0;
        color: rgb(55 65 81);
        }
        
        .dark .prose ul>li {
        color: rgb(209 213 219);
        }
        
        .prose ul>li::before {
        content: '';
        position: absolute;
        left: 0;
        top: .7rem;
        width: .375rem;
        height: .375rem;
        background: rgb(139 92 246);
        border-radius: 50%;
        }
        
        .prose ul ul>li::before {
        background: rgb(196 181 253);
        }
        
        .prose ol {
        counter-reset: c;
        list-style: none;
        padding-left: 0;
        }
        
        .prose ol>li {
        counter-increment: c;
        position: relative;
        padding-left: 2rem;
        margin: .5rem 0;
        color: rgb(55 65 81);
        }
        
        .dark .prose ol>li {
        color: rgb(209 213 219);
        }
        
        .prose ol>li::before {
        content: counter(c);
        position: absolute;
        left: 0;
        top: .1rem;
        width: 1.25rem;
        height: 1.25rem;
        display: flex;
        align-items: center;
        justify-content: center;
        background: rgb(139 92 246);
        color: #fff;
        border-radius: 9999px;
        font: 600 .75rem/1 ui-sans-serif, system-ui, Inter;
        }
        
        /* GitHub-style task list checkboxes */
        .prose input[type="checkbox"] {
        appearance: none;
        width: 1rem;
        height: 1rem;
        border: 2px solid rgb(203 213 225);
        border-radius: .25rem;
        margin-right: .5rem;
        vertical-align: middle;
        position: relative;
        top: -1px;
        }
        
        .dark .prose input[type="checkbox"] {
        border-color: rgb(75 85 99);
        background: rgb(31 41 55);
        }
        
        .prose input[type="checkbox"]:checked {
        background: rgb(16 185 129);
        border-color: rgb(16 185 129);
        }
        
        .prose input[type="checkbox"]:checked::after {
        content: '';
        position: absolute;
        left: .22rem;
        top: .02rem;
        width: .25rem;
        height: .5rem;
        border: 2px solid #fff;
        border-top: 0;
        border-left: 0;
        transform: rotate(45deg);
        }
        
        /* ---------------- Blockquotes & HR ---------------- */
        .prose blockquote {
        border-left: 4px solid rgb(139 92 246);
        background: rgba(243 232 255 /.5);
        padding: 1rem 1.25rem;
        border-radius: .25rem;
        color: rgb(107 33 168);
        margin: 1rem 0;
        }
        
        .dark .prose blockquote {
        background: rgba(107 33 168 /.2);
        color: rgb(196 181 253);
        }
        
        .prose hr {
        border: 0;
        height: 1px;
        margin: 2rem 0;
        background: linear-gradient(90deg, transparent, rgb(229 231 235), transparent);
        }
        
        .dark .prose hr {
        background: linear-gradient(90deg, transparent, rgb(55 65 81), transparent);
        }
        
        /* ---------------- Inline code ---------------- */
        .prose :not(pre)>code {
        background: rgb(249 250 251);
        color: rgb(31 41 55);
        border: 1px solid rgb(229 231 235);
        padding: .15rem .4rem;
        border-radius: .25rem;
        font-size: .85em;
        font-weight: 500;
        }
        
        .dark .prose :not(pre)>code {
        background: rgba(107 33 168 /.3);
        color: rgb(196 181 253);
        border-color: transparent;
        }
        
        /* ---------------- Code blocks ---------------- */
        .md-code {
        position: relative;
        margin: 1rem 0;
        }
        
        .md-code pre {
        overflow: auto;
        padding: 2rem 1rem 1rem;
        /* more top padding for badge */
        border-radius: .5rem;
        border: 1px solid rgb(229 231 235);
        background: rgb(249 250 251);
        /* light */
        color: rgb(17 24 39);
        }
        
        .dark .md-code pre {
        background: rgb(31 41 55);
        border-color: rgb(75 85 99);
        color: rgb(243 244 246);
        }
        
        .md-code pre code {
        background: transparent;
        padding: 0;
        font-size: .9rem;
        }
        
        /* Language badge */
        .md-code[data-lang]::after {
        content: attr(data-lang);
        position: absolute;
        top: .35rem;
        left: .75rem;
        font-size: .7rem;
        font-weight: 600;
        text-transform: uppercase;
        padding: .2rem .45rem;
        border-radius: .375rem;
        background: #ffffff;
        color: #111827;
        border: 1px solid rgb(229 231 235);
        box-shadow: 0 1px 1px rgba(0, 0, 0, .04);
        pointer-events: none;
        }
        
        .dark .md-code[data-lang]::after {
        background: rgba(255, 255, 255, .08);
        color: #e5e7eb;
        border: 1px solid rgba(255, 255, 255, .15);
        }
        
        /* Copy button */
        .md-code .md-copy {
        position: absolute;
        top: .35rem;
        right: .5rem;
        font-size: .75rem;
        padding: .25rem .5rem;
        border-radius: .375rem;
        cursor: pointer;
        border: 1px solid rgb(209 213 219);
        background: #ffffff;
        color: #111827;
        }
        
        .md-code .md-copy:hover {
        background: rgb(249 250 251);
        }
        
        .dark .md-code .md-copy {
        background: rgb(31 41 55);
        color: #e5e7eb;
        border-color: rgb(75 85 99);
        }
        
        /* ---------------- Tables ---------------- */
        .md-table-wrap {
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
        border-radius: .5rem;
        }
        
        .prose table {
        width: 100%;
        border-collapse: collapse;
        min-width: 520px;
        font-size: .875rem;
        border: 1px solid rgb(229 231 235);
        border-radius: .5rem;
        overflow: hidden;
        margin: 1rem 0;
        }
        
        .dark .prose table {
        border-color: rgb(75 85 99);
        }
        
        .prose thead {
        background: rgb(249 250 251);
        }
        
        .dark .prose thead {
        background: rgb(31 41 55);
        }
        
        .prose th,
        .prose td {
        padding: .75rem 1rem;
        text-align: left;
        border-top: 1px solid rgb(229 231 235);
        }
        
        .prose th {
        font-weight: 600;
        color: rgb(17 24 39);
        }
        
        .dark .prose th {
        color: #fff;
        border-color: rgb(75 85 99);
        }
        
        .dark .prose td {
        border-color: rgb(75 85 99);
        }
        
        .prose tbody tr:hover {
        background: rgba(249 250 251 /.5);
        }
        
        .dark .prose tbody tr:hover {
        background: rgba(31 41 55 /.5);
        }
        </style>
        
        <script>
        (function() {
        const HEADING_TYPES = ['added', 'fixed', 'removed', 'changed', 'updated'];
        
        const detectType = (text) => {
        const t = (text || '').toLowerCase();
        for (const key of HEADING_TYPES) {
        if (new RegExp(`\\b${key}\\b`).test(t)) return key;
        }
        return null;
        };
        
        const getLang = (codeEl) => {
        const classes = (codeEl.className || '').split(/\s+/);
        for (const c of classes) {
        const m = c.match(/^(?:language|lang)-(.+)$/i);
        if (m) return m[1].toUpperCase();
        }
        const pre = codeEl.closest('pre');
        return pre?.getAttribute('data-lang')?.toUpperCase() || null;
        };
        
        const ensureWrappedPre = (pre) => {
        if (pre.parentElement && pre.parentElement.classList.contains('md-code')) {
        return pre.parentElement;
        }
        const wrap = document.createElement('div');
        wrap.className = 'md-code';
        pre.parentElement.insertBefore(wrap, pre);
        wrap.appendChild(pre);
        return wrap;
        };
        
        const addCopyButton = (wrap, codeEl) => {
        if (wrap.querySelector('.md-copy')) return;
        const btn = document.createElement('button');
        btn.type = 'button';
        btn.className = 'md-copy';
        btn.textContent = 'Copy';
        btn.addEventListener('click', async () => {
        try {
        await navigator.clipboard.writeText(codeEl.innerText);
        const old = btn.textContent;
        btn.textContent = 'Copied!';
        setTimeout(() => btn.textContent = old, 1200);
        } catch {
        btn.textContent = 'Failed';
        setTimeout(() => btn.textContent = 'Copy', 1200);
        }
        });
        wrap.appendChild(btn);
        };
        
        const wrapTables = (root) => {
        root.querySelectorAll(':scope table').forEach(tbl => {
        if (!tbl.parentElement.classList.contains('md-table-wrap')) {
        const wrap = document.createElement('div');
        wrap.className = 'md-table-wrap';
        tbl.parentElement.insertBefore(wrap, tbl);
        wrap.appendChild(tbl);
        }
        });
        };
        
        const enhance = () => {
        const container = document.getElementById('changelog-content');
        if (!container) return;
        
        // Headings
        container.querySelectorAll(':scope :is(h2,h3)').forEach(h => {
        const type = detectType(h.textContent);
        if (type) h.setAttribute('data-type', type);
        });
        
        // Code blocks
        container.querySelectorAll(':scope pre > code').forEach(code => {
        const pre = code.parentElement;
        const wrap = ensureWrappedPre(pre);
        const lang = getLang(code);
        if (lang) {
        wrap.setAttribute('data-lang', lang);
        pre.setAttribute('data-lang', lang);
        }
        addCopyButton(wrap, code);
        });
        
        // Tables
        wrapTables(container);
        };
        
        document.addEventListener('DOMContentLoaded', enhance);
        
        const target = document.getElementById('changelog-content');
        if (target) {
        const mo = new MutationObserver(() => enhance());
        mo.observe(target, {
        childList: true,
        subtree: true
        });
        }
        })();
        </script>
    --}}
</div>
