<?php

declare(strict_types=1);

use App\Http\Controllers\Api\LoginController;
use App\Http\Controllers\MfsTransactionController;
use App\Http\Middleware\InitializeBrandifyByDomain;
use Illuminate\Support\Facades\Route;

Route::prefix('api')->group(function () {
    Route::prefix('app')->group(function () {
        Route::post('login', [LoginController::class, 'login']);
        Route::post('login-with-qr', [LoginController::class, 'loginWithQrCode']);

        Route::middleware(['auth:sanctum'])->group(function () {
            Route::post('logout', [LoginController::class, 'logout']);
            Route::post('sms/store', [MfsTransactionController::class, 'store']);
        });
    });
});

Route::middleware([InitializeBrandifyByDomain::class])->group(function () {
    require base_path('routes/coreapi.php');

    Route::prefix('{brand}')
        ->name('branded.')
        ->group(function () {
            require base_path('routes/coreapi.php');
        });
});
