<?php

declare(strict_types=1);

use App\Http\Controllers\Api\ApiController;
use App\Http\Controllers\Api\OrderboxController;
use App\Http\Controllers\Api\UddoktaPayApiController;
use Illuminate\Support\Facades\Route;

Route::prefix('api')->group(function () {
    Route::get('/', fn () => abort(404))->name('api');
    // Main API Payment Endpoints
    Route::controller(ApiController::class)
        ->middleware('validate.api')
        ->group(function () {
            Route::post('checkout/payment/create', 'checkout')->middleware('ability:payment:checkout');
            Route::post('checkout/payment/verify', 'verify')->middleware('ability:payment:verify');
            Route::post('checkout/payment/refund', 'refund')->middleware('ability:payment:refund');
        });

    // UddoktaPay API
    Route::controller(UddoktaPayApiController::class)->group(function () {
        Route::middleware(['validate.api.uddoktapay'])->group(function () {
            Route::post('checkout/{type?}', 'checkout')->middleware('uddoktapay.ability:payment:checkout');
            Route::post('checkout-v2/{type?}', 'checkoutLatest')->middleware('uddoktapay.ability:payment:checkout');
            Route::post('refund-payment', 'refund')->middleware('uddoktapay.ability:payment:refund');
        });

        Route::middleware('validate.api.verify.uddoktapay')->group(function () {
            Route::post('verify-payment/{invoice_id?}', 'verify')->middleware('uddoktapay.verify.ability:payment:verify');
        });
    });

    // Orderbox Checkout
    Route::controller(OrderboxController::class)
        ->group(function () {
            Route::get('orderbox/checkout/{track_id}', 'checkout')->name('orderbox.checkout');
        });
});
