<?php

declare(strict_types=1);

use App\Http\Controllers\Api\OrderboxController;
use App\Http\Controllers\Gateway\CheckoutController;
use App\Http\Controllers\Gateway\GatewayController;
use App\Http\Controllers\Payment;
use App\Http\Controllers\Payment\LiquidController;
use App\Http\Controllers\TextFileController;
use Illuminate\Support\Facades\Route;
use Revoltify\Gatewayify\Routing\GatewayifyRouteGenerator;

Route::get('{filename}', TextFileController::class)
    ->where('{filename}', '.*\.(txt|xml|html)$')
    ->name('textfile');

Route::controller(Payment\InvoiceController::class)->prefix('invoice')->group(function () {
    Route::get('/pay/{track_id}', 'checkout')->name('invoice.checkout');
});

Route::controller(LiquidController::class)->prefix('liquid')->group(function () {
    Route::get('/pay/{track_id}', 'index')->name('liquid.home');
    Route::post('/pay/{track_id}', 'checkout')->name('liquid.checkout');
});

Route::controller(Payment\PaymentLinkController::class)->prefix('paymentlink')->name('paymentlink.')->group(function () {
    Route::get('/default/{currency?}', 'default')->name('default');
    Route::post('/default', 'store')->name('store');
    Route::get('/pay/{track_id}', 'home')->name('home');
    Route::post('/pay/{track_id}', 'checkout')->name('checkout');
});

// Checkout process routes
Route::prefix('checkout')->name('checkout.')->group(function () {
    // Orderbox routes
    Route::controller(OrderboxController::class)->prefix('orderbox')->name('orderbox.')->group(function () {
        Route::get('success', 'success')->name('success');
    });

    // Liquid routes
    Route::controller(LiquidController::class)->prefix('liquid')->name('liquid.')->group(function () {
        Route::get('success', 'success')->name('success');
    });

    // System routes
    Route::controller(CheckoutController::class)->group(function () {
        Route::get('/success', 'success')->name('success');
        Route::get('/pending', 'pending')->name('pending');
        Route::get('/cancel', 'cancel')->name('cancel');

        Route::prefix('{token}')->where(['token' => '[A-Za-z0-9_-]+'])->group(function () {
            Route::get('/', 'home')->name('home');
            Route::get('/process-cancel', 'processCancel')->name('processCancel');
            Route::get('/process/{code}', 'processGateway')->where(['code' => '[A-Za-z0-9_-]+'])->name('process');
        });
    });
});

// Gatewayify Route
GatewayifyRouteGenerator::create(GatewayController::class)->generate();
