<?php

declare(strict_types=1);

use App\Http\Controllers\FileUploadController;
use App\Http\Controllers\HomeController;
use App\Http\Middleware\InitializeBrandifyByDomain;
use Illuminate\Support\Facades\Route;

Route::get('/', [HomeController::class, 'index'])->name('home');

Route::get('/login', [HomeController::class, 'login'])->name('login');

Route::post('/logout', [HomeController::class, 'logout'])->name('logout');

Route::get('/cron/run/{key}', [HomeController::class, 'runCron'])->name('cron.run');

Route::middleware(['auth'])->group(function () {
    Route::post('/livewire/upload-file', [FileUploadController::class, 'handle'])->name('livewire.upload-file');
});

Route::middleware([InitializeBrandifyByDomain::class, 'set-locale'])->group(function () {
    require base_path('routes/coreweb.php');

    Route::prefix('{brand}')
        ->name('branded.')
        ->group(function () {
            require base_path('routes/coreweb.php');
        });
});
