<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <title>We'll Be Back Soon!</title>
        <style>
            body {
                margin: 0;
                font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
                background-color: #f9fafb;
                color: #2d3748;
                display: flex;
                align-items: center;
                justify-content: center;
                height: 100vh;
                text-align: center;
                padding: 2rem;
            }
            .container {
                max-width: 600px;
            }
            .logo {
                max-width: 240px;
                margin-bottom: 2rem;
                height: auto;
            }
            h1 {
                font-size: 2.5rem;
                margin-bottom: 1rem;
                color: #1a202c;
            }
            p {
                font-size: 1.125rem;
                margin-bottom: 2rem;
                line-height: 1.6;
            }
            .spinner {
                border: 4px solid #e2e8f0;
                border-top: 4px solid #2563eb;
                border-radius: 50%;
                width: 40px;
                height: 40px;
                margin: 0 auto 1.5rem;
                animation: spin 1s linear infinite;
            }
            @keyframes spin {
                0% {
                    transform: rotate(0deg);
                }
                100% {
                    transform: rotate(360deg);
                }
            }
            .footer {
                margin-top: 2.5rem;
                font-size: 0.875rem;
                color: #718096;
            }
            /* Dark mode support */
            @media (prefers-color-scheme: dark) {
                body {
                    background-color: #1a202c;
                    color: #e2e8f0;
                }
                h1 {
                    color: #f7fafc;
                }
                .spinner {
                    border-color: #4a5568;
                    border-top-color: #2563eb;
                }
                .footer {
                    color: #a0aec0;
                }
            }
        </style>
    </head>
    <body>
        <div class="container">
            <img class="logo" src="/assets/images/logo.png" alt="UddoktaPay" />
            <div class="spinner"></div>
            <h1>We'll Be Back Soon!</h1>
            <p>
                We're currently performing scheduled maintenance to improve your experience. We appreciate your patience
                and understanding.
            </p>
            <p>Please check back shortly. Thank you for being with us!</p>
            <div class="footer">&copy; <?php echo e(date("Y")); ?> UddoktaPay. All rights reserved.</div>
        </div>
    </body>
</html>
<?php /**PATH /home/sourovme/pay.sourov.me/resources/views/errors/maintenance.blade.php ENDPATH**/ ?>