@extends("layouts.app")

@push("style")
    <style>
        {{ $themeSettings->gateway_css }}
    </style>
@endpush

@section("content")
    <!-- Full Design -->
    <div
        class="up-container mx-auto max-w-md overflow-hidden p-8 sm:relative sm:flex sm:min-w-[650px] sm:flex-wrap sm:rounded-lg sm:bg-white sm:shadow-lg sm:shadow-[#0057d0]/10"
    >
        <!-- nav -->
        <div
            class="flex h-12 w-full items-center justify-between overflow-hidden rounded-lg bg-white p-5 shadow-md shadow-[#0057d0]/5 sm:bg-[#fbfcff] sm:shadow-none sm:ring-1 sm:ring-[#0057d0]/10"
        >
            <div class="">
                <a href="{{ $gatewayHomeUrl }}">
                    <svg width="19" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path
                            d="M9.5 1C4.80558 1 1 4.80558 1 9.5C1 14.1944 4.80558 18 9.5 18C14.1944 18 18 14.1944 18 9.5C18 4.80558 14.1944 1 9.5 1Z"
                            stroke="#6D7F9A"
                            stroke-width="1.5"
                        ></path>
                        <path
                            d="M10.7749 12.9L7.3749 9.50002L10.7749 6.10002"
                            stroke="#94A9C7"
                            stroke-width="1.5"
                            stroke-linecap="round"
                            stroke-linejoin="round"
                        ></path>
                    </svg>
                </a>
            </div>
            <div class="flex items-center">
                <a href="{{ $gatewayCancelUrl }}">
                    <svg width="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path
                            d="M13 1L1 13"
                            stroke="#94A9C7"
                            stroke-width="2"
                            stroke-linecap="round"
                            stroke-linejoin="round"
                        ></path>
                        <path
                            d="M1 1L13 13"
                            stroke="#6D7F9A"
                            stroke-width="2"
                            stroke-linecap="round"
                            stroke-linejoin="round"
                        ></path>
                    </svg>
                </a>
            </div>
        </div>
        <!--END nav -->

        <!-- Transaction -->
        <div class="w-full">
            <div class="flex flex-col flex-wrap sm:mt-5 sm:flex-row sm:items-center sm:justify-between">
                <div class="mb-4 flex h-20 w-full items-center justify-center sm:mt-0">
                    <img src="{{ $gateway->logo }}" alt="GatewayLogo" class="h-[80%]" />
                </div>
                <div
                    class="flex items-center rounded-lg bg-white px-5 py-3 shadow shadow-[#0057d0]/5 sm:h-[85px] sm:w-[60%] sm:shadow-none sm:ring-1 sm:ring-[#0057d0]/10"
                >
                    <div
                        class="mr-4 flex h-[55px] w-[55px] items-center justify-center rounded-full p-1.5 ring-1 ring-[#0057d0]/10"
                    >
                        <img
                            src="{{ get_file($brandSettings->round_logo) }}"
                            alt="{{ $brandSettings->site_name }}"
                            class="w-[80%]"
                        />
                    </div>
                    <div class="flex flex-col">
                        <h3 class="font-semibold text-[#6D7F9A]">{{ $brandSettings->site_name }}</h3>
                    </div>
                </div>
                <div
                    class="mt-3 flex flex-col rounded-lg bg-white p-4 shadow shadow-[#0057d0]/5 sm:mt-0 sm:h-[85px] sm:w-[35%] sm:items-center sm:justify-center sm:shadow-none sm:ring-1 sm:ring-[#0057d0]/10"
                >
                    <h1 class="text-xl font-semibold text-[#6D7F9A]">
                        {{ show_amount($payment->paymentableAmount(), $gateway->gatewayifyCurrency()) }}
                    </h1>
                    @if ($payment->paymentableDiscount() > 0)
                        <span class="mt-1 text-left text-xs font-medium text-green-600 sm:text-center">
                            {{ __("checkout.bank.discount", ["amount" => show_amount($payment->paymentableDiscount(), $gateway->gatewayifyCurrency(), 4)]) }}
                        </span>
                    @endif

                    @if ($payment->paymentableFee() > 0)
                        <span class="mt-1 text-left text-xs font-medium text-red-600 sm:text-center">
                            {{ __("checkout.bank.charge", ["amount" => show_amount($payment->paymentableFee(), $gateway->gatewayifyCurrency(), 4)]) }}
                        </span>
                    @endif
                </div>
            </div>

            <form method="post" action="{{ $gatewaySuccessUrl }}" enctype="multipart/form-data">
                @csrf
                <!-- Payment Page -->
                <div class="mt-3 overflow-auto rounded-lg bg-white p-5 sm:shadow-none sm:ring-1 sm:ring-[#0057d0]/10">
                    @if ($gateway->description)
                        <div
                            class="mb-4 rounded-md bg-[#e5efff] p-4 text-base leading-relaxed break-words text-[#0057d0]"
                        >
                            {!! $gateway->description !!}
                        </div>
                    @endif

                    <x-bank-form id="{{ $gateway->id }}" />
                    <div class="py-2">
                        <ul>
                            @foreach ($parameters as $key => $params)
                                <li class="flex text-sm">
                                    <div><span class="bank-info-span"></span></div>
                                    <div class="flex w-full justify-between">
                                        <p>
                                            <span class="mr-1 font-semibold text-gray-900">
                                                {{ key_to_word($key) }}:
                                            </span>
                                            <span class="text-gray-700">{{ $params }}</span>
                                        </p>
                                        <a
                                            class="brand-btn mx-2 cursor-pointer rounded-md px-2 py-0.5 text-slate-200"
                                            id="copy"
                                            data-text="{{ $params }}"
                                        >
                                            <img
                                                src="{{ asset("themes/default/assets/images/icon/copy.png") }}"
                                                class="mr-2 inline w-3"
                                                alt="{{ __("checkout.bank.copy") }}"
                                            />
                                            {{ __("checkout.bank.copy") }}
                                        </a>
                                    </div>
                                </li>
                                @if (! $loop->last)
                                    <hr class="my-3" />
                                @endif
                            @endforeach
                        </ul>
                    </div>
                </div>
                <!-- END Payment Page -->
                <div class="mt-5">
                    <button
                        type="submit"
                        id="form_submit"
                        class="brand-btn block w-full rounded-[10px] px-4 py-3.5 text-center font-semibold text-white transition-colors"
                    >
                        {{ __("checkout.bank.submit") }}
                    </button>
                </div>
            </form>
        </div>
        <!--END Transaction -->
    </div>
    <!-- END Full Design -->
@endsection

@push("script")
    @include("partials.copy")

    <script type="module">
        $(document).ready(function () {
            $('form').submit(function () {
                if (this.checkValidity()) {
                    $('#page-overlay').show();
                }
            });
        });
    </script>

    <script>
        {!! $themeSettings->gateway_js !!};
    </script>
@endpush
