<div class="mb-4 grid grid-cols-1 gap-4 sm:grid-cols-2">
    <div class="flex w-full flex-col">
        <h2 class="mb-1 text-sm font-semibold text-gray-800 dark:text-white">
            {{ __("checkout.paymentlink.full_name") }}
            <small class="text-danger">*</small>
        </h2>
        <input
            type="text"
            class="block w-full rounded-lg border border-gray-300 bg-gray-50 p-2.5 text-sm text-gray-900 focus:border-blue-500 focus:ring-blue-500 dark:border-gray-600 dark:bg-gray-700 dark:text-white dark:placeholder-gray-400 dark:focus:border-blue-500 dark:focus:ring-blue-500"
            name="name"
            value="{{ old("name") }}"
            placeholder="{{ __("checkout.paymentlink.full_name") }}"
            required
        />
    </div>
    <div class="flex w-full flex-col">
        <h2 class="mb-1 text-sm font-semibold text-gray-800 dark:text-white">
            {{ __("checkout.paymentlink.email") }}
            <small class="text-danger">*</small>
        </h2>
        <input
            type="text"
            class="block w-full rounded-lg border border-gray-300 bg-gray-50 p-2.5 text-sm text-gray-900 focus:border-blue-500 focus:ring-blue-500 dark:border-gray-600 dark:bg-gray-700 dark:text-white dark:placeholder-gray-400 dark:focus:border-blue-500 dark:focus:ring-blue-500"
            name="email"
            value="{{ old("email") }}"
            placeholder="{{ __("checkout.paymentlink.email") }}"
            required
        />
    </div>
    <div class="flex w-full flex-col">
        <h2 class="mb-1 text-sm font-semibold text-gray-800 dark:text-white">
            {{ __("checkout.paymentlink.phone") }}
            <small class="text-danger">*</small>
        </h2>
        <input
            type="text"
            class="block w-full rounded-lg border border-gray-300 bg-gray-50 p-2.5 text-sm text-gray-900 focus:border-blue-500 focus:ring-blue-500 dark:border-gray-600 dark:bg-gray-700 dark:text-white dark:placeholder-gray-400 dark:focus:border-blue-500 dark:focus:ring-blue-500"
            name="phone"
            value="{{ old("phone") }}"
            placeholder="{{ __("checkout.paymentlink.phone") }}"
            required
        />
    </div>

    @foreach ($formData as $data)
        <div class="flex w-full flex-col">
            <h2 class="mb-1 text-sm font-semibold text-gray-800 dark:text-white">
                {{ $data["name"] }}
                @if ($data["is_required"])
                    <small class="text-danger">*</small>
                @endif
            </h2>
            @if ($data["type"] == "text")
                <input
                    type="text"
                    class="block w-full rounded-lg border border-gray-300 bg-gray-50 p-2.5 text-sm text-gray-900 focus:border-blue-500 focus:ring-blue-500 dark:border-gray-600 dark:bg-gray-700 dark:text-white dark:placeholder-gray-400 dark:focus:border-blue-500 dark:focus:ring-blue-500"
                    name="{{ title_to_key($data["name"]) }}"
                    value="{{ old(title_to_key($data["name"])) }}"
                    placeholder="{{ $data["name"] }}"
                    @if ($data['is_required']) required @endif
                />
            @elseif ($data["type"] == "textarea")
                <textarea
                    rows="4"
                    class="block w-full rounded-lg border border-gray-300 bg-gray-50 p-2.5 text-sm text-gray-900 focus:border-blue-500 focus:ring-blue-500 dark:border-gray-600 dark:bg-gray-700 dark:text-white dark:placeholder-gray-400 dark:focus:border-blue-500 dark:focus:ring-blue-500"
                    name="{{ title_to_key($data["name"]) }}"
                    placeholder="{{ $data["name"] }}"
                    @if ($data['is_required']) required @endif
                >
{{ old(title_to_key($data["name"])) }}</textarea
                >
            @elseif ($data["type"] == "select")
                <select
                    class="block w-full rounded-lg border border-gray-300 bg-gray-50 p-2.5 text-sm text-gray-900 focus:border-blue-500 focus:ring-blue-500 dark:border-gray-600 dark:bg-gray-700 dark:text-white dark:placeholder-gray-400 dark:focus:border-blue-500 dark:focus:ring-blue-500"
                    name="{{ title_to_key($data["name"]) }}"
                    @if ($data['is_required']) required @endif
                >
                    <option value="">{{ __("form.options.select_one") }}</option>
                    @foreach ($data["options"] as $item)
                        <option value="{{ $item }}" @selected($item == old($data["name"]))>{{ $item }}</option>
                    @endforeach
                </select>
            @elseif ($data["type"] == "checkbox")
                <div class="mb-2 flex flex-wrap gap-1">
                    @foreach ($data["options"] as $option)
                        <div class="me-4 flex items-center">
                            <input
                                class="h-4 w-4 rounded border-gray-300 bg-gray-100 text-blue-600 focus:ring-2 focus:ring-blue-500 dark:border-gray-600 dark:bg-gray-700 dark:ring-offset-gray-800 dark:focus:ring-blue-600"
                                name="{{ title_to_key($data["name"]) }}[]"
                                type="checkbox"
                                value="{{ $option }}"
                            />
                            <label class="ms-2 text-sm text-gray-900 dark:text-gray-300">{{ $option }}</label>
                        </div>
                    @endforeach
                </div>
            @elseif ($data["type"] == "radio")
                <div class="mb-2 flex flex-wrap gap-1">
                    @foreach ($data["options"] as $option)
                        <div class="me-4 flex items-center">
                            <input
                                class="h-4 w-4 border-gray-300 bg-gray-100 text-blue-600 focus:ring-2 focus:ring-blue-500 dark:border-gray-600 dark:bg-gray-700 dark:ring-offset-gray-800 dark:focus:ring-blue-600"
                                name="{{ title_to_key($data["name"]) }}"
                                type="radio"
                                value="{{ $option }}"
                                @checked($option == old($data["name"]))
                            />
                            <label class="ms-2 text-sm text-gray-900 dark:text-gray-300">{{ $option }}</label>
                        </div>
                    @endforeach
                </div>
            @elseif ($data["type"] == "file")
                <input
                    class="block w-full cursor-pointer rounded-lg border border-gray-300 bg-gray-50 text-sm text-gray-900 focus:outline-none dark:border-gray-600 dark:bg-gray-700 dark:text-gray-400 dark:placeholder-gray-400"
                    type="file"
                    name="{{ title_to_key($data["name"]) }}"
                    accept="@foreach ($data["extensions"] as $ext).{{ $ext }}, @endforeach"
                    @if ($data['is_required'] == 'required') required @endif
                />
            @endif
        </div>
    @endforeach
</div>
