@extends("layouts.app")

@push("style")
    <style>
        {{ $themeSettings->payment_link_css }}
    </style>
@endpush

@section("content")
    <!-- Full Design -->
    <div
        class="up-container mx-auto max-w-md overflow-hidden p-8 sm:relative sm:min-w-[650px] sm:rounded-lg sm:bg-white sm:shadow-lg sm:shadow-[#0057d0]/10"
    >
        <div class="relative mb-5 flex w-full flex-col">
            <!-- Logo -->
            <div class="mb-5 flex justify-center">
                <img
                    src="{{ get_file($brandSettings->logo) }}"
                    alt="{{ $brandSettings->site_name }}"
                    class="w-56 sm:w-48"
                />
            </div>
            <!-- END Logo -->
            <div class="mb-5 flex justify-center font-semibold">{{ $paymentLink->product_name }}</div>
            <div class="mb-5 flex justify-center">{{ $paymentLink->product_description }}</div>
        </div>
        <!-- form -->
        <form
            method="post"
            action="{{ brand_route("paymentlink.checkout", ["track_id" => $paymentLink->track_id]) }}"
            enctype="multipart/form-data"
        >
            @csrf
            <input type="hidden" name="currency" value="{{ $currency }}" autocomplete="off" />
            <x-payment-link-form id="{{ $paymentLink->id }}" />
            <div class="w-full">
                <button type="submit" class="w-full">
                    <div class="btn-primary w-full">{{ __("checkout.paymentlink.submit") }}</div>
                </button>
            </div>
        </form>
        <!-- END form -->
    </div>
    <!-- END Full Design -->
@endsection

@push("script")
    <script>
        {!! $themeSettings->payment_link_js !!};
    </script>
@endpush
