@extends("layouts.app")

@push("style")
    <style>
        {{ $themeSettings->payment_link_css }}
    </style>
@endpush

@section("content")
    <!-- Full Design -->
    <div
        class="up-container mx-auto max-w-md overflow-hidden p-8 sm:relative sm:flex sm:max-h-[500px] sm:min-w-[650px] sm:rounded-lg sm:bg-white sm:shadow-lg sm:shadow-[#0057d0]/10"
    >
        <div class="bg-svg-effect absolute hidden sm:block">
            <svg width="100%" viewBox="0 0 280 262" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path
                    d="M6.46631 35.0198C29.4166 -13.8481 110.91 -6.9597 142.359 27.4081C173.809 61.7759 184.027 83.7973 212.402 70.9741C240.777 58.1509 276.937 61.5704 278.984 102.35C281.031 143.129 247.855 191.323 195.099 205.585C142.343 219.847 142.359 270.326 72.5387 260.141C34.4719 254.592 33.6005 213.402 38.9764 179.338C44.3523 145.275 -20.1501 91.6885 6.46631 35.0198Z"
                    fill="#F3F8FF"
                ></path>
            </svg>
        </div>

        <div class="relative mb-5 flex w-full flex-col sm:items-start">
            <!-- Logo -->
            <div class="mb-5 flex justify-center">
                <img
                    src="{{ get_file($brandSettings->logo) }}"
                    alt="{{ $brandSettings->site_name }}"
                    class="w-56 sm:w-48"
                />
            </div>
            <!-- END Logo -->

            <!-- Animated Image -->
            <div class="flex max-h-64 justify-center">
                <svg
                    style="width: 100%; transform: scale(1.2)"
                    class="animated sm:ml-[-30px]"
                    id="freepik_stories-generating-new-leads"
                    xmlns="http://www.w3.org/2000/svg"
                    viewBox="0 0 500 500"
                    version="1.1"
                    xmlns:xlink="http://www.w3.org/1999/xlink"
                    xmlns:svgjs="http://svgjs.com/svgjs"
                >
                    <style>
                        svg#freepik_stories-generating-new-leads:not(.animated) .animable {
                            opacity: 0;
                        }

                        svg#freepik_stories-generating-new-leads.animated #freepik--background-simple--inject-49 {
                            animation: 3s Infinite linear wind;
                            animation-delay: 0s;
                        }

                        svg#freepik_stories-generating-new-leads.animated #freepik--Coins--inject-49 {
                            animation: 3s Infinite linear wind;
                            animation-delay: 0s;
                        }

                        svg#freepik_stories-generating-new-leads.animated #freepik--character-5--inject-49 {
                            animation: 1s 1 forwards cubic-bezier(0.36, -0.01, 0.5, 1.38) slideRight;
                            animation-delay: 0s;
                        }

                        svg#freepik_stories-generating-new-leads.animated #freepik--character-4--inject-49 {
                            animation: 1s 1 forwards cubic-bezier(0.36, -0.01, 0.5, 1.38) slideUp;
                            animation-delay: 0s;
                        }

                        svg#freepik_stories-generating-new-leads.animated #freepik--character-3--inject-49 {
                            animation: 1s 1 forwards cubic-bezier(0.36, -0.01, 0.5, 1.38) slideLeft;
                            animation-delay: 0s;
                        }

                        svg#freepik_stories-generating-new-leads.animated #freepik--character-2--inject-49 {
                            animation: 1s 1 forwards cubic-bezier(0.36, -0.01, 0.5, 1.38) slideDown;
                            animation-delay: 0s;
                        }

                        svg#freepik_stories-generating-new-leads.animated #freepik--character-1--inject-49 {
                            animation: 1.5s Infinite linear floating;
                            animation-delay: 0s;
                        }

                        @keyframes wind {
                            0% {
                                transform: rotate(0deg);
                            }

                            25% {
                                transform: rotate(1deg);
                            }

                            75% {
                                transform: rotate(-1deg);
                            }
                        }

                        @keyframes slideRight {
                            0% {
                                opacity: 0;
                                transform: translateX(30px);
                            }

                            100% {
                                opacity: 1;
                                transform: translateX(0);
                            }
                        }

                        @keyframes slideUp {
                            0% {
                                opacity: 0;
                                transform: translateY(30px);
                            }

                            100% {
                                opacity: 1;
                                transform: inherit;
                            }
                        }

                        @keyframes slideLeft {
                            0% {
                                opacity: 0;
                                transform: translateX(-30px);
                            }

                            100% {
                                opacity: 1;
                                transform: translateX(0);
                            }
                        }

                        @keyframes slideDown {
                            0% {
                                opacity: 0;
                                transform: translateY(-30px);
                            }

                            100% {
                                opacity: 1;
                                transform: translateY(0);
                            }
                        }

                        @keyframes floating {
                            0% {
                                opacity: 1;
                                transform: translateY(0px);
                            }

                            50% {
                                transform: translateY(-10px);
                            }

                            100% {
                                opacity: 1;
                                transform: translateY(0px);
                            }
                        }
                    </style>
                    <g
                        id="freepik--background-simple--inject-49"
                        class="animable"
                        style="transform-origin: 259.086px 221.362px"
                    >
                        <path
                            d="M97.2,104.91c27.92-59.45,127.06-51.07,165.32-9.26s50.69,68.6,85.21,53,78.51-11.44,81,38.17S390.86,295.06,326.68,312.41s-64.16,78.76-149.1,66.37c-46.31-6.75-47.37-56.86-40.83-98.3S64.82,173.85,97.2,104.91Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 259.086px 221.362px"
                            id="el4p32x2c6u96"
                            class="animable"
                        ></path>
                        <g id="eluysind4w19k">
                            <path
                                d="M97.2,104.91c27.92-59.45,127.06-51.07,165.32-9.26s50.69,68.6,85.21,53,78.51-11.44,81,38.17S390.86,295.06,326.68,312.41s-64.16,78.76-149.1,66.37c-46.31-6.75-47.37-56.86-40.83-98.3S64.82,173.85,97.2,104.91Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.9; transform-origin: 259.086px 221.362px"
                                class="animable"
                            ></path>
                        </g>
                    </g>
                    <g id="freepik--Shadow--inject-49" class="animable" style="transform-origin: 250px 416.24px">
                        <ellipse
                            id="freepik--path--inject-49"
                            cx="250"
                            cy="416.24"
                            rx="193.89"
                            ry="11.32"
                            style="fill: rgb(245, 245, 245); transform-origin: 250px 416.24px"
                            class="animable"
                        ></ellipse>
                    </g>
                    <g
                        id="freepik--Coins--inject-49"
                        class="animable animator-active"
                        style="transform-origin: 311.587px 347.919px"
                    >
                        <path
                            d="M407.17,392.13a15.52,15.52,0,1,1-21.94.21A15.51,15.51,0,0,1,407.17,392.13Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 396.305px 403.211px"
                            id="el2zpx8lizk7v"
                            class="animable"
                        ></path>
                        <g id="elk3jfvhwzdaq">
                            <path
                                d="M405.58,393.75a13.25,13.25,0,1,1-18.73.18A13.24,13.24,0,0,1,405.58,393.75Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 396.305px 403.21px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M402.06,407.53l1.6,1.57-1.15,1.16-1.58-1.55a8.66,8.66,0,0,1-4.6,2.33l-.81-2.05a7.62,7.62,0,0,0,3.87-1.79l-2.84-2.79c-1.94,1.2-4.12,2.39-6.1.45-1.45-1.42-1.68-3.72.28-6.15l-1.6-1.58,1.14-1.17,1.58,1.55a8.56,8.56,0,0,1,3.71-2l.86,2a8.28,8.28,0,0,0-3,1.55l2.88,2.82c1.93-1.2,4.12-2.43,6.1-.49C403.82,402.77,404,405.07,402.06,407.53Zm-7.24-4.81-2.53-2.49c-.84,1.17-.74,2.1-.12,2.71S393.77,403.31,394.82,402.72Zm5.89.58c-.7-.69-1.64-.38-2.72.23l2.52,2.48C401.38,404.81,401.32,403.9,400.71,403.3Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 396.395px 403.275px"
                            id="eldwxl80ugpq8"
                            class="animable"
                        ></path>
                        <path
                            d="M398.82,389.63l-5.22,3.83a1.1,1.1,0,0,0-.23,1.54l17.11,23.27a1.1,1.1,0,0,0,1.54.24l5.22-3.84a1,1,0,0,0,.24-.25,1.08,1.08,0,0,0,0-1.29l-17.11-23.27a1.12,1.12,0,0,0-1.23-.39A.92.92,0,0,0,398.82,389.63Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 405.424px 404.07px"
                            id="ellccblrfzc4"
                            class="animable"
                        ></path>
                        <g id="elgz142l27af5">
                            <path
                                d="M394.82,394.79l4.74-3.49a.38.38,0,0,1,.52.08.37.37,0,0,1-.08.52l-4.74,3.49,1,1.36,4.74-3.49a.38.38,0,0,1,.52.08.37.37,0,0,1-.08.52l-4.74,3.49,1,1.36,4.74-3.49a.38.38,0,0,1,.52.08.36.36,0,0,1-.08.52l-4.74,3.49,1,1.36,4.74-3.49a.38.38,0,0,1,.52.08.37.37,0,0,1-.07.52l-4.75,3.49,1,1.36,4.75-3.49a.37.37,0,0,1,.44.6L401,403.23l1,1.36,4.75-3.49a.37.37,0,0,1,.44.6l-4.74,3.49,1,1.36,4.74-3.49a.38.38,0,0,1,.52.08.37.37,0,0,1-.08.52l-4.74,3.49,1,1.36,4.74-3.49a.38.38,0,0,1,.52.08.38.38,0,0,1-.08.53l-4.74,3.48,1,1.36,4.74-3.49a.38.38,0,0,1,.52.08.38.38,0,0,1-.08.53l-4.74,3.48,1,1.34,0,0,4.73-3.48a.37.37,0,0,1,.52.07.37.37,0,0,1-.08.53l-4.47,3.28a1,1,0,0,0,.8-.22l3.33-2.33a1.11,1.11,0,0,1,1.57.22l2.41,3.27a1.14,1.14,0,0,1-.23,1.57L412,418.47a1.08,1.08,0,0,1-1.53-.2L393.37,395a1.15,1.15,0,0,1,.24-1.58l.13-.1Z"
                                style="opacity: 0.2; transform-origin: 404.976px 404.966px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="eloirfeq3j2kh">
                            <path
                                d="M399.13,389.47l18.35,24.95a1.08,1.08,0,0,0,0-1.29l-17.11-23.27A1.12,1.12,0,0,0,399.13,389.47Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 408.412px 401.918px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M394.87,411.15v6.47a1.1,1.1,0,0,1-1.1,1.1H364.89a1.11,1.11,0,0,1-1.11-1.1v-6.47a1,1,0,0,1,.06-.35,1.09,1.09,0,0,1,1.05-.76h28.88a1.11,1.11,0,0,1,1,.76A.83.83,0,0,1,394.87,411.15Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 379.325px 414.38px"
                            id="elnn1gotkhgt"
                            class="animable"
                        ></path>
                        <g id="eldg0yl34dzs9">
                            <path
                                d="M393.08,417.43v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,1,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.88a.37.37,0,0,0-.74,0v5.55a1.06,1.06,0,0,1-.3-.77l-.1-4.07a1.09,1.09,0,0,0-1.09-1.13h-4.07a1.14,1.14,0,0,0-1.13,1.11l.07,5.38a1.07,1.07,0,0,0,1.07,1.11h28.87a1.15,1.15,0,0,0,1.13-1.13v-.16Z"
                                style="opacity: 0.2; transform-origin: 379.32px 414.93px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="elwv45f06ujqm">
                            <path
                                d="M394.81,410.8h-31a1.09,1.09,0,0,1,1.05-.76h28.88A1.11,1.11,0,0,1,394.81,410.8Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 379.31px 410.42px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M394.79,402.47v6.47a1.11,1.11,0,0,1-1.1,1.1H364.8a1.1,1.1,0,0,1-1.1-1.1v-6.47a.93.93,0,0,1,.06-.34,1.07,1.07,0,0,1,1-.76h28.89a1.11,1.11,0,0,1,1,.76A.76.76,0,0,1,394.79,402.47Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 379.245px 405.705px"
                            id="elmd861zh1i8o"
                            class="animable"
                        ></path>
                        <g id="el438vpvjoyjh">
                            <path
                                d="M393,408.75v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.74,0v5.89H385.7v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.37-.37.38.38,0,0,0-.37.37v5.89H378.4v-5.89a.38.38,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.89H376v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.37-.37.38.38,0,0,0-.37.37v5.89H371.1v-5.88a.38.38,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.56a1.1,1.1,0,0,1-.3-.78l-.1-4.06a1.09,1.09,0,0,0-1.1-1.14H364.8a1.14,1.14,0,0,0-1.13,1.11l.06,5.38a1.08,1.08,0,0,0,1.08,1.11h28.87a1.15,1.15,0,0,0,1.13-1.12v-.17Z"
                                style="opacity: 0.2; transform-origin: 379.24px 406.25px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="elx2fdrhm0ow">
                            <path
                                d="M394.73,402.13h-31a1.07,1.07,0,0,1,1-.76h28.89A1.11,1.11,0,0,1,394.73,402.13Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 379.23px 401.749px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M393.22,393.79v6.47a1.12,1.12,0,0,1-1.11,1.11H363.23a1.11,1.11,0,0,1-1.1-1.11v-6.47a.76.76,0,0,1,.06-.34,1.07,1.07,0,0,1,1-.76h28.88a1.11,1.11,0,0,1,1.05.76A.93.93,0,0,1,393.22,393.79Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 377.674px 397.03px"
                            id="elbxwmxmbsvyj"
                            class="animable"
                        ></path>
                        <g id="el8i6mv03ryhq">
                            <path
                                d="M391.43,400.07v-5.88a.38.38,0,1,0-.75,0v5.88H389v-5.88a.37.37,0,1,0-.74,0v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0v5.88h-1.68v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,1,0-.74,0v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0v5.88h-1.68v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,1,0-.74,0v5.88H372v-5.88a.38.38,0,1,0-.75,0v5.88h-1.68v-5.88a.38.38,0,1,0-.75,0v5.55a1.13,1.13,0,0,1-.3-.78l-.09-4.06a1.11,1.11,0,0,0-1.1-1.14h-4.06a1.14,1.14,0,0,0-1.13,1.11l.06,5.38a1.08,1.08,0,0,0,1.08,1.11H392.1a1.15,1.15,0,0,0,1.13-1.12v-.17Z"
                                style="opacity: 0.2; transform-origin: 377.685px 397.554px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="els1sadbhbih">
                            <path
                                d="M393.16,393.45h-31a1.07,1.07,0,0,1,1-.76h28.88A1.11,1.11,0,0,1,393.16,393.45Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 377.66px 393.069px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M393.13,385.11v6.47a1.11,1.11,0,0,1-1.1,1.11H363.15a1.11,1.11,0,0,1-1.11-1.11v-6.47a.93.93,0,0,1,.06-.34,1.08,1.08,0,0,1,1-.76H392a1.1,1.1,0,0,1,1,.76A.76.76,0,0,1,393.13,385.11Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 377.585px 388.35px"
                            id="el3bc2tjyxfun"
                            class="animable"
                        ></path>
                        <g id="elin9f2gd6t8a">
                            <path
                                d="M391.34,391.39v-5.88a.37.37,0,1,0-.74,0v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0v5.88h-1.68v-5.88a.38.38,0,1,0-.75,0v5.88H384v-5.88a.37.37,0,1,0-.74,0v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0v5.88h-1.68v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,1,0-.74,0v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0v5.88h-1.68v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,1,0-.74,0v5.55a1.07,1.07,0,0,1-.3-.78l-.1-4.06a1.08,1.08,0,0,0-1.09-1.13h-4.07A1.14,1.14,0,0,0,362,386.2l.07,5.38a1.07,1.07,0,0,0,1.07,1.11H392a1.15,1.15,0,0,0,1.13-1.13v-.17Z"
                                style="opacity: 0.2; transform-origin: 377.565px 388.879px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="eltbhnw5ta84f">
                            <path
                                d="M393.07,384.77h-31a1.08,1.08,0,0,1,1-.76H392A1.1,1.1,0,0,1,393.07,384.77Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 377.57px 384.39px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M396,376.43v6.48a1.1,1.1,0,0,1-1.1,1.1H366.05a1.1,1.1,0,0,1-1.1-1.1v-6.48a1,1,0,0,1,.05-.34,1.09,1.09,0,0,1,1.05-.76h28.88a1.11,1.11,0,0,1,1.05.76A1,1,0,0,1,396,376.43Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 380.478px 379.67px"
                            id="elc21p25th6zp"
                            class="animable"
                        ></path>
                        <g id="el6yfrm32w07">
                            <path
                                d="M394.24,382.72v-5.89a.36.36,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.89h-1.69v-5.89a.37.37,0,0,0-.37-.37.36.36,0,0,0-.37.37v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.36.36,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.89h-1.69v-5.89a.37.37,0,0,0-.37-.37.36.36,0,0,0-.37.37v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.36.36,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.89h-1.69v-5.89a.37.37,0,0,0-.37-.37.36.36,0,0,0-.37.37v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.88a.36.36,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.55a1.11,1.11,0,0,1-.3-.77l-.09-4.07a1.1,1.1,0,0,0-1.1-1.13H366a1.14,1.14,0,0,0-1.13,1.11l.07,5.38a1.07,1.07,0,0,0,1.07,1.11h28.87a1.15,1.15,0,0,0,1.13-1.13v-.16Z"
                                style="opacity: 0.2; transform-origin: 380.44px 380.22px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="el305u6xgp94g">
                            <path
                                d="M396,376.09H365a1.09,1.09,0,0,1,1.05-.76h28.88A1.11,1.11,0,0,1,396,376.09Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 380.5px 375.71px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M394.46,367.76v6.47a1.11,1.11,0,0,1-1.1,1.1H364.47a1.1,1.1,0,0,1-1.1-1.1v-6.47a1,1,0,0,1,.06-.35,1.08,1.08,0,0,1,1-.76h28.89a1.12,1.12,0,0,1,1,.76A.83.83,0,0,1,394.46,367.76Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 378.915px 370.99px"
                            id="elmouqx8dwjd"
                            class="animable"
                        ></path>
                        <g id="el89a8gkpsmu4">
                            <path
                                d="M392.67,374v-5.89a.38.38,0,0,0-.75,0V374h-1.68v-5.89a.38.38,0,0,0-.75,0V374H387.8v-5.89a.37.37,0,0,0-.74,0V374h-1.69v-5.89a.38.38,0,0,0-.75,0V374h-1.68v-5.89a.38.38,0,0,0-.75,0V374H380.5v-5.89a.37.37,0,0,0-.74,0V374h-1.69v-5.89a.38.38,0,0,0-.75,0V374h-1.68v-5.89a.38.38,0,0,0-.75,0V374H373.2v-5.89a.37.37,0,0,0-.74,0V374h-1.69v-5.88a.38.38,0,0,0-.75,0v5.55a1.1,1.1,0,0,1-.29-.77l-.1-4.07a1.1,1.1,0,0,0-1.1-1.13h-4.06a1.14,1.14,0,0,0-1.13,1.11l.06,5.38a1.08,1.08,0,0,0,1.08,1.11h28.87a1.16,1.16,0,0,0,1.13-1.13V374Z"
                                style="opacity: 0.2; transform-origin: 378.91px 371.5px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="elvs4khxgqfl9">
                            <path
                                d="M394.4,367.41h-31a1.08,1.08,0,0,1,1-.76h28.89A1.12,1.12,0,0,1,394.4,367.41Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 378.9px 367.029px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M392.89,359.08v6.47a1.11,1.11,0,0,1-1.11,1.1H362.9a1.1,1.1,0,0,1-1.1-1.1v-6.47a.83.83,0,0,1,.06-.35,1.08,1.08,0,0,1,1-.76h28.88a1.12,1.12,0,0,1,1.05.76A1,1,0,0,1,392.89,359.08Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 377.345px 362.31px"
                            id="el4kh27kvvzmp"
                            class="animable"
                        ></path>
                        <g id="elf21vgqyu1ln">
                            <path
                                d="M391.09,365.36v-5.89a.37.37,0,0,0-.37-.37.38.38,0,0,0-.37.37v5.89h-1.69v-5.89a.38.38,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89H383.8v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89H376.5v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89H369.2v-5.88a.38.38,0,0,0-.75,0V365a1.11,1.11,0,0,1-.3-.77l-.09-4.07a1.1,1.1,0,0,0-1.1-1.13h-4.07a1.15,1.15,0,0,0-1.13,1.11l.07,5.38a1.07,1.07,0,0,0,1.07,1.11h28.87a1.15,1.15,0,0,0,1.13-1.13v-.16Z"
                                style="opacity: 0.2; transform-origin: 377.33px 362.83px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="elfush6rwrxeo">
                            <path
                                d="M392.83,358.73h-31a1.08,1.08,0,0,1,1-.76h28.88A1.12,1.12,0,0,1,392.83,358.73Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 377.33px 358.349px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M392.8,350.4v6.47a1.1,1.1,0,0,1-1.1,1.1H362.82a1.1,1.1,0,0,1-1.11-1.1V350.4a.93.93,0,0,1,.06-.34,1.08,1.08,0,0,1,1.05-.76H391.7a1.1,1.1,0,0,1,1,.76A.76.76,0,0,1,392.8,350.4Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 377.255px 353.635px"
                            id="eltrowh880ba"
                            class="animable"
                        ></path>
                        <g id="el6vhj9vq1n8e">
                            <path
                                d="M391,356.68v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.74,0v5.89H374v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.88a.37.37,0,1,0-.74,0v5.56a1.1,1.1,0,0,1-.3-.78l-.1-4.06a1.09,1.09,0,0,0-1.1-1.14h-4.06a1.14,1.14,0,0,0-1.13,1.11l.07,5.38a1.07,1.07,0,0,0,1.07,1.11h28.87a1.15,1.15,0,0,0,1.13-1.12v-.17Z"
                                style="opacity: 0.2; transform-origin: 377.27px 354.18px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="eldfcpvm7hiou">
                            <path
                                d="M392.74,350.06h-31a1.08,1.08,0,0,1,1.05-.76H391.7A1.1,1.1,0,0,1,392.74,350.06Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 377.24px 349.68px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M394.21,341.72v6.47a1.11,1.11,0,0,1-1.1,1.11H364.23a1.11,1.11,0,0,1-1.11-1.11v-6.47a.93.93,0,0,1,.06-.34,1.08,1.08,0,0,1,1.05-.76h28.88a1.1,1.1,0,0,1,1,.76A.76.76,0,0,1,394.21,341.72Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 378.665px 344.96px"
                            id="el7amudewrvrs"
                            class="animable"
                        ></path>
                        <g id="el5oc9qsy8sjp">
                            <path
                                d="M392.42,348v-5.88a.38.38,0,0,0-.37-.38.37.37,0,0,0-.37.38V348H390v-5.88a.38.38,0,1,0-.75,0V348h-1.68v-5.88a.38.38,0,1,0-.75,0V348h-1.69v-5.88a.37.37,0,1,0-.74,0V348h-1.69v-5.88a.38.38,0,1,0-.75,0V348h-1.68v-5.88a.38.38,0,1,0-.75,0V348h-1.69v-5.88a.37.37,0,1,0-.74,0V348h-1.69v-5.88a.38.38,0,1,0-.75,0V348H373v-5.88a.38.38,0,1,0-.75,0V348h-1.69v-5.88a.37.37,0,1,0-.74,0v5.55a1.09,1.09,0,0,1-.3-.78l-.1-4.06a1.09,1.09,0,0,0-1.1-1.14h-4.06a1.14,1.14,0,0,0-1.13,1.11l.07,5.38a1.07,1.07,0,0,0,1.07,1.11H393.1a1.15,1.15,0,0,0,1.13-1.12V348Z"
                                style="opacity: 0.2; transform-origin: 378.68px 345.484px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="el5u0r16wm85q">
                            <path
                                d="M394.15,341.38h-31a1.08,1.08,0,0,1,1.05-.76h28.88A1.1,1.1,0,0,1,394.15,341.38Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 378.65px 341px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M394.13,333v6.47a1.12,1.12,0,0,1-1.1,1.11H364.14a1.11,1.11,0,0,1-1.1-1.11V333a.76.76,0,0,1,.06-.34,1.07,1.07,0,0,1,1-.76H393a1.11,1.11,0,0,1,1,.76A.93.93,0,0,1,394.13,333Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 378.584px 336.24px"
                            id="elnduroz2688"
                            class="animable"
                        ></path>
                        <g id="elmfhyk20kcf">
                            <path
                                d="M392.34,339.32v-5.88a.38.38,0,1,0-.75,0v5.88h-1.68v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,1,0-.74,0v5.88H385v-5.88a.38.38,0,1,0-.75,0v5.88h-1.68v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,1,0-.74,0v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0v5.88h-1.68v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,1,0-.74,0v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0V339a1.06,1.06,0,0,1-.29-.78l-.1-4.06a1.09,1.09,0,0,0-1.1-1.13h-4.06a1.13,1.13,0,0,0-1.13,1.11l.06,5.38a1.08,1.08,0,0,0,1.08,1.11H393a1.16,1.16,0,0,0,1.13-1.13v-.17Z"
                                style="opacity: 0.2; transform-origin: 378.55px 336.814px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="ely606hpo4zc">
                            <path
                                d="M394.07,332.7h-31a1.07,1.07,0,0,1,1-.76H393A1.11,1.11,0,0,1,394.07,332.7Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 378.57px 332.32px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M360.26,411.15v6.47a1.11,1.11,0,0,1-1.1,1.1H330.28a1.1,1.1,0,0,1-1.11-1.1v-6.47a1,1,0,0,1,.06-.35,1.09,1.09,0,0,1,1-.76h28.88a1.11,1.11,0,0,1,1,.76A.83.83,0,0,1,360.26,411.15Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 344.715px 414.38px"
                            id="elxqjr8qalw5"
                            class="animable"
                        ></path>
                        <g id="el2aajasrqtun">
                            <path
                                d="M358.47,417.43v-5.89a.38.38,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.89H356v-5.89a.38.38,0,0,0-.75,0v5.89H353.6v-5.89a.37.37,0,0,0-.37-.37.38.38,0,0,0-.37.37v5.89h-1.69v-5.89a.38.38,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89H346.3v-5.89a.37.37,0,0,0-.37-.37.38.38,0,0,0-.37.37v5.89h-1.69v-5.89a.38.38,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89H339v-5.89a.37.37,0,0,0-.37-.37.38.38,0,0,0-.37.37v5.89h-1.69v-5.88a.38.38,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.55a1.06,1.06,0,0,1-.3-.77l-.1-4.07a1.09,1.09,0,0,0-1.1-1.13h-4.06a1.14,1.14,0,0,0-1.13,1.11l.07,5.38a1.07,1.07,0,0,0,1.07,1.11h28.87a1.16,1.16,0,0,0,1.13-1.13v-.16Z"
                                style="opacity: 0.2; transform-origin: 344.71px 414.93px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="elk6bv6ngd5cr">
                            <path
                                d="M360.2,410.8h-31a1.09,1.09,0,0,1,1-.76h28.88A1.11,1.11,0,0,1,360.2,410.8Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 344.7px 410.419px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M360.18,402.47v6.47a1.11,1.11,0,0,1-1.1,1.1H330.19a1.1,1.1,0,0,1-1.1-1.1v-6.47a.76.76,0,0,1,.06-.34,1.07,1.07,0,0,1,1-.76h28.89a1.11,1.11,0,0,1,1,.76A.93.93,0,0,1,360.18,402.47Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 344.634px 405.705px"
                            id="eli6zz0crwa8"
                            class="animable"
                        ></path>
                        <g id="ellbhuvby9vxp">
                            <path
                                d="M358.39,408.75v-5.89a.38.38,0,0,0-.75,0v5.89H356v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.88a.38.38,0,0,0-.75,0v5.56a1.1,1.1,0,0,1-.29-.78l-.1-4.06a1.1,1.1,0,0,0-1.1-1.14h-4.06a1.14,1.14,0,0,0-1.13,1.11l.06,5.38A1.08,1.08,0,0,0,330.2,410h28.87a1.15,1.15,0,0,0,1.13-1.12v-.17Z"
                                style="opacity: 0.2; transform-origin: 344.65px 406.225px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="el4tvdle1zc1c">
                            <path
                                d="M360.12,402.13h-31a1.07,1.07,0,0,1,1-.76h28.89A1.11,1.11,0,0,1,360.12,402.13Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 344.62px 401.749px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M360.1,393.79v6.47a1.12,1.12,0,0,1-1.11,1.11H330.11a1.11,1.11,0,0,1-1.1-1.11v-6.47a.76.76,0,0,1,.06-.34,1.07,1.07,0,0,1,1-.76H359a1.11,1.11,0,0,1,1.05.76A.93.93,0,0,1,360.1,393.79Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 344.555px 397.03px"
                            id="el5xxlu55dnts"
                            class="animable"
                        ></path>
                        <g id="eljwjh3c1wmhh">
                            <path
                                d="M358.31,400.07v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,1,0-.74,0v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0v5.88H351v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,1,0-.74,0v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0v5.88h-1.68v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,1,0-.74,0v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0v5.88h-1.68v-5.88a.38.38,0,1,0-.75,0v5.55a1.13,1.13,0,0,1-.3-.78l-.09-4.06a1.11,1.11,0,0,0-1.1-1.14h-4.06a1.14,1.14,0,0,0-1.13,1.11l.06,5.38a1.08,1.08,0,0,0,1.08,1.11H359a1.14,1.14,0,0,0,1.13-1.12v-.17Z"
                                style="opacity: 0.2; transform-origin: 344.55px 397.554px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="elkqlmyvzrmbb">
                            <path
                                d="M360,393.45h-31a1.07,1.07,0,0,1,1-.76H359A1.11,1.11,0,0,1,360,393.45Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 344.5px 393.07px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M360,385.11v6.47a1.11,1.11,0,0,1-1.1,1.11H330a1.11,1.11,0,0,1-1.11-1.11v-6.47a.93.93,0,0,1,.06-.34,1.09,1.09,0,0,1,1-.76h28.88a1.1,1.1,0,0,1,1,.76A.76.76,0,0,1,360,385.11Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 344.445px 388.35px"
                            id="elsn8cqx4oumq"
                            class="animable"
                        ></path>
                        <g id="elzyhliseq7m">
                            <path
                                d="M358.22,391.39v-5.88a.37.37,0,1,0-.74,0v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0v5.88h-1.68v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,1,0-.74,0v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0v5.88h-1.68v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,1,0-.74,0v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0v5.88h-1.68v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,1,0-.74,0v5.55a1.07,1.07,0,0,1-.3-.78l-.1-4.06a1.08,1.08,0,0,0-1.09-1.13H330a1.14,1.14,0,0,0-1.13,1.11l.07,5.38a1.07,1.07,0,0,0,1.07,1.11H358.9a1.15,1.15,0,0,0,1.13-1.13v-.17Z"
                                style="opacity: 0.2; transform-origin: 344.45px 388.879px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="eltl4131cihah">
                            <path
                                d="M360,384.77H329a1.09,1.09,0,0,1,1-.76h28.88A1.1,1.1,0,0,1,360,384.77Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 344.5px 384.389px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M358.44,376.43v6.48a1.11,1.11,0,0,1-1.1,1.1H328.45a1.1,1.1,0,0,1-1.1-1.1v-6.48a.79.79,0,0,1,.06-.34,1.07,1.07,0,0,1,1-.76h28.89a1.11,1.11,0,0,1,1,.76A1,1,0,0,1,358.44,376.43Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 342.895px 379.67px"
                            id="eltm9yt1coskk"
                            class="animable"
                        ></path>
                        <g id="el36m25eno1z9">
                            <path
                                d="M356.65,382.72v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,1,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.88a.38.38,0,0,0-.75,0v5.55a1.06,1.06,0,0,1-.29-.77l-.1-4.07a1.09,1.09,0,0,0-1.1-1.13h-4.06a1.13,1.13,0,0,0-1.13,1.11l.06,5.38a1.08,1.08,0,0,0,1.08,1.11h28.87a1.16,1.16,0,0,0,1.13-1.13v-.16Z"
                                style="opacity: 0.2; transform-origin: 342.89px 380.22px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="el9d46vlp469v">
                            <path
                                d="M358.38,376.09h-31a1.07,1.07,0,0,1,1-.76h28.89A1.11,1.11,0,0,1,358.38,376.09Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 342.88px 375.709px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M358.36,367.76v6.47a1.11,1.11,0,0,1-1.11,1.1H328.37a1.1,1.1,0,0,1-1.1-1.1v-6.47a.83.83,0,0,1,.06-.35,1.08,1.08,0,0,1,1-.76h28.88a1.12,1.12,0,0,1,1.05.76A1,1,0,0,1,358.36,367.76Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 342.815px 370.99px"
                            id="elqpgb5z2i76"
                            class="animable"
                        ></path>
                        <g id="el6vfvuqwjh64">
                            <path
                                d="M356.57,374v-5.89a.38.38,0,0,0-.75,0V374h-1.69v-5.89a.37.37,0,0,0-.74,0V374H351.7v-5.89a.38.38,0,0,0-.75,0V374h-1.68v-5.89a.38.38,0,0,0-.75,0V374h-1.69v-5.89a.37.37,0,0,0-.74,0V374H344.4v-5.89a.38.38,0,0,0-.75,0V374H342v-5.89a.38.38,0,0,0-.75,0V374h-1.69v-5.89a.37.37,0,1,0-.74,0V374H337.1v-5.89a.38.38,0,0,0-.75,0V374h-1.68v-5.88a.38.38,0,0,0-.75,0v5.55a1.11,1.11,0,0,1-.3-.77l-.09-4.07a1.1,1.1,0,0,0-1.1-1.13h-4.06a1.14,1.14,0,0,0-1.13,1.11l.06,5.38a1.08,1.08,0,0,0,1.08,1.11h28.86a1.16,1.16,0,0,0,1.14-1.13V374Z"
                                style="opacity: 0.2; transform-origin: 342.81px 371.5px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="el2k6v2yem569">
                            <path
                                d="M358.3,367.41h-31a1.08,1.08,0,0,1,1-.76h28.88A1.12,1.12,0,0,1,358.3,367.41Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 342.8px 367.029px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M358.27,359.08v6.47a1.1,1.1,0,0,1-1.1,1.1H328.29a1.11,1.11,0,0,1-1.11-1.1v-6.47a1,1,0,0,1,.06-.35,1.1,1.1,0,0,1,1.05-.76h28.88a1.11,1.11,0,0,1,1,.76A.83.83,0,0,1,358.27,359.08Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 342.725px 362.31px"
                            id="eljps68utgjf"
                            class="animable"
                        ></path>
                        <g id="elxvjr4vs0l9n">
                            <path
                                d="M356.48,365.36v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89H337v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.88a.37.37,0,0,0-.74,0V365a1.06,1.06,0,0,1-.3-.77l-.1-4.07a1.09,1.09,0,0,0-1.09-1.13h-4.07a1.14,1.14,0,0,0-1.13,1.11l.07,5.38a1.07,1.07,0,0,0,1.07,1.11h28.87a1.15,1.15,0,0,0,1.13-1.13v-.16Z"
                                style="opacity: 0.2; transform-origin: 342.7px 362.83px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="elz7544f1g36">
                            <path
                                d="M358.21,358.73h-31a1.1,1.1,0,0,1,1.05-.76h28.88A1.11,1.11,0,0,1,358.21,358.73Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 342.71px 358.35px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M359.68,350.4v6.47a1.1,1.1,0,0,1-1.1,1.1H329.7a1.11,1.11,0,0,1-1.11-1.1V350.4a.93.93,0,0,1,.06-.34,1.08,1.08,0,0,1,1.05-.76h28.88a1.1,1.1,0,0,1,1,.76A.76.76,0,0,1,359.68,350.4Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 344.135px 353.635px"
                            id="elvum57zh1pz"
                            class="animable"
                        ></path>
                        <g id="ell6st496fkf8">
                            <path
                                d="M357.89,356.68v-5.89a.37.37,0,1,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89H353v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,1,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89H336v-5.88a.37.37,0,0,0-.74,0v5.56a1.1,1.1,0,0,1-.3-.78l-.1-4.06a1.09,1.09,0,0,0-1.09-1.14h-4.07a1.14,1.14,0,0,0-1.13,1.11l.07,5.38A1.07,1.07,0,0,0,329.7,358h28.87a1.15,1.15,0,0,0,1.13-1.12v-.17Z"
                                style="opacity: 0.2; transform-origin: 344.135px 354.19px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="el1dnovu69zn">
                            <path
                                d="M359.62,350.06h-31a1.08,1.08,0,0,1,1.05-.76h28.88A1.1,1.1,0,0,1,359.62,350.06Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 344.12px 349.68px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M359.6,341.72v6.47a1.12,1.12,0,0,1-1.1,1.11H329.61a1.11,1.11,0,0,1-1.1-1.11v-6.47a.93.93,0,0,1,.06-.34,1.07,1.07,0,0,1,1-.76H358.5a1.11,1.11,0,0,1,1,.76A.76.76,0,0,1,359.6,341.72Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 344.055px 344.96px"
                            id="eldd8adm6edd7"
                            class="animable"
                        ></path>
                        <g id="elw5u06e0gu8o">
                            <path
                                d="M357.81,348v-5.88a.38.38,0,1,0-.75,0V348h-1.68v-5.88a.38.38,0,1,0-.75,0V348h-1.69v-5.88a.37.37,0,1,0-.74,0V348h-1.69v-5.88a.38.38,0,1,0-.75,0V348h-1.68v-5.88a.38.38,0,1,0-.75,0V348h-1.69v-5.88a.37.37,0,1,0-.74,0V348h-1.69v-5.88a.38.38,0,1,0-.75,0V348h-1.68v-5.88a.38.38,0,1,0-.75,0V348h-1.69v-5.88a.37.37,0,1,0-.74,0V348h-1.69v-5.88a.38.38,0,1,0-.75,0v5.55a1.12,1.12,0,0,1-.29-.78l-.1-4.06a1.1,1.1,0,0,0-1.1-1.14h-4.06a1.14,1.14,0,0,0-1.13,1.11l.06,5.38a1.08,1.08,0,0,0,1.08,1.11h28.87a1.15,1.15,0,0,0,1.13-1.12V348Z"
                                style="opacity: 0.2; transform-origin: 344.05px 345.484px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="el5zwfi2auzam">
                            <path
                                d="M359.54,341.38h-31a1.07,1.07,0,0,1,1-.76H358.5A1.11,1.11,0,0,1,359.54,341.38Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 344.04px 341px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M359.52,333v6.47a1.12,1.12,0,0,1-1.11,1.11H329.53a1.11,1.11,0,0,1-1.1-1.11V333a.76.76,0,0,1,.06-.34,1.07,1.07,0,0,1,1-.76h28.88a1.11,1.11,0,0,1,1,.76A.93.93,0,0,1,359.52,333Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 343.974px 336.24px"
                            id="el8b886k8vt4q"
                            class="animable"
                        ></path>
                        <g id="elua4etgr8z0h">
                            <path
                                d="M357.73,339.32v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,0,0-.37-.38.38.38,0,0,0-.37.38v5.88h-1.69v-5.88a.38.38,0,0,0-.37-.38.37.37,0,0,0-.37.38v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0v5.88H348v-5.88a.37.37,0,0,0-.37-.38.38.38,0,0,0-.37.38v5.88h-1.69v-5.88a.38.38,0,0,0-.37-.38.37.37,0,0,0-.37.38v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,0,0-.37-.38.38.38,0,0,0-.37.38v5.88h-1.69v-5.88a.38.38,0,0,0-.37-.38.37.37,0,0,0-.37.38v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0V339a1.06,1.06,0,0,1-.29-.78l-.1-4.06a1.1,1.1,0,0,0-1.1-1.13h-4.06a1.13,1.13,0,0,0-1.13,1.11l.06,5.38a1.08,1.08,0,0,0,1.08,1.11h28.87a1.16,1.16,0,0,0,1.13-1.13v-.17Z"
                                style="opacity: 0.2; transform-origin: 343.98px 336.814px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="elor1gj4my6ck">
                            <path
                                d="M359.46,332.7h-31a1.07,1.07,0,0,1,1-.76h28.88A1.11,1.11,0,0,1,359.46,332.7Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 343.96px 332.319px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M360.93,324.36v6.48a1.11,1.11,0,0,1-1.11,1.1H330.94a1.1,1.1,0,0,1-1.1-1.1v-6.48a.79.79,0,0,1,.06-.34,1.07,1.07,0,0,1,1-.76h28.88a1.11,1.11,0,0,1,1.05.76A1,1,0,0,1,360.93,324.36Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 345.385px 327.6px"
                            id="el00f9p82a97jba"
                            class="animable"
                        ></path>
                        <g id="elamfp0i9bo84">
                            <path
                                d="M359.14,330.65v-5.89a.38.38,0,0,0-.75,0v5.89H356.7v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89H349.4v-5.89a.37.37,0,0,0-.74,0v5.89H347v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89H342.1v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.88a.38.38,0,0,0-.75,0v5.55a1.11,1.11,0,0,1-.3-.77l-.09-4.07a1.1,1.1,0,0,0-1.1-1.13h-4.06a1.13,1.13,0,0,0-1.13,1.11l.06,5.38a1.08,1.08,0,0,0,1.08,1.11h28.87a1.16,1.16,0,0,0,1.13-1.13v-.16Z"
                                style="opacity: 0.2; transform-origin: 345.38px 328.15px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="elxa1uctib4hh">
                            <path
                                d="M360.87,324h-31a1.07,1.07,0,0,1,1-.76h28.88A1.11,1.11,0,0,1,360.87,324Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 345.37px 323.619px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M360.84,315.69v6.47a1.1,1.1,0,0,1-1.1,1.1H330.86a1.11,1.11,0,0,1-1.11-1.1v-6.47a1,1,0,0,1,.06-.35,1.1,1.1,0,0,1,1.05-.76h28.88a1.1,1.1,0,0,1,1,.76A.83.83,0,0,1,360.84,315.69Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 345.295px 318.92px"
                            id="el98j0n9cyeno"
                            class="animable"
                        ></path>
                        <g id="elzy0urxej87">
                            <path
                                d="M359.05,322v-5.89a.37.37,0,0,0-.37-.37.38.38,0,0,0-.37.37V322h-1.69v-5.89a.38.38,0,0,0-.37-.37.37.37,0,0,0-.37.37V322h-1.69v-5.89a.38.38,0,0,0-.75,0V322h-1.69v-5.89a.37.37,0,0,0-.37-.37.38.38,0,0,0-.37.37V322h-1.69v-5.89a.38.38,0,0,0-.37-.37.37.37,0,0,0-.37.37V322h-1.69v-5.89a.38.38,0,0,0-.75,0V322h-1.69v-5.89a.37.37,0,0,0-.37-.37.38.38,0,0,0-.37.37V322H342v-5.89a.38.38,0,0,0-.37-.37.37.37,0,0,0-.37.37V322h-1.69v-5.89a.38.38,0,0,0-.75,0V322h-1.69v-5.88a.37.37,0,0,0-.37-.37.38.38,0,0,0-.37.37v5.55a1.06,1.06,0,0,1-.3-.77l-.09-4.07a1.1,1.1,0,0,0-1.1-1.13h-4.07a1.14,1.14,0,0,0-1.13,1.11l.07,5.38a1.07,1.07,0,0,0,1.07,1.11h28.87a1.15,1.15,0,0,0,1.13-1.13V322Z"
                                style="opacity: 0.2; transform-origin: 345.27px 319.5px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="elfn67d9db6il">
                            <path
                                d="M360.78,315.34h-31a1.1,1.1,0,0,1,1.05-.76h28.88A1.1,1.1,0,0,1,360.78,315.34Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 345.28px 314.96px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M357.78,307v6.47a1.11,1.11,0,0,1-1.11,1.1H327.79a1.1,1.1,0,0,1-1.1-1.1V307a.83.83,0,0,1,.06-.35,1.08,1.08,0,0,1,1-.76h28.88a1.12,1.12,0,0,1,1.05.76A1,1,0,0,1,357.78,307Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 342.235px 310.23px"
                            id="el8sbp48lglef"
                            class="animable"
                        ></path>
                        <g id="elxkl9s4yhvta">
                            <path
                                d="M356,313.29V307.4a.38.38,0,0,0-.75,0v5.89h-1.69V307.4a.37.37,0,0,0-.37-.37.38.38,0,0,0-.37.37v5.89h-1.69V307.4a.38.38,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.89h-1.69V307.4a.38.38,0,0,0-.75,0v5.89h-1.69V307.4a.37.37,0,0,0-.37-.37.38.38,0,0,0-.37.37v5.89h-1.69V307.4a.38.38,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.89h-1.69V307.4a.38.38,0,0,0-.75,0v5.89H339V307.4a.37.37,0,0,0-.37-.37.38.38,0,0,0-.37.37v5.89h-1.69V307.4a.38.38,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.89h-1.69V307.4a.38.38,0,0,0-.75,0V313a1.06,1.06,0,0,1-.29-.77l-.1-4.07a1.1,1.1,0,0,0-1.1-1.13h-4.06a1.14,1.14,0,0,0-1.13,1.11l.06,5.38a1.08,1.08,0,0,0,1.08,1.11h28.87a1.16,1.16,0,0,0,1.13-1.13v-.16Z"
                                style="opacity: 0.2; transform-origin: 342.28px 310.83px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="el8xrg46nmnzg">
                            <path
                                d="M357.72,306.66h-31a1.08,1.08,0,0,1,1-.76h28.88A1.12,1.12,0,0,1,357.72,306.66Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 342.22px 306.279px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M360.68,298.33v6.47a1.11,1.11,0,0,1-1.1,1.1H330.69a1.1,1.1,0,0,1-1.1-1.1v-6.47a.76.76,0,0,1,.06-.34,1.07,1.07,0,0,1,1-.76h28.89a1.11,1.11,0,0,1,1,.76A.93.93,0,0,1,360.68,298.33Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 345.134px 301.565px"
                            id="ell7d8oxoka78"
                            class="animable"
                        ></path>
                        <g id="elnqr60qdsmv9">
                            <path
                                d="M358.89,304.61v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89H354v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.74,0v5.89H337v-5.88a.38.38,0,0,0-.75,0v5.56a1.1,1.1,0,0,1-.29-.78l-.1-4.06a1.1,1.1,0,0,0-1.1-1.14h-4.06a1.14,1.14,0,0,0-1.13,1.11l.06,5.38a1.08,1.08,0,0,0,1.08,1.11h28.87a1.15,1.15,0,0,0,1.13-1.12v-.17Z"
                                style="opacity: 0.2; transform-origin: 345.14px 302.11px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="el1xgikizw3bk">
                            <path
                                d="M360.62,298h-31a1.07,1.07,0,0,1,1-.76h28.89A1.11,1.11,0,0,1,360.62,298Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 345.12px 297.619px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M360.6,289.65v6.47a1.12,1.12,0,0,1-1.11,1.11H330.61a1.11,1.11,0,0,1-1.1-1.11v-6.47a.76.76,0,0,1,.06-.34,1.07,1.07,0,0,1,1-.76h28.88a1.11,1.11,0,0,1,1.05.76A.93.93,0,0,1,360.6,289.65Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 345.054px 292.89px"
                            id="elyqnue5cxdfs"
                            class="animable"
                        ></path>
                        <g id="elvvqkwf1vqm">
                            <path
                                d="M358.81,295.93v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,1,0-.74,0v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0v5.88h-1.68v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,1,0-.74,0v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0v5.88h-1.68v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,1,0-.74,0v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0v5.88h-1.68v-5.88a.38.38,0,1,0-.75,0v5.55a1.13,1.13,0,0,1-.3-.78l-.09-4.06a1.11,1.11,0,0,0-1.1-1.14h-4.06a1.14,1.14,0,0,0-1.13,1.11l.06,5.38a1.08,1.08,0,0,0,1.08,1.11h28.86a1.16,1.16,0,0,0,1.14-1.12v-.17Z"
                                style="opacity: 0.2; transform-origin: 345.05px 293.414px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="el1uy8vtd59hq">
                            <path
                                d="M360.54,289.31h-31a1.07,1.07,0,0,1,1-.76h28.88A1.11,1.11,0,0,1,360.54,289.31Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 345.04px 288.929px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M359,281v6.47a1.11,1.11,0,0,1-1.1,1.11H329a1.1,1.1,0,0,1-1.11-1.11V281a.93.93,0,0,1,.06-.34,1.08,1.08,0,0,1,1.05-.76h28.88a1.1,1.1,0,0,1,1,.76A.76.76,0,0,1,359,281Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 343.445px 284.24px"
                            id="el7xf4kpun99q"
                            class="animable"
                        ></path>
                        <g id="elpkuabjavn0s">
                            <path
                                d="M357.23,287.25v-5.88a.38.38,0,0,0-.37-.38.37.37,0,0,0-.37.38v5.88H354.8v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88A.37.37,0,0,0,352,281a.38.38,0,0,0-.37.38v5.88h-1.69v-5.88a.38.38,0,0,0-.37-.38.37.37,0,0,0-.37.38v5.88H347.5v-5.88a.38.38,0,1,0-.75,0v5.88h-1.68v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,1,0-.74,0v5.88H340.2v-5.88a.38.38,0,1,0-.75,0v5.88h-1.68v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,1,0-.74,0v5.55a1.07,1.07,0,0,1-.3-.78l-.1-4.06a1.09,1.09,0,0,0-1.1-1.13H329a1.14,1.14,0,0,0-1.13,1.11l.07,5.38a1.07,1.07,0,0,0,1.07,1.11h28.87a1.15,1.15,0,0,0,1.13-1.13v-.17Z"
                                style="opacity: 0.2; transform-origin: 343.44px 284.744px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="elj7ea1dc11ok">
                            <path
                                d="M359,280.63H328a1.08,1.08,0,0,1,1.05-.76h28.88A1.1,1.1,0,0,1,359,280.63Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 343.5px 280.25px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M358.94,272.29v6.48a1.11,1.11,0,0,1-1.1,1.1H329a1.1,1.1,0,0,1-1.1-1.1v-6.48a.79.79,0,0,1,.06-.34,1.07,1.07,0,0,1,1-.76h28.89a1.11,1.11,0,0,1,1,.76A1,1,0,0,1,358.94,272.29Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 343.42px 275.53px"
                            id="el7tohqy8qt6q"
                            class="animable"
                        ></path>
                        <g id="el1vkrpv78qx">
                            <path
                                d="M357.15,278.58v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,1,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89H345v-5.89a.37.37,0,1,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.88a.38.38,0,0,0-.75,0v5.55a1.06,1.06,0,0,1-.29-.77l-.1-4.07a1.09,1.09,0,0,0-1.1-1.13H329a1.13,1.13,0,0,0-1.13,1.11l.06,5.38a1.08,1.08,0,0,0,1.08,1.11h28.87a1.16,1.16,0,0,0,1.13-1.13v-.16Z"
                                style="opacity: 0.2; transform-origin: 343.44px 276.08px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="elyutgkarvt9">
                            <path
                                d="M358.88,272h-31a1.07,1.07,0,0,1,1-.76h28.89A1.11,1.11,0,0,1,358.88,272Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 343.38px 271.619px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M325.65,411.15v6.47a1.11,1.11,0,0,1-1.1,1.1H295.66a1.1,1.1,0,0,1-1.1-1.1v-6.47a.83.83,0,0,1,.06-.35,1.08,1.08,0,0,1,1-.76h28.89a1.12,1.12,0,0,1,1,.76A.83.83,0,0,1,325.65,411.15Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 310.105px 414.38px"
                            id="elvdwxnow2zbn"
                            class="animable"
                        ></path>
                        <g id="el3kmhgaxr9pe">
                            <path
                                d="M323.86,417.43v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89H319v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,1,0-.74,0v5.89H302v-5.88a.38.38,0,0,0-.75,0v5.55a1.06,1.06,0,0,1-.29-.77l-.1-4.07a1.1,1.1,0,0,0-1.1-1.13h-4.06a1.14,1.14,0,0,0-1.13,1.11l.06,5.38a1.08,1.08,0,0,0,1.08,1.11h28.87a1.16,1.16,0,0,0,1.13-1.13v-.16Z"
                                style="opacity: 0.2; transform-origin: 310.14px 414.93px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="elfifmlyz620t">
                            <path
                                d="M325.59,410.8h-31a1.08,1.08,0,0,1,1-.76h28.89A1.12,1.12,0,0,1,325.59,410.8Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 310.09px 410.419px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M322.58,402.47v6.47a1.1,1.1,0,0,1-1.1,1.1H292.6a1.11,1.11,0,0,1-1.11-1.1v-6.47a.93.93,0,0,1,.06-.34,1.08,1.08,0,0,1,1.05-.76h28.88a1.1,1.1,0,0,1,1,.76A.76.76,0,0,1,322.58,402.47Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 307.035px 405.705px"
                            id="ely7whlyy1tvi"
                            class="animable"
                        ></path>
                        <g id="elj4vck3r1vw">
                            <path
                                d="M320.79,408.75v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.88a.37.37,0,0,0-.74,0v5.56a1.1,1.1,0,0,1-.3-.78l-.1-4.06a1.09,1.09,0,0,0-1.1-1.14h-4.06a1.14,1.14,0,0,0-1.13,1.11l.07,5.38A1.07,1.07,0,0,0,292.6,410h28.87a1.15,1.15,0,0,0,1.13-1.12v-.17Z"
                                style="opacity: 0.2; transform-origin: 307.03px 406.225px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="elsglctcroqfm">
                            <path
                                d="M322.52,402.13h-31a1.08,1.08,0,0,1,1.05-.76h28.88A1.1,1.1,0,0,1,322.52,402.13Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 307.02px 401.75px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M325.48,393.79v6.47a1.11,1.11,0,0,1-1.1,1.11H295.5a1.11,1.11,0,0,1-1.11-1.11v-6.47a.93.93,0,0,1,.06-.34,1.09,1.09,0,0,1,1.05-.76h28.88a1.09,1.09,0,0,1,1,.76A.76.76,0,0,1,325.48,393.79Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 309.935px 397.03px"
                            id="eluo6pqmw0exh"
                            class="animable"
                        ></path>
                        <g id="elalu4m2f91hv">
                            <path
                                d="M323.69,400.07v-5.88a.37.37,0,0,0-.37-.38.38.38,0,0,0-.37.38v5.88h-1.69v-5.88a.38.38,0,0,0-.37-.38.37.37,0,0,0-.37.38v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,0,0-.37-.38.38.38,0,0,0-.37.38v5.88H314v-5.88a.38.38,0,0,0-.37-.38.37.37,0,0,0-.37.38v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,0,0-.37-.38.38.38,0,0,0-.37.38v5.88h-1.69v-5.88a.38.38,0,0,0-.37-.38.37.37,0,0,0-.37.38v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,0,0-.37-.38.38.38,0,0,0-.37.38v5.55a1.09,1.09,0,0,1-.3-.78l-.09-4.06a1.11,1.11,0,0,0-1.1-1.14h-4.07a1.14,1.14,0,0,0-1.13,1.11l.07,5.38a1.07,1.07,0,0,0,1.07,1.11h28.87a1.15,1.15,0,0,0,1.13-1.12v-.17Z"
                                style="opacity: 0.2; transform-origin: 309.97px 397.554px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="elb2eaituladb">
                            <path
                                d="M325.42,393.45h-31a1.09,1.09,0,0,1,1.05-.76h28.88A1.09,1.09,0,0,1,325.42,393.45Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 309.92px 393.07px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M326.89,385.11v6.47a1.11,1.11,0,0,1-1.1,1.11H296.91a1.11,1.11,0,0,1-1.11-1.11v-6.47a.93.93,0,0,1,.06-.34,1.09,1.09,0,0,1,1.05-.76h28.88a1.09,1.09,0,0,1,1,.76A.76.76,0,0,1,326.89,385.11Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 311.345px 388.35px"
                            id="elxuwa3587b5g"
                            class="animable"
                        ></path>
                        <g id="elo2olo7cj3pg">
                            <path
                                d="M325.1,391.39v-5.88a.37.37,0,1,0-.74,0v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0v5.88h-1.68v-5.88a.38.38,0,1,0-.75,0v5.88H317.8v-5.88a.37.37,0,1,0-.74,0v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0v5.88h-1.68v-5.88a.38.38,0,1,0-.75,0v5.88H310.5v-5.88a.37.37,0,1,0-.74,0v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0v5.88h-1.68v-5.88a.38.38,0,1,0-.75,0v5.88H303.2v-5.88a.37.37,0,0,0-.37-.38.38.38,0,0,0-.37.38v5.55a1.07,1.07,0,0,1-.3-.78l-.1-4.06a1.08,1.08,0,0,0-1.09-1.13H296.9a1.14,1.14,0,0,0-1.13,1.11l.07,5.38a1.07,1.07,0,0,0,1.07,1.11h28.87a1.15,1.15,0,0,0,1.13-1.13v-.17Z"
                                style="opacity: 0.2; transform-origin: 311.34px 388.879px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="el3wmflphkhtc">
                            <path
                                d="M326.83,384.77h-31a1.09,1.09,0,0,1,1.05-.76h28.88A1.09,1.09,0,0,1,326.83,384.77Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 311.33px 384.39px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M326.81,376.43v6.48a1.11,1.11,0,0,1-1.1,1.1H296.82a1.1,1.1,0,0,1-1.1-1.1v-6.48a1,1,0,0,1,.06-.34,1.08,1.08,0,0,1,1-.76h28.89a1.11,1.11,0,0,1,1,.76A.79.79,0,0,1,326.81,376.43Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 311.265px 379.67px"
                            id="elpcvcz1crt4a"
                            class="animable"
                        ></path>
                        <g id="elg4mw3rqfywa">
                            <path
                                d="M325,382.72v-5.89a.37.37,0,0,0-.37-.37.36.36,0,0,0-.37.37v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.36.36,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.89h-1.69v-5.89a.37.37,0,0,0-.37-.37.36.36,0,0,0-.37.37v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.36.36,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.89h-1.69v-5.89a.37.37,0,0,0-.37-.37.36.36,0,0,0-.37.37v5.89H308v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.36.36,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.89h-1.69v-5.88a.37.37,0,0,0-.37-.37.36.36,0,0,0-.37.37v5.55a1.06,1.06,0,0,1-.3-.77l-.1-4.07a1.09,1.09,0,0,0-1.1-1.13h-4.06a1.14,1.14,0,0,0-1.13,1.11l.06,5.38a1.08,1.08,0,0,0,1.08,1.11H325.7a1.16,1.16,0,0,0,1.13-1.13v-.16Z"
                                style="opacity: 0.2; transform-origin: 311.265px 380.22px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="elri7cm3j6vx">
                            <path
                                d="M326.75,376.09h-31a1.08,1.08,0,0,1,1-.76h28.89A1.11,1.11,0,0,1,326.75,376.09Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 311.25px 375.709px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M326.73,367.76v6.47a1.11,1.11,0,0,1-1.1,1.1H296.74a1.1,1.1,0,0,1-1.1-1.1v-6.47a.83.83,0,0,1,.06-.35,1.08,1.08,0,0,1,1-.76h28.89a1.12,1.12,0,0,1,1,.76A1,1,0,0,1,326.73,367.76Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 311.185px 370.99px"
                            id="ele8itqglfg4k"
                            class="animable"
                        ></path>
                        <g id="el4kxkh5xubz7">
                            <path
                                d="M324.94,374v-5.89a.38.38,0,0,0-.75,0V374H322.5v-5.89a.37.37,0,0,0-.37-.37.38.38,0,0,0-.37.37V374h-1.69v-5.89a.38.38,0,0,0-.37-.37.37.37,0,0,0-.37.37V374h-1.69v-5.89a.38.38,0,0,0-.75,0V374h-1.68v-5.89a.38.38,0,0,0-.75,0V374h-1.69v-5.89a.38.38,0,0,0-.37-.37.37.37,0,0,0-.37.37V374h-1.69v-5.89a.38.38,0,0,0-.75,0V374h-1.68v-5.89a.38.38,0,0,0-.75,0V374h-1.69v-5.89a.37.37,0,0,0-.74,0V374H303v-5.88a.38.38,0,0,0-.75,0v5.55a1.06,1.06,0,0,1-.29-.77l-.1-4.07a1.1,1.1,0,0,0-1.1-1.13h-4.06a1.14,1.14,0,0,0-1.13,1.11l.06,5.38a1.08,1.08,0,0,0,1.08,1.11h28.87a1.16,1.16,0,0,0,1.13-1.13V374Z"
                                style="opacity: 0.2; transform-origin: 311.14px 371.5px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="elzimvxcekf7">
                            <path
                                d="M326.67,367.41h-31a1.08,1.08,0,0,1,1-.76h28.89A1.12,1.12,0,0,1,326.67,367.41Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 311.17px 367.029px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M325.15,359.08v6.47a1.1,1.1,0,0,1-1.1,1.1H295.17a1.11,1.11,0,0,1-1.11-1.1v-6.47a1,1,0,0,1,.06-.35,1.1,1.1,0,0,1,1.05-.76h28.88a1.1,1.1,0,0,1,1,.76A.83.83,0,0,1,325.15,359.08Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 309.605px 362.31px"
                            id="el7un84ukdrbg"
                            class="animable"
                        ></path>
                        <g id="el8fuwr2hd8zp">
                            <path
                                d="M323.36,365.36v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89H318.5v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89H311.2v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.89H303.9v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.88a.37.37,0,0,0-.37-.37.38.38,0,0,0-.37.37V365a1.06,1.06,0,0,1-.3-.77l-.1-4.07a1.09,1.09,0,0,0-1.09-1.13h-4.07a1.14,1.14,0,0,0-1.13,1.11l.07,5.38a1.07,1.07,0,0,0,1.07,1.11H324a1.15,1.15,0,0,0,1.13-1.13v-.16Z"
                                style="opacity: 0.2; transform-origin: 309.58px 362.83px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="el5o7txs391qr">
                            <path
                                d="M325.09,358.73h-31a1.1,1.1,0,0,1,1.05-.76h28.88A1.1,1.1,0,0,1,325.09,358.73Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 309.59px 358.35px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M325.07,350.4v6.47A1.11,1.11,0,0,1,324,358H295.08a1.1,1.1,0,0,1-1.1-1.1V350.4a.93.93,0,0,1,.06-.34,1.08,1.08,0,0,1,1-.76H324a1.11,1.11,0,0,1,1,.76A.76.76,0,0,1,325.07,350.4Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 309.525px 353.65px"
                            id="elowzjhbeuee"
                            class="animable"
                        ></path>
                        <g id="elhl6p4hbwek8">
                            <path
                                d="M323.28,356.68v-5.89a.38.38,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.37-.37.38.38,0,0,0-.37.37v5.89H316v-5.89a.38.38,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.37-.37.38.38,0,0,0-.37.37v5.89h-1.69v-5.89a.38.38,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.37-.37.38.38,0,0,0-.37.37v5.89h-1.69v-5.88a.38.38,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.56a1.1,1.1,0,0,1-.3-.78l-.1-4.06a1.09,1.09,0,0,0-1.1-1.14h-4.06a1.14,1.14,0,0,0-1.13,1.11l.07,5.38a1.07,1.07,0,0,0,1.07,1.11H324a1.15,1.15,0,0,0,1.13-1.12v-.17Z"
                                style="opacity: 0.2; transform-origin: 309.55px 354.18px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="elknpekihwljd">
                            <path
                                d="M325,350.06H294a1.08,1.08,0,0,1,1-.76H324A1.11,1.11,0,0,1,325,350.06Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 309.5px 349.68px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M326.48,341.72v6.47a1.12,1.12,0,0,1-1.1,1.11H296.49a1.11,1.11,0,0,1-1.1-1.11v-6.47a.93.93,0,0,1,.06-.34,1.07,1.07,0,0,1,1-.76h28.89a1.11,1.11,0,0,1,1,.76A.76.76,0,0,1,326.48,341.72Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 310.935px 344.96px"
                            id="elsqdw7w31vqf"
                            class="animable"
                        ></path>
                        <g id="el7g36r7bqlck">
                            <path
                                d="M324.69,348v-5.88a.38.38,0,1,0-.75,0V348h-1.68v-5.88a.38.38,0,1,0-.75,0V348h-1.69v-5.88a.37.37,0,1,0-.74,0V348h-1.69v-5.88a.38.38,0,1,0-.75,0V348H315v-5.88a.38.38,0,1,0-.75,0V348h-1.69v-5.88a.37.37,0,1,0-.74,0V348h-1.69v-5.88a.38.38,0,0,0-.37-.38.37.37,0,0,0-.37.38V348h-1.69v-5.88a.38.38,0,1,0-.75,0V348h-1.69v-5.88a.37.37,0,0,0-.37-.38.38.38,0,0,0-.37.38V348h-1.69v-5.88a.38.38,0,0,0-.37-.38.37.37,0,0,0-.37.38v5.55a1.09,1.09,0,0,1-.3-.78l-.1-4.06a1.09,1.09,0,0,0-1.1-1.14h-4.06a1.14,1.14,0,0,0-1.13,1.11l.06,5.38a1.08,1.08,0,0,0,1.08,1.11h28.87a1.15,1.15,0,0,0,1.13-1.12V348Z"
                                style="opacity: 0.2; transform-origin: 310.97px 345.484px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="el8sd3ld32ot">
                            <path
                                d="M326.42,341.38h-31a1.07,1.07,0,0,1,1-.76h28.89A1.11,1.11,0,0,1,326.42,341.38Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 310.92px 340.999px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M324.91,333v6.47a1.12,1.12,0,0,1-1.11,1.11H294.92a1.11,1.11,0,0,1-1.1-1.11V333a.76.76,0,0,1,.06-.34,1.07,1.07,0,0,1,1-.76H323.8a1.11,1.11,0,0,1,1.05.76A.93.93,0,0,1,324.91,333Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 309.364px 336.24px"
                            id="elza0asmbc38h"
                            class="animable"
                        ></path>
                        <g id="ell7czov2unyi">
                            <path
                                d="M323.12,339.32v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,1,0-.74,0v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0v5.88h-1.68v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,1,0-.74,0v5.88H311v-5.88a.38.38,0,1,0-.75,0v5.88h-1.68v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,1,0-.74,0v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0v5.88h-1.68v-5.88a.38.38,0,1,0-.75,0V339a1.11,1.11,0,0,1-.3-.78l-.09-4.06A1.1,1.1,0,0,0,299,333h-4.06a1.13,1.13,0,0,0-1.13,1.11l.06,5.38a1.08,1.08,0,0,0,1.08,1.11h28.86a1.15,1.15,0,0,0,1.13-1.13v-.17Z"
                                style="opacity: 0.2; transform-origin: 309.375px 336.799px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="elvqnydkrjjqm">
                            <path
                                d="M324.85,332.7h-31a1.07,1.07,0,0,1,1-.76H323.8A1.11,1.11,0,0,1,324.85,332.7Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 309.35px 332.32px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M326.32,324.36v6.48a1.11,1.11,0,0,1-1.11,1.1H296.33a1.1,1.1,0,0,1-1.1-1.1v-6.48a.79.79,0,0,1,.06-.34,1.07,1.07,0,0,1,1-.76h28.88a1.11,1.11,0,0,1,1.05.76A1,1,0,0,1,326.32,324.36Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 310.775px 327.6px"
                            id="el34cpazs4a3b"
                            class="animable"
                        ></path>
                        <g id="eleoi3up44o39">
                            <path
                                d="M324.52,330.65v-5.89a.36.36,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.89h-1.69v-5.89a.37.37,0,0,0-.37-.37.36.36,0,0,0-.37.37v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.88a.38.38,0,0,0-.75,0v5.55a1.11,1.11,0,0,1-.3-.77l-.09-4.07a1.1,1.1,0,0,0-1.1-1.13h-4.07a1.14,1.14,0,0,0-1.13,1.11l.07,5.38a1.07,1.07,0,0,0,1.07,1.11H325.2a1.15,1.15,0,0,0,1.13-1.13v-.16Z"
                                style="opacity: 0.2; transform-origin: 310.76px 328.15px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="elsze2w48wxad">
                            <path
                                d="M326.26,324h-31a1.07,1.07,0,0,1,1-.76h28.88A1.11,1.11,0,0,1,326.26,324Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 310.76px 323.619px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M324.74,315.69v6.47a1.11,1.11,0,0,1-1.1,1.1H294.75a1.1,1.1,0,0,1-1.1-1.1v-6.47a1,1,0,0,1,.06-.35,1.08,1.08,0,0,1,1-.76h28.89a1.12,1.12,0,0,1,1,.76A.83.83,0,0,1,324.74,315.69Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 309.195px 318.92px"
                            id="elpfbzkzdti1b"
                            class="animable"
                        ></path>
                        <g id="els6k6r2hfdym">
                            <path
                                d="M323,322v-5.89a.38.38,0,0,0-.75,0V322h-1.68v-5.89a.38.38,0,0,0-.75,0V322h-1.69v-5.89a.37.37,0,0,0-.74,0V322h-1.69v-5.89a.38.38,0,0,0-.75,0V322h-1.68v-5.89a.38.38,0,0,0-.75,0V322h-1.69v-5.89a.37.37,0,1,0-.74,0V322h-1.69v-5.89a.38.38,0,0,0-.37-.37.37.37,0,0,0-.37.37V322h-1.69v-5.89a.38.38,0,0,0-.75,0V322h-1.69v-5.89a.37.37,0,0,0-.37-.37.38.38,0,0,0-.37.37V322h-1.69v-5.88a.38.38,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.55a1.06,1.06,0,0,1-.3-.77l-.1-4.07a1.09,1.09,0,0,0-1.1-1.13h-4.06a1.14,1.14,0,0,0-1.13,1.11l.06,5.38a1.08,1.08,0,0,0,1.08,1.11h28.87a1.16,1.16,0,0,0,1.13-1.13V322Z"
                                style="opacity: 0.2; transform-origin: 309.24px 319.5px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="ell113cs0wiu">
                            <path
                                d="M324.68,315.34h-31a1.08,1.08,0,0,1,1-.76h28.89A1.12,1.12,0,0,1,324.68,315.34Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 309.18px 314.959px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M327.26,298l2,6.15a1.11,1.11,0,0,1-.7,1.39l-27.45,9a1.1,1.1,0,0,1-1.39-.7l-2-6.15a.83.83,0,0,1-.06-.35,1.08,1.08,0,0,1,.76-1l27.45-9a1.11,1.11,0,0,1,1.23.4A.91.91,0,0,1,327.26,298Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 313.486px 305.942px"
                            id="el0kompdlnb1kp"
                            class="animable"
                        ></path>
                        <g id="els231jbabg0m">
                            <path
                                d="M327.51,304.51l-1.83-5.59a.37.37,0,0,0-.71.23l1.84,5.6-1.61.52-1.83-5.59a.38.38,0,0,0-.47-.24.37.37,0,0,0-.24.47l1.83,5.59-1.6.53-1.83-5.59a.37.37,0,0,0-.47-.24.36.36,0,0,0-.24.47l1.83,5.59-1.6.53-1.84-5.6a.37.37,0,0,0-.7.24l1.83,5.59-1.61.53-1.83-5.6a.38.38,0,0,0-.47-.24.39.39,0,0,0-.24.47l1.84,5.6-1.61.52-1.83-5.59a.37.37,0,0,0-.71.23l1.83,5.6-1.6.52-1.83-5.59a.37.37,0,0,0-.47-.24.36.36,0,0,0-.24.47l1.83,5.59-1.6.53-1.84-5.6a.37.37,0,0,0-.7.24l1.83,5.59-1.6.53-1.84-5.6a.38.38,0,0,0-.47-.24.39.39,0,0,0-.24.47l1.84,5.6-1.57.51h0l-1.83-5.59a.37.37,0,0,0-.47-.24.38.38,0,0,0-.24.47l1.73,5.28a1.07,1.07,0,0,1-.52-.65L304,306.77a1.09,1.09,0,0,0-1.4-.73l-3.86,1.26a1.15,1.15,0,0,0-.73,1.41l1.74,5.09a1.08,1.08,0,0,0,1.37.72l27.43-9a1.14,1.14,0,0,0,.72-1.42l0-.16Z"
                                style="opacity: 0.2; transform-origin: 313.643px 306.617px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="elorbkyktrpw">
                            <path
                                d="M327.1,297.68l-29.44,9.64a1.08,1.08,0,0,1,.76-1l27.45-9A1.11,1.11,0,0,1,327.1,297.68Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 312.38px 302.29px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M292,411.15v6.47a1.11,1.11,0,0,1-1.1,1.1H262a1.1,1.1,0,0,1-1.1-1.1v-6.47a1,1,0,0,1,.06-.35,1.08,1.08,0,0,1,1-.76h28.89a1.12,1.12,0,0,1,1,.76A.83.83,0,0,1,292,411.15Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 276.45px 414.38px"
                            id="elblg5tr7yvys"
                            class="animable"
                        ></path>
                        <g id="el93o9hwwvktb">
                            <path
                                d="M290.17,417.43v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89H285.3v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89H278v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89H270.7v-5.89a.37.37,0,0,0-.37-.37.38.38,0,0,0-.37.37v5.89h-1.69v-5.88a.38.38,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.55a1.06,1.06,0,0,1-.3-.77l-.1-4.07a1.09,1.09,0,0,0-1.1-1.13H262a1.14,1.14,0,0,0-1.13,1.11l.06,5.38a1.08,1.08,0,0,0,1.08,1.11h28.87a1.16,1.16,0,0,0,1.13-1.13v-.16Z"
                                style="opacity: 0.2; transform-origin: 276.44px 414.93px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="el4lryk5lgdat">
                            <path
                                d="M291.9,410.8h-31a1.08,1.08,0,0,1,1-.76h28.89A1.12,1.12,0,0,1,291.9,410.8Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 276.4px 410.419px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M288.89,402.47v6.47a1.1,1.1,0,0,1-1.1,1.1H258.91a1.11,1.11,0,0,1-1.11-1.1v-6.47a.93.93,0,0,1,.06-.34,1.09,1.09,0,0,1,1.05-.76h28.88a1.09,1.09,0,0,1,1,.76A.76.76,0,0,1,288.89,402.47Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 273.345px 405.705px"
                            id="ele54zfbplry5"
                            class="animable"
                        ></path>
                        <g id="elqdv0ft2ox2">
                            <path
                                d="M287.1,408.75v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89H279.8v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89H272.5v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89H265.2v-5.88a.37.37,0,0,0-.37-.37.38.38,0,0,0-.37.37v5.56a1.1,1.1,0,0,1-.3-.78l-.09-4.06a1.11,1.11,0,0,0-1.1-1.14H258.9a1.14,1.14,0,0,0-1.13,1.11l.07,5.38a1.07,1.07,0,0,0,1.07,1.11h28.87a1.15,1.15,0,0,0,1.13-1.12v-.17Z"
                                style="opacity: 0.2; transform-origin: 273.34px 406.25px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="ele4ao4ydp3nv">
                            <path
                                d="M288.83,402.13h-31a1.09,1.09,0,0,1,1.05-.76h28.88A1.09,1.09,0,0,1,288.83,402.13Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 273.33px 401.75px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M293.29,393.79v6.47a1.12,1.12,0,0,1-1.11,1.11H263.3a1.11,1.11,0,0,1-1.1-1.11v-6.47a.76.76,0,0,1,.06-.34,1.07,1.07,0,0,1,1-.76h28.88a1.11,1.11,0,0,1,1.05.76A.93.93,0,0,1,293.29,393.79Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 277.744px 397.03px"
                            id="elwkvuvsqxkus"
                            class="animable"
                        ></path>
                        <g id="elub3dy60pmdq">
                            <path
                                d="M291.5,400.07v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,1,0-.74,0v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0v5.88H284.2v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,0,0-.37-.38.38.38,0,0,0-.37.38v5.88h-1.69v-5.88a.38.38,0,0,0-.37-.38.37.37,0,0,0-.37.38v5.88H276.9v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,0,0-.37-.38.38.38,0,0,0-.37.38v5.88H272v-5.88a.38.38,0,0,0-.37-.38.37.37,0,0,0-.37.38v5.88H269.6v-5.88a.38.38,0,1,0-.75,0v5.55a1.08,1.08,0,0,1-.29-.78l-.1-4.06a1.11,1.11,0,0,0-1.1-1.14H263.3a1.14,1.14,0,0,0-1.13,1.11l.06,5.38a1.08,1.08,0,0,0,1.08,1.11h28.87a1.15,1.15,0,0,0,1.13-1.12v-.17Z"
                                style="opacity: 0.2; transform-origin: 277.74px 397.554px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="elnyc70xd1tc8">
                            <path
                                d="M293.23,393.45h-31a1.07,1.07,0,0,1,1-.76h28.88A1.11,1.11,0,0,1,293.23,393.45Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 277.73px 393.069px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M291.71,385.11v6.47a1.11,1.11,0,0,1-1.1,1.11H261.73a1.11,1.11,0,0,1-1.11-1.11v-6.47a.93.93,0,0,1,.06-.34,1.08,1.08,0,0,1,1.05-.76h28.88a1.1,1.1,0,0,1,1,.76A.76.76,0,0,1,291.71,385.11Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 276.165px 388.35px"
                            id="elaqra69787qi"
                            class="animable"
                        ></path>
                        <g id="elkk3s4fmwtd">
                            <path
                                d="M289.92,391.39v-5.88a.37.37,0,1,0-.74,0v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0v5.88h-1.68v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,1,0-.74,0v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0v5.88h-1.68v-5.88a.38.38,0,1,0-.75,0v5.88h-1.69v-5.88a.37.37,0,1,0-.74,0v5.88h-1.69v-5.88a.38.38,0,1,0-.75,0v5.88h-1.68v-5.88a.38.38,0,1,0-.75,0v5.88H268v-5.88a.37.37,0,1,0-.74,0v5.55a1.07,1.07,0,0,1-.3-.78l-.1-4.06a1.09,1.09,0,0,0-1.1-1.13h-4.06a1.14,1.14,0,0,0-1.13,1.11l.07,5.38a1.07,1.07,0,0,0,1.07,1.11H290.6a1.15,1.15,0,0,0,1.13-1.13v-.17Z"
                                style="opacity: 0.2; transform-origin: 276.15px 388.879px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="eljry9y1aepzi">
                            <path
                                d="M291.65,384.77h-31a1.08,1.08,0,0,1,1.05-.76h28.88A1.1,1.1,0,0,1,291.65,384.77Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 276.15px 384.39px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M290.14,376.43v6.48A1.11,1.11,0,0,1,289,384H260.15a1.1,1.1,0,0,1-1.1-1.1v-6.48a.79.79,0,0,1,.06-.34,1.07,1.07,0,0,1,1-.76H289a1.11,1.11,0,0,1,1.05.76A1,1,0,0,1,290.14,376.43Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 274.595px 379.66px"
                            id="elbp6vq74719k"
                            class="animable"
                        ></path>
                        <g id="el2fysy102cr9">
                            <path
                                d="M288.35,382.72v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.36.36,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.89h-1.69v-5.89a.37.37,0,0,0-.37-.37.36.36,0,0,0-.37.37v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.36.36,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.89h-1.69v-5.89a.37.37,0,0,0-.37-.37.36.36,0,0,0-.37.37v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.36.36,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.89h-1.69v-5.89a.37.37,0,0,0-.37-.37.36.36,0,0,0-.37.37v5.89h-1.69v-5.88a.38.38,0,0,0-.75,0v5.55a1.06,1.06,0,0,1-.29-.77l-.1-4.07a1.1,1.1,0,0,0-1.1-1.13h-4.06a1.13,1.13,0,0,0-1.13,1.11l.06,5.38a1.08,1.08,0,0,0,1.08,1.11H289a1.16,1.16,0,0,0,1.13-1.13v-.16Z"
                                style="opacity: 0.2; transform-origin: 274.575px 380.22px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="elh7es955952">
                            <path
                                d="M290.08,376.09h-31a1.07,1.07,0,0,1,1-.76H289A1.11,1.11,0,0,1,290.08,376.09Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 274.58px 375.71px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M290.06,367.76v6.47a1.11,1.11,0,0,1-1.11,1.1H260.07a1.1,1.1,0,0,1-1.1-1.1v-6.47a.83.83,0,0,1,.06-.35,1.08,1.08,0,0,1,1-.76H289a1.12,1.12,0,0,1,1.05.76A1,1,0,0,1,290.06,367.76Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 274.52px 370.99px"
                            id="el9y9yqm5hip"
                            class="animable"
                        ></path>
                        <g id="elflaxjcxdjsk">
                            <path
                                d="M288.26,374v-5.89a.37.37,0,0,0-.37-.37.38.38,0,0,0-.37.37V374h-1.69v-5.89a.38.38,0,0,0-.37-.37.37.37,0,0,0-.37.37V374H283.4v-5.89a.38.38,0,0,0-.75,0V374H281v-5.89a.38.38,0,0,0-.75,0V374h-1.69v-5.89a.37.37,0,1,0-.74,0V374H276.1v-5.89a.38.38,0,0,0-.75,0V374h-1.68v-5.89a.38.38,0,0,0-.75,0V374h-1.69v-5.89a.37.37,0,0,0-.74,0V374H268.8v-5.89a.38.38,0,0,0-.75,0V374h-1.68v-5.88a.38.38,0,0,0-.75,0v5.55a1.11,1.11,0,0,1-.3-.77l-.09-4.07a1.1,1.1,0,0,0-1.1-1.13h-4.07a1.15,1.15,0,0,0-1.13,1.11l.07,5.38a1.07,1.07,0,0,0,1.07,1.11h28.87a1.15,1.15,0,0,0,1.13-1.13V374Z"
                                style="opacity: 0.2; transform-origin: 274.5px 371.5px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="el7se833le5hl">
                            <path
                                d="M290,367.41H259a1.08,1.08,0,0,1,1-.76H289A1.12,1.12,0,0,1,290,367.41Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 274.5px 367.03px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M291.46,359.08v6.47a1.1,1.1,0,0,1-1.1,1.1H261.48a1.1,1.1,0,0,1-1.1-1.1v-6.47a1,1,0,0,1,.05-.35,1.1,1.1,0,0,1,1.05-.76h28.88a1.1,1.1,0,0,1,1,.76A.83.83,0,0,1,291.46,359.08Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 275.92px 362.31px"
                            id="elqabgmyx4y5q"
                            class="animable"
                        ></path>
                        <g id="elu6lgdnq33mn">
                            <path
                                d="M289.67,365.36v-5.89a.37.37,0,0,0-.37-.37.38.38,0,0,0-.37.37v5.89h-1.69v-5.89a.38.38,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.37-.37.38.38,0,0,0-.37.37v5.89h-1.69v-5.89a.38.38,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.37-.37.38.38,0,0,0-.37.37v5.89h-1.69v-5.89a.38.38,0,0,0-.37-.37.37.37,0,0,0-.37.37v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.88a.37.37,0,0,0-.37-.37.38.38,0,0,0-.37.37V365a1.11,1.11,0,0,1-.3-.77l-.09-4.07a1.1,1.1,0,0,0-1.1-1.13h-4.07a1.14,1.14,0,0,0-1.13,1.11l.07,5.38a1.07,1.07,0,0,0,1.07,1.11h28.87a1.15,1.15,0,0,0,1.13-1.13v-.16Z"
                                style="opacity: 0.2; transform-origin: 275.91px 362.83px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="elkbaejjo24r9">
                            <path
                                d="M291.4,358.73h-31a1.1,1.1,0,0,1,1.05-.76h28.88A1.1,1.1,0,0,1,291.4,358.73Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 275.9px 358.35px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M236.6,411.15v6.47a1.11,1.11,0,0,1-1.11,1.1H206.61a1.1,1.1,0,0,1-1.1-1.1v-6.47a.83.83,0,0,1,.06-.35,1.08,1.08,0,0,1,1-.76h28.88a1.12,1.12,0,0,1,1,.76A1,1,0,0,1,236.6,411.15Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 221.055px 414.38px"
                            id="elgpigaa07uva"
                            class="animable"
                        ></path>
                        <g id="elr1327s60k1h">
                            <path
                                d="M234.81,417.43v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,1,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,1,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.89a.38.38,0,0,0-.75,0v5.89h-1.69v-5.89a.37.37,0,0,0-.74,0v5.89h-1.69v-5.89a.38.38,0,0,0-.75,0v5.89h-1.68v-5.88a.38.38,0,0,0-.75,0v5.55a1.11,1.11,0,0,1-.3-.77l-.09-4.07a1.1,1.1,0,0,0-1.1-1.13h-4.06a1.14,1.14,0,0,0-1.13,1.11l.06,5.38a1.08,1.08,0,0,0,1.08,1.11h28.86a1.16,1.16,0,0,0,1.14-1.13v-.16Z"
                                style="opacity: 0.2; transform-origin: 221.05px 414.93px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="ela2iuwegw0yl">
                            <path
                                d="M236.54,410.8h-31a1.08,1.08,0,0,1,1-.76h28.88A1.12,1.12,0,0,1,236.54,410.8Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 221.04px 410.419px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="elsalhz2558x">
                            <circle
                                cx="246.8"
                                cy="403.2"
                                r="15.52"
                                style="
                                    fill: rgb(64, 123, 255);
                                    transform-origin: 246.8px 403.2px;
                                    transform: rotate(-73.9deg);
                                "
                                class="animable"
                            ></circle>
                        </g>
                        <g id="elnd15e3y2pvm">
                            <circle
                                cx="246.8"
                                cy="403.2"
                                r="13.24"
                                style="
                                    fill: rgb(255, 255, 255);
                                    opacity: 0.3;
                                    transform-origin: 246.8px 403.2px;
                                    transform: rotate(-55.58deg);
                                "
                                class="animable"
                            ></circle>
                        </g>
                        <path
                            d="M245.23,410.23l-.77,2.1-1.54-.56.77-2.08a8.67,8.67,0,0,1-4-3.25l1.54-1.58a7.56,7.56,0,0,0,3.22,2.8l1.38-3.74c-1.9-1.27-3.88-2.77-2.92-5.37.7-1.91,2.7-3.07,5.73-2.27l.78-2.12,1.53.57-.76,2.08a8.54,8.54,0,0,1,3.38,2.54l-1.47,1.6a8.25,8.25,0,0,0-2.66-2.12L248,402.61c1.89,1.27,3.92,2.76,3,5.36C250.29,409.88,248.28,411,245.23,410.23Zm1.41-8.58,1.23-3.33c-1.41-.28-2.22.18-2.52,1S245.67,400.93,246.64,401.65Zm1.89,5.61c.34-.92-.33-1.65-1.33-2.38L246,408.19C247.42,408.49,248.24,408.07,248.53,407.26Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 246.63px 403.245px"
                            id="elw18vn5u47yd"
                            class="animable"
                        ></path>
                        <g id="elely7f82b31l">
                            <circle
                                cx="285.15"
                                cy="342.8"
                                r="15.52"
                                style="
                                    fill: rgb(64, 123, 255);
                                    transform-origin: 285.15px 342.8px;
                                    transform: rotate(-68.37deg);
                                "
                                class="animable"
                            ></circle>
                        </g>
                        <g id="elsgr9kt8nbt">
                            <circle
                                cx="285.15"
                                cy="342.8"
                                r="13.24"
                                style="
                                    fill: rgb(255, 255, 255);
                                    opacity: 0.3;
                                    transform-origin: 285.15px 342.8px;
                                    transform: rotate(-28.28deg);
                                "
                                class="animable"
                            ></circle>
                        </g>
                        <path
                            d="M291.93,345.25l2,1-.75,1.45-2-1a8.81,8.81,0,0,1-3.72,3.58l-1.38-1.72a7.68,7.68,0,0,0,3.19-2.85l-3.54-1.84c-1.5,1.72-3.23,3.5-5.7,2.22-1.8-.93-2.7-3.06-1.53-6l-2-1,.75-1.46,2,1a8.56,8.56,0,0,1,2.94-3l1.42,1.65a8.21,8.21,0,0,0-2.45,2.38l3.58,1.85c1.5-1.71,3.23-3.54,5.69-2.26C292.22,340.19,293.09,342.32,291.93,345.25Zm-8.34-2.48-3.15-1.63c-.46,1.36-.1,2.22.68,2.62S282.76,343.64,283.59,342.77Zm5.8-1.17c-.87-.45-1.68.12-2.53,1l3.14,1.63C290.47,342.86,290.15,342,289.39,341.6Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 285.215px 342.955px"
                            id="elb5cc149s83l"
                            class="animable"
                        ></path>
                        <g id="el7by5rculkha">
                            <circle
                                cx="366.88"
                                cy="403.2"
                                r="15.52"
                                style="
                                    fill: rgb(64, 123, 255);
                                    transform-origin: 366.88px 403.2px;
                                    transform: rotate(-32.7352deg);
                                "
                                class="animable"
                            ></circle>
                        </g>
                        <g id="el8jkdu17dlzq">
                            <path
                                d="M377.59,411a13.25,13.25,0,1,1-2.9-18.51A13.25,13.25,0,0,1,377.59,411Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.3; transform-origin: 366.882px 403.195px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M363.44,409.53l-1.32,1.81-1.32-1,1.31-1.79a8.79,8.79,0,0,1-3-4.22l1.92-1.1a7.64,7.64,0,0,0,2.33,3.58l2.35-3.23c-1.47-1.74-3-3.72-1.33-6,1.19-1.64,3.43-2.21,6.13-.62l1.32-1.82,1.33,1L371.87,398a8.6,8.6,0,0,1,2.56,3.38l-1.85,1.14a8.19,8.19,0,0,0-2-2.77L368.23,403c1.47,1.74,3,3.73,1.37,6C368.4,410.59,366.16,411.12,363.44,409.53Zm3.71-7.86,2.09-2.87c-1.27-.66-2.18-.43-2.69.28S366.42,400.71,367.15,401.67Zm.28,5.91c.58-.79.14-1.68-.63-2.66l-2.08,2.86C366,408.46,366.93,408.27,367.43,407.58Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 366.77px 403.24px"
                            id="eljkntiyxydys"
                            class="animable"
                        ></path>
                    </g>
                    <g
                        id="freepik--character-5--inject-49"
                        class="animable"
                        style="transform-origin: 369.415px 175.481px"
                    >
                        <path
                            d="M386,180.17a17.2,17.2,0,0,1-9.39,11,18.51,18.51,0,0,1-1.74.69c-.3.1-.61.19-.91.27a17.09,17.09,0,0,1-9.22,0l-.08,0c-.6-.17-1.17-.37-1.73-.59q-.45-.18-.87-.39l-.08,0a12.62,12.62,0,0,1-1.36-.73,2.07,2.07,0,0,1-.32-.19c-.41-.25-.8-.52-1.18-.8-.22-.16-.44-.33-.65-.51-.4-.33-.79-.68-1.15-1a12.48,12.48,0,0,1-.86-.92,17.2,17.2,0,0,1-1.66-2.23c-.13-.21-.26-.43-.38-.65a3.24,3.24,0,0,1-.2-.36A17.23,17.23,0,1,1,386,180.17Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 369.39px 175.562px"
                            id="elgh0zsplhid"
                            class="animable"
                        ></path>
                        <path
                            d="M354.78,184.6c-.13-.21-.26-.43-.38-.65a3.24,3.24,0,0,1-.2-.36,3.47,3.47,0,0,1,.69-.33l.06,0Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 354.575px 183.93px"
                            id="elpeq6c9wrm1m"
                            class="animable"
                        ></path>
                        <g id="el3euabwo74j7">
                            <path
                                d="M354.78,184.6c-.13-.21-.26-.43-.38-.65a3.24,3.24,0,0,1-.2-.36,3.47,3.47,0,0,1,.69-.33l.06,0Z"
                                style="
                                    fill: rgb(255, 255, 255);
                                    isolation: isolate;
                                    opacity: 0.5;
                                    transform-origin: 354.575px 183.93px;
                                "
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M376.18,189.46h0c-.47.82-.92,1.61-1.32,2.36-.3.1-.61.19-.91.27a17.09,17.09,0,0,1-9.22,0l-.08,0c-.6-.17-1.17-.37-1.73-.59q-.45-.18-.87-.39l-.08,0a12.62,12.62,0,0,1-1.36-.73,2.07,2.07,0,0,1-.32-.19c-.41-.25-.8-.52-1.18-.8-.22-.16-.44-.33-.65-.51-.4-.33-.79-.68-1.15-1a12.48,12.48,0,0,1-.86-.92,17.2,17.2,0,0,1-1.66-2.23c-.13-.21-.26-.43-.38-.65a1.65,1.65,0,0,1,.49-.69l.06,0s3.69.33,6.92,1l.2,0c.36.08.72.16,1.08.26a50.16,50.16,0,0,1,5.08,1.51c.42.14.85.29,1.27.45l.41.16A49.87,49.87,0,0,1,376.18,189.46Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 365.295px 188.057px"
                            id="el9d69ud5xvvc"
                            class="animable"
                        ></path>
                        <g id="elseaun42cm1">
                            <path
                                d="M376.18,189.46h0c-.47.82-.92,1.61-1.32,2.36-.3.1-.61.19-.91.27a17.09,17.09,0,0,1-9.22,0l-.08,0c-.6-.17-1.17-.37-1.73-.59q-.45-.18-.87-.39l-.08,0a12.62,12.62,0,0,1-1.36-.73,2.07,2.07,0,0,1-.32-.19c-.41-.25-.8-.52-1.18-.8-.22-.16-.44-.33-.65-.51-.4-.33-.79-.68-1.15-1a12.48,12.48,0,0,1-.86-.92,17.2,17.2,0,0,1-1.66-2.23c-.13-.21-.26-.43-.38-.65a1.65,1.65,0,0,1,.49-.69l.06,0s3.69.33,6.92,1l.2,0c.36.08.72.16,1.08.26a50.16,50.16,0,0,1,5.08,1.51c.42.14.85.29,1.27.45l.41.16A49.87,49.87,0,0,1,376.18,189.46Z"
                                style="
                                    fill: rgb(255, 255, 255);
                                    isolation: isolate;
                                    opacity: 0.5;
                                    transform-origin: 365.295px 188.057px;
                                "
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M358.57,186.89l1.71,3.21c-.41-.25-.8-.52-1.18-.8-.22-.16-.44-.33-.65-.51l0-.44Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 359.365px 188.495px"
                            id="el460q08cct6g"
                            class="animable"
                        ></path>
                        <path
                            d="M366.86,189.38l-.93,1.11L364.64,192c-.6-.17-1.17-.37-1.73-.59q-.45-.18-.87-.39l-.08,0,2.52-.84Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 364.41px 190.69px"
                            id="eljp9v197l30h"
                            class="animable"
                        ></path>
                        <path
                            d="M370.49,191.14,368.4,190s-1,.15-2.47.52a27,27,0,0,0-3,1q-.45-.18-.87-.39l-.08,0a12.62,12.62,0,0,1-1.36-.73,2.07,2.07,0,0,1-.32-.19c-.41-.25-.8-.52-1.18-.8a9.74,9.74,0,0,0-.62-1,5.37,5.37,0,0,0-.5-.55l-.68-.05a12.48,12.48,0,0,1-.86-.92,10.93,10.93,0,0,1,5.43-2.65,9.91,9.91,0,0,1,1.58-.13,11,11,0,0,1,4.41,1h0a5.2,5.2,0,0,1,2,1.55A4.72,4.72,0,0,1,370.49,191.14Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 363.63px 187.815px"
                            id="elwudnt7t68w8"
                            class="animable"
                        ></path>
                        <g id="elzv58mtzzbtb">
                            <path
                                d="M370.49,191.14,368.4,190s-1,.15-2.47.52a27,27,0,0,0-3,1q-.45-.18-.87-.39l-.08,0a12.62,12.62,0,0,1-1.36-.73,2.07,2.07,0,0,1-.32-.19c-.41-.25-.8-.52-1.18-.8a9.74,9.74,0,0,0-.62-1,5.37,5.37,0,0,0-.5-.55l-.68-.05a12.48,12.48,0,0,1-.86-.92,10.93,10.93,0,0,1,5.43-2.65,9.91,9.91,0,0,1,1.58-.13,11,11,0,0,1,4.41,1h0a5.2,5.2,0,0,1,2,1.55A4.72,4.72,0,0,1,370.49,191.14Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.1; transform-origin: 363.63px 187.815px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M368.61,186.92c-.46,1.39-2.34,2.5-4.13,3.26-.9.38-1.79.68-2.44.88l-.08,0a12.62,12.62,0,0,1-1.36-.73c-.44-1.61-.85-4.53,1.53-5.31a3.71,3.71,0,0,1,.55-.13,1.45,1.45,0,0,0,.47-.37,3.49,3.49,0,0,0,.3-.43,5.85,5.85,0,0,0,.61-1.89c0-.24.08-.5.11-.79,0-.1,0-.21,0-.31s0-.28,0-.43a5.79,5.79,0,0,0,0-.61h5.18l0,.06a9.21,9.21,0,0,0-.67,1.07h0a6.77,6.77,0,0,0-.86,3.88,3.84,3.84,0,0,0,.18.8.86.86,0,0,1,.18.14A.85.85,0,0,1,368.61,186.92Z"
                            style="fill: rgb(238, 193, 187); transform-origin: 364.806px 185.56px"
                            id="elrzz1b7q3fim"
                            class="animable"
                        ></path>
                        <g id="elmx920j5mum">
                            <path
                                d="M364.26,180a14.89,14.89,0,0,1-.2,2.15,5.68,5.68,0,0,0,5.38-2.14Z"
                                style="isolation: isolate; opacity: 0.2; transform-origin: 366.75px 181.11px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M369.61,163.93s-5.73-1.85-7.7,2.67a7.41,7.41,0,0,0,1.18,7.84Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 365.445px 168.998px"
                            id="el5dduizpgnru"
                            class="animable"
                        ></path>
                        <path
                            d="M369.67,166.55c-4.31-1.06-6.26.9-7.67,5.26-1.76,5.45-1.49,9.69,4.18,9.83C373.89,181.83,376.82,168.31,369.67,166.55Z"
                            style="fill: rgb(238, 193, 187); transform-origin: 367.396px 173.955px"
                            id="elfhs8po7ntfr"
                            class="animable"
                        ></path>
                        <path
                            d="M364.84,172.26a9.27,9.27,0,0,1-1.69,1.48,1.23,1.23,0,0,0,1,.76Z"
                            style="fill: rgb(212, 130, 125); transform-origin: 363.995px 173.38px"
                            id="ely2jblxgyzu"
                            class="animable"
                        ></path>
                        <path
                            d="M367.57,172.55c-.1.36,0,.69.25.76s.5-.17.6-.53,0-.68-.26-.75S367.66,172.2,367.57,172.55Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 367.995px 172.67px"
                            id="ely7lykdrc9mp"
                            class="animable"
                        ></path>
                        <path
                            d="M368.26,172.08l-.69-.51S367.78,172.31,368.26,172.08Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 367.915px 171.847px"
                            id="eljmrzfaixwlo"
                            class="animable"
                        ></path>
                        <path
                            d="M363.21,171.3c-.09.35,0,.68.26.75s.5-.17.59-.52,0-.69-.25-.76S363.31,170.94,363.21,171.3Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 363.635px 171.41px"
                            id="elzu9dwyfu9c"
                            class="animable"
                        ></path>
                        <path
                            d="M363.9,170.82l-.68-.51S363.43,171.06,363.9,170.82Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 363.56px 170.589px"
                            id="elt5fv54u1wa"
                            class="animable"
                        ></path>
                        <path
                            d="M370.05,170.9a.19.19,0,0,1-.18-.11,2.12,2.12,0,0,0-1.55-1,.19.19,0,0,1-.17-.22.18.18,0,0,1,.21-.17,2.45,2.45,0,0,1,1.87,1.22.21.21,0,0,1-.1.26Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 369.195px 170.149px"
                            id="elmdcl4zv7ol"
                            class="animable"
                        ></path>
                        <path
                            d="M365.26,168.84a.15.15,0,0,1-.11,0h0a1.93,1.93,0,0,0-1.63,0,.2.2,0,0,1-.25-.12.19.19,0,0,1,.12-.25,2.23,2.23,0,0,1,2,.09.2.2,0,0,1-.11.36Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 364.364px 168.598px"
                            id="elgtqqnuumm3f"
                            class="animable"
                        ></path>
                        <path
                            d="M372.59,175s-1.15-4-.17-6.69c0,0-7.67-5.58-10.22,3,0,0,1.05-7.9,8.5-6.25s4.75,12.47.13,14.76C370.83,179.76,373.29,177.48,372.59,175Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 368.771px 172.327px"
                            id="el0r8y0kal1ufk"
                            class="animable"
                        ></path>
                        <path
                            d="M368.93,163.45s-3.41-1.55-4.6-.8,4.77,8.8,8.42,10.19c0,0,.49,4.42-.89,6.19,0,0,4.53-.69,6-7.12S372.88,161.75,368.93,163.45Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 371.125px 170.738px"
                            id="elx5dpinzs2d8"
                            class="animable"
                        ></path>
                        <path
                            d="M371.66,175.7a1.94,1.94,0,0,1,2.46-1.23c1.3.48,1.26,3.37-2.22,3.21C371.4,177.66,371.25,177.13,371.66,175.7Z"
                            style="fill: rgb(238, 193, 187); transform-origin: 373.165px 176.028px"
                            id="ele94x6bgeh2r"
                            class="animable"
                        ></path>
                        <path
                            d="M375.19,167.29s2.2-3.5,6.13-2.48,3.37,7.34.41,11.54-1.82,5.94-1.82,5.94-2.17-.69-1.4-4.8a15,15,0,0,0-.63,2.6s-1.09-2.37,1.08-6.08-2.7-2.75-2.7-2.75Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 379.65px 173.457px"
                            id="elkeq9ee3bki"
                            class="animable"
                        ></path>
                        <path
                            d="M370.06,172.46l-.1,0c-4.74-2.79-5.54-9.29-5.55-9.35a.19.19,0,0,1,.17-.22.19.19,0,0,1,.22.17c0,.07.79,6.37,5.36,9.06a.19.19,0,0,1,.07.27A.19.19,0,0,1,370.06,172.46Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 367.334px 167.674px"
                            id="ele67uww25tnl"
                            class="animable"
                        ></path>
                        <path
                            d="M365.29,177.51a3.3,3.3,0,0,1-.75-.08.2.2,0,1,1,.09-.39,3.42,3.42,0,0,0,2.53-.5.18.18,0,0,1,.27,0,.19.19,0,0,1,0,.27A3.81,3.81,0,0,1,365.29,177.51Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 365.936px 176.995px"
                            id="ele0sqlfr2wjn"
                            class="animable"
                        ></path>
                        <path
                            d="M366.16,174.13l-.2,0a1.05,1.05,0,0,1-.72-.5,1.25,1.25,0,0,1-.16-.89,1.13,1.13,0,1,1,2.21.41,1.26,1.26,0,0,1-.48.78A1.13,1.13,0,0,1,366.16,174.13Zm0-2.12a.9.9,0,0,0-.85.76,1,1,0,0,0,.13.69.78.78,0,0,0,.52.37.8.8,0,0,0,.63-.15.94.94,0,0,0,.36-.6.87.87,0,0,0-.65-1.06Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 366.197px 172.915px"
                            id="elia6l6t28l6m"
                            class="animable"
                        ></path>
                        <path
                            d="M362.78,173.32l-.2,0a1.21,1.21,0,1,1,1.33-1,1.26,1.26,0,0,1-.48.78A1.11,1.11,0,0,1,362.78,173.32Zm.06-2.12a.89.89,0,0,0-.85.76.87.87,0,0,0,.65,1.06.78.78,0,0,0,.62-.15,1,1,0,0,0,.37-.6.89.89,0,0,0-.65-1.06Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 362.717px 172.114px"
                            id="elugv8rmqj0u"
                            class="animable"
                        ></path>
                        <path
                            d="M365.22,172.89a.15.15,0,0,1-.14-.11.85.85,0,0,0-.43-.54.9.9,0,0,0-.8.18.15.15,0,0,1-.2,0,.16.16,0,0,1,0-.2,1,1,0,0,1,1.67.54.14.14,0,0,1-.1.17Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 364.47px 172.438px"
                            id="elvx26k3uo66t"
                            class="animable"
                        ></path>
                        <path
                            d="M373.21,174.25h0c-.62-.15-6-1-6.05-1a.15.15,0,0,1-.12-.17.16.16,0,0,1,.17-.12c.22,0,5.44.86,6.07,1a.14.14,0,0,1,0,.28Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 370.229px 173.605px"
                            id="elztizaiyvtm"
                            class="animable"
                        ></path>
                        <path
                            d="M376.59,191.14a18.51,18.51,0,0,1-1.74.69c-.3.1-.61.19-.91.27a26.57,26.57,0,0,1,2.23-2.63h0S376.34,190.07,376.59,191.14Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 375.265px 190.785px"
                            id="el5lycukbu6t6"
                            class="animable"
                        ></path>
                        <g id="elbes2jzc2jcm">
                            <path
                                d="M376.59,191.14a18.51,18.51,0,0,1-1.74.69c-.3.1-.61.19-.91.27a26.57,26.57,0,0,1,2.23-2.63h0S376.34,190.07,376.59,191.14Z"
                                style="
                                    fill: rgb(255, 255, 255);
                                    isolation: isolate;
                                    opacity: 0.5;
                                    transform-origin: 375.265px 190.785px;
                                "
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M370,195.74a.29.29,0,0,1-.29-.28.28.28,0,0,1,.28-.29l1.13-.07a.3.3,0,0,1,.31.26.28.28,0,0,1-.26.31c-.39,0-.78.06-1.16.07Zm4-.53a.28.28,0,0,1-.28-.22.29.29,0,0,1,.22-.34,19.76,19.76,0,0,0,9.69-5.54.29.29,0,0,1,.41,0,.28.28,0,0,1,0,.4,20.37,20.37,0,0,1-10,5.71Zm-12.38-1.05a.23.23,0,0,1-.11,0,20.18,20.18,0,0,1-8.87-7.3.29.29,0,0,1,.48-.32,19.51,19.51,0,0,0,8.62,7.09.29.29,0,0,1,.15.38A.28.28,0,0,1,361.6,194.16Zm-10.18-9.68a.28.28,0,0,1-.25-.16c-.17-.35-.33-.7-.48-1.06a.29.29,0,0,1,.15-.38.29.29,0,0,1,.38.16c.14.35.3.69.46,1a.28.28,0,0,1-.13.38A.28.28,0,0,1,351.42,184.48Zm36.85-2.18-.09,0a.28.28,0,0,1-.18-.36c.12-.36.24-.72.34-1.08a.28.28,0,0,1,.35-.2.27.27,0,0,1,.2.35c-.1.38-.22.75-.35,1.11A.29.29,0,0,1,388.27,182.3Zm1-4.78h0a.28.28,0,0,1-.26-.31c0-.37.06-.75.07-1.13a.3.3,0,0,1,.29-.28.29.29,0,0,1,.28.3c0,.39,0,.78-.07,1.16A.29.29,0,0,1,389.3,177.52ZM349.43,175h0a.28.28,0,0,1-.27-.3,20.19,20.19,0,0,1,.75-4.74,20.47,20.47,0,0,1,2.92-6.15.3.3,0,0,1,.4-.07.29.29,0,0,1,.07.4,19.89,19.89,0,0,0-2.84,6,20.14,20.14,0,0,0-.73,4.62A.28.28,0,0,1,349.43,175Zm39.81-1.52a.29.29,0,0,1-.28-.25A19.61,19.61,0,0,0,384.59,163a.29.29,0,0,1,.45-.36,20.31,20.31,0,0,1,4.49,10.57.28.28,0,0,1-.25.32Zm-34.37-11.44a.31.31,0,0,1-.2-.07.3.3,0,0,1,0-.41c.27-.28.54-.56.82-.82a.29.29,0,0,1,.41,0,.28.28,0,0,1,0,.4c-.28.26-.54.53-.8.8A.3.3,0,0,1,354.87,162.06Zm23.23-4.27a.31.31,0,0,1-.13,0l-1-.46a.28.28,0,0,1-.16-.37.29.29,0,0,1,.38-.16c.36.15.71.31,1.06.48a.28.28,0,0,1,.14.38A.3.3,0,0,1,378.1,157.79ZM363,156.85a.29.29,0,0,1-.27-.2.28.28,0,0,1,.18-.36,20.21,20.21,0,0,1,11.48-.44.29.29,0,0,1,.2.35.28.28,0,0,1-.35.21,19.69,19.69,0,0,0-11.15.42Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 369.415px 175.481px"
                            id="el8n7uz4pexuu"
                            class="animable"
                        ></path>
                        <g id="ell6y8tnasnm">
                            <g style="opacity: 0.5; transform-origin: 369.415px 175.481px" class="animable">
                                <path
                                    d="M370,195.74a.29.29,0,0,1-.29-.28.28.28,0,0,1,.28-.29l1.13-.07a.3.3,0,0,1,.31.26.28.28,0,0,1-.26.31c-.39,0-.78.06-1.16.07Zm4-.53a.28.28,0,0,1-.28-.22.29.29,0,0,1,.22-.34,19.76,19.76,0,0,0,9.69-5.54.29.29,0,0,1,.41,0,.28.28,0,0,1,0,.4,20.37,20.37,0,0,1-10,5.71Zm-12.38-1.05a.23.23,0,0,1-.11,0,20.18,20.18,0,0,1-8.87-7.3.29.29,0,0,1,.48-.32,19.51,19.51,0,0,0,8.62,7.09.29.29,0,0,1,.15.38A.28.28,0,0,1,361.6,194.16Zm-10.18-9.68a.28.28,0,0,1-.25-.16c-.17-.35-.33-.7-.48-1.06a.29.29,0,0,1,.15-.38.29.29,0,0,1,.38.16c.14.35.3.69.46,1a.28.28,0,0,1-.13.38A.28.28,0,0,1,351.42,184.48Zm36.85-2.18-.09,0a.28.28,0,0,1-.18-.36c.12-.36.24-.72.34-1.08a.28.28,0,0,1,.35-.2.27.27,0,0,1,.2.35c-.1.38-.22.75-.35,1.11A.29.29,0,0,1,388.27,182.3Zm1-4.78h0a.28.28,0,0,1-.26-.31c0-.37.06-.75.07-1.13a.3.3,0,0,1,.29-.28.29.29,0,0,1,.28.3c0,.39,0,.78-.07,1.16A.29.29,0,0,1,389.3,177.52ZM349.43,175h0a.28.28,0,0,1-.27-.3,20.19,20.19,0,0,1,.75-4.74,20.47,20.47,0,0,1,2.92-6.15.3.3,0,0,1,.4-.07.29.29,0,0,1,.07.4,19.89,19.89,0,0,0-2.84,6,20.14,20.14,0,0,0-.73,4.62A.28.28,0,0,1,349.43,175Zm39.81-1.52a.29.29,0,0,1-.28-.25A19.61,19.61,0,0,0,384.59,163a.29.29,0,0,1,.45-.36,20.31,20.31,0,0,1,4.49,10.57.28.28,0,0,1-.25.32Zm-34.37-11.44a.31.31,0,0,1-.2-.07.3.3,0,0,1,0-.41c.27-.28.54-.56.82-.82a.29.29,0,0,1,.41,0,.28.28,0,0,1,0,.4c-.28.26-.54.53-.8.8A.3.3,0,0,1,354.87,162.06Zm23.23-4.27a.31.31,0,0,1-.13,0l-1-.46a.28.28,0,0,1-.16-.37.29.29,0,0,1,.38-.16c.36.15.71.31,1.06.48a.28.28,0,0,1,.14.38A.3.3,0,0,1,378.1,157.79ZM363,156.85a.29.29,0,0,1-.27-.2.28.28,0,0,1,.18-.36,20.21,20.21,0,0,1,11.48-.44.29.29,0,0,1,.2.35.28.28,0,0,1-.35.21,19.69,19.69,0,0,0-11.15.42Z"
                                    style="fill: rgb(255, 255, 255); transform-origin: 369.415px 175.481px"
                                    id="elv1pi2uhmg2h"
                                    class="animable"
                                ></path>
                            </g>
                        </g>
                    </g>
                    <g
                        id="freepik--character-4--inject-49"
                        class="animable"
                        style="transform-origin: 311.991px 123.575px"
                    >
                        <path
                            d="M337.39,120.09A25.63,25.63,0,0,1,311,149.2a14.36,14.36,0,0,1-1.62-.12,25.48,25.48,0,0,1-12.08-4.51h0a18.37,18.37,0,0,1-1.73-1.32,24.25,24.25,0,0,1-2.27-2.15,25.39,25.39,0,0,1-6.68-14,25.64,25.64,0,1,1,50.79-7Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 311.968px 123.34px"
                            id="elp6wfu5xbios"
                            class="animable"
                        ></path>
                        <g
                            id="freepik--group--inject-49"
                            class="animable"
                            style="transform-origin: 313.715px 125.017px"
                        >
                            <path
                                d="M297.28,144.56a18.37,18.37,0,0,1-1.73-1.32,24.25,24.25,0,0,1-2.27-2.15,7.35,7.35,0,0,1,2.26-1.9A3.14,3.14,0,0,1,296,139h0l0,0Z"
                                style="fill: rgb(64, 123, 255); transform-origin: 295.28px 141.78px"
                                id="elajektdio2fe"
                                class="animable"
                            ></path>
                            <g id="elk91t5mekm7g">
                                <path
                                    d="M297.28,144.56a18.37,18.37,0,0,1-1.73-1.32,24.25,24.25,0,0,1-2.27-2.15,7.35,7.35,0,0,1,2.26-1.9A2.78,2.78,0,0,1,296,139h0l0,0h0Z"
                                    style="
                                        fill: rgb(255, 255, 255);
                                        isolation: isolate;
                                        opacity: 0.7;
                                        transform-origin: 295.28px 141.78px;
                                    "
                                    class="animable"
                                ></path>
                            </g>
                            <path
                                d="M334.15,136.47A25.61,25.61,0,0,1,311,149.2a14.36,14.36,0,0,1-1.62-.12,25.48,25.48,0,0,1-12.08-4.51h0a18.37,18.37,0,0,1-1.73-1.32c.11-1.46.25-2.88.43-4.23h0c.47-.09,4.64-.83,10.57-1.52l.81-.1c1.26-.15,2.6-.29,4-.42l2.49-.22c2.58-.21,5.31-.38,8.08-.47l2.1,0C327.47,136.15,330.88,136.21,334.15,136.47Z"
                                style="fill: rgb(64, 123, 255); transform-origin: 314.86px 142.718px"
                                id="elm7q8fwg90ss"
                                class="animable"
                            ></path>
                            <g id="elgah1ka6b1pu">
                                <path
                                    d="M334.15,136.47A25.61,25.61,0,0,1,311,149.2a14.36,14.36,0,0,1-1.62-.12,25.48,25.48,0,0,1-12.08-4.51h0a18.37,18.37,0,0,1-1.73-1.32c.11-1.46.26-2.88.44-4.23h0c.47-.09,4.64-.83,10.57-1.52l.81-.1c1.26-.15,2.6-.29,4-.42l2.49-.22c2.58-.21,5.31-.38,8.08-.47l2.1,0C327.47,136.15,330.88,136.21,334.15,136.47Z"
                                    style="
                                        fill: rgb(255, 255, 255);
                                        isolation: isolate;
                                        opacity: 0.7;
                                        transform-origin: 314.86px 142.718px;
                                    "
                                    class="animable"
                                ></path>
                            </g>
                            <path
                                d="M315.45,140.11l-2,2.18-2.15,2.31a43.13,43.13,0,0,0-.3,4.6,14.36,14.36,0,0,1-1.62-.12c.24-2.87.42-4.68.42-4.68l-.91-2.6-.61-1.73,3.33-.64Z"
                                style="fill: rgb(38, 50, 56); transform-origin: 311.865px 144.315px"
                                id="elpthd4clqi1m"
                                class="animable"
                            ></path>
                            <path
                                d="M322.05,136.18c-2.71,3.24-10.45,3.25-10.45,3.25s-4.92-.65-4.13-2.27c2.73-.84,3.9-2.33,4.23-4.08a8.11,8.11,0,0,0-.16-3.23,16.27,16.27,0,0,0-.48-1.75l8.43-8.25C318.9,124.61,318.56,133.27,322.05,136.18Z"
                                style="fill: rgb(228, 137, 123); transform-origin: 314.717px 129.64px"
                                id="elzmuyu5usuq"
                                class="animable"
                            ></path>
                            <g id="ellpjkd80uv">
                                <path
                                    d="M317.93,124.57c.41,5.69-4,7.88-6.23,8.51a8.11,8.11,0,0,0-.16-3.23Z"
                                    style="isolation: isolate; opacity: 0.2; transform-origin: 314.748px 128.825px"
                                    class="animable"
                                ></path>
                            </g>
                            <path
                                d="M320.17,132.79l-8.41,5.29-1-3.18-3.14,1.62a2.74,2.74,0,0,0-1.41,3.09l.87,3.51,4.21-3.12,2.71,2.9,10.07-6.69Z"
                                style="fill: rgb(64, 123, 255); transform-origin: 315.101px 137.955px"
                                id="elpzbkre61ku"
                                class="animable"
                            ></path>
                            <g id="elk5s58cfn6ll">
                                <path
                                    d="M320.17,132.79l-8.41,5.29-1-3.18-3.14,1.62a2.74,2.74,0,0,0-1.41,3.09l.87,3.51,4.21-3.12,2.71,2.9,10.07-6.69Z"
                                    style="
                                        fill: rgb(255, 255, 255);
                                        isolation: isolate;
                                        opacity: 0.6;
                                        transform-origin: 315.101px 137.955px;
                                    "
                                    class="animable"
                                ></path>
                            </g>
                            <path
                                d="M298.44,109.46s-.15,9.24,5.12,12.07,3-14,3-14Z"
                                style="fill: rgb(38, 50, 56); transform-origin: 302.743px 114.69px"
                                id="elay9isx3t6eb"
                                class="animable"
                            ></path>
                            <path
                                d="M318.48,126.85a8.3,8.3,0,0,1-9,4.45,9.19,9.19,0,0,1-5.79-3.55,6.76,6.76,0,0,1-.55-.81c-3.11-5.21-5.17-14.78.19-19.2a9,9,0,0,1,14.5,4.88C319.41,119,320.65,122.66,318.48,126.85Z"
                                style="fill: rgb(228, 137, 123); transform-origin: 309.833px 118.562px"
                                id="el2dgihcd5p4q"
                                class="animable"
                            ></path>
                            <path
                                d="M308.86,117.34c.2.5,0,1-.31,1.11s-.74-.22-.9-.73,0-1,.32-1.11S308.7,116.83,308.86,117.34Z"
                                style="fill: rgb(38, 50, 56); transform-origin: 308.264px 117.53px"
                                id="el3eacekrvdg3"
                                class="animable"
                            ></path>
                            <path
                                d="M303.1,119.15c.19.49,0,1-.32,1.11s-.73-.23-.89-.74,0-1,.31-1.11S302.94,118.66,303.1,119.15Z"
                                style="fill: rgb(38, 50, 56); transform-origin: 302.501px 119.335px"
                                id="eluzx0qfc05pb"
                                class="animable"
                            ></path>
                            <path
                                d="M305,118.83a19.07,19.07,0,0,1-1.07,5.12,3.08,3.08,0,0,0,2.59-.31Z"
                                style="fill: rgb(222, 87, 83); transform-origin: 305.225px 121.467px"
                                id="eluoq7fp4bpxs"
                                class="animable"
                            ></path>
                            <path
                                d="M300.19,117.35a.31.31,0,0,0,.31-.1,2.5,2.5,0,0,1,2.07-.92.31.31,0,0,0,.08-.62h0a3.1,3.1,0,0,0-2.62,1.13.31.31,0,0,0,0,.44h0A.37.37,0,0,0,300.19,117.35Z"
                                style="fill: rgb(38, 50, 56); transform-origin: 301.43px 116.531px"
                                id="el2uedhsn41ym"
                                class="animable"
                            ></path>
                            <path
                                d="M309.28,114.68a.33.33,0,0,0,.15-.11.31.31,0,0,0-.16-.41h0a3.1,3.1,0,0,0-2.87.15.31.31,0,0,0-.08.43h0a.31.31,0,0,0,.43.08h0a2.55,2.55,0,0,1,2.27-.08A.3.3,0,0,0,309.28,114.68Z"
                                style="fill: rgb(38, 50, 56); transform-origin: 307.861px 114.376px"
                                id="el2650dankhj1"
                                class="animable"
                            ></path>
                            <path
                                d="M310.78,106.24l.39,2.89a2.16,2.16,0,0,1,1.74,2.35c-.29,2.59,2,5.9,4.19,6.88,0,0-.21-1,.71-1s2.07,5.4,1.06,8.37c0,0,1.94-3,1.91-8.91,0-5.5-1-9.84-2.56-11.56Z"
                                style="fill: rgb(38, 50, 56); transform-origin: 315.78px 115.495px"
                                id="elp3smu3jogc"
                                class="animable"
                            ></path>
                            <path
                                d="M322.17,116.9a6.23,6.23,0,0,1-2.48,4.08c-1.77,1.29-3.41-.12-3.56-2.19-.12-1.84.64-4.78,2.74-5.23A2.79,2.79,0,0,1,322.17,116.9Z"
                                style="fill: rgb(228, 137, 123); transform-origin: 319.178px 117.487px"
                                id="elyqa8u2c6wsk"
                                class="animable"
                            ></path>
                            <path
                                d="M307.43,125.14a17.18,17.18,0,0,1,1.5,2l.4-.18c1.82-.82,2.39-1.79,2.47-2.63a2.49,2.49,0,0,0-.19-1.2,2.46,2.46,0,0,0-.34-.61,9.26,9.26,0,0,1-3.23,2.34C307.67,125,307.43,125.14,307.43,125.14Z"
                                style="fill: rgb(38, 50, 56); transform-origin: 309.62px 124.83px"
                                id="elzuumtho83lh"
                                class="animable"
                            ></path>
                            <path
                                d="M308,124.85l.46.57c1.71-.77,2.81-1.54,3.11-2.3a2.46,2.46,0,0,0-.34-.61A9.26,9.26,0,0,1,308,124.85Z"
                                style="fill: rgb(255, 255, 255); transform-origin: 309.785px 123.965px"
                                id="elno3yvn6duw"
                                class="animable"
                            ></path>
                            <path
                                d="M309.33,127c1.82-.82,2.39-1.79,2.47-2.63a6.49,6.49,0,0,0-1.83,1.3A2.41,2.41,0,0,0,309.33,127Z"
                                style="fill: rgb(222, 87, 83); transform-origin: 310.565px 125.685px"
                                id="elf18nlda6wc8"
                                class="animable"
                            ></path>
                            <path
                                d="M317.89,121.42h0c-.34-1.17-.72-2.29-1-3.17-.22-.61-.41-1.11-.55-1.46s-.21-.54-.21-.54l-.92-.37a12.06,12.06,0,0,1,.31,1.36c.19,1.08.3,2.5-.26,3.15,0,0-3.76.93-5,1.48a4.08,4.08,0,0,0-1.87,2.18s-3.07-.23-4.06,2.19a10,10,0,0,1-2.85-2.93l-.11-.19s1,6.31,5,9.2a7.18,7.18,0,0,0,5.33,1.18,10.73,10.73,0,0,0,6.57-3.78,5.43,5.43,0,0,0,.63-3.57A24.57,24.57,0,0,0,317.89,121.42Zm-9.24,3a4.87,4.87,0,0,1,2.53-1.76.8.8,0,0,1,.15,0,4.4,4.4,0,0,1,.65-.15,2.89,2.89,0,0,1,3,1.82,2.64,2.64,0,0,1,0,2.31,2.31,2.31,0,0,1-3.33,1,2.55,2.55,0,0,1-.74-.66l-1.1.82s1.46.92.61,2.06-4,1.22-4.68-1.65S308.65,124.39,308.65,124.39Z"
                                style="fill: rgb(38, 50, 56); transform-origin: 310.172px 124.743px"
                                id="elpwet1028h1q"
                                class="animable"
                            ></path>
                            <path
                                d="M311.17,109.13s-13.71,6.9-13.39-3c0,0,7.13-5.65,14.08-5.3s7.38,7.43,7.38,7.43Z"
                                style="fill: rgb(38, 50, 56); transform-origin: 308.507px 106.142px"
                                id="eln74ltm24n0j"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M312,153.73a30,30,0,0,1-16.06-4.66.42.42,0,0,1-.13-.59.44.44,0,0,1,.59-.13,29.16,29.16,0,0,0,15.6,4.53h.39a.43.43,0,0,1,0,.85Zm12.78-2.86a.44.44,0,0,1-.39-.25.43.43,0,0,1,.21-.57c.5-.24,1-.49,1.49-.76a.43.43,0,0,1,.58.17.42.42,0,0,1-.17.58c-.5.28-1,.54-1.54.79A.58.58,0,0,1,324.74,150.87Zm5.1-3.09a.44.44,0,0,1-.34-.17.43.43,0,0,1,.09-.6,29.37,29.37,0,0,0,9.91-13.33.43.43,0,1,1,.8.29,30.12,30.12,0,0,1-10.2,13.72A.43.43,0,0,1,329.84,147.78Zm-37.15-1.17a.47.47,0,0,1-.27-.1q-.66-.57-1.29-1.17a.43.43,0,0,1,0-.6.42.42,0,0,1,.6,0c.41.38.82.76,1.25,1.13a.43.43,0,0,1-.28.75Zm-8.35-11.71a.43.43,0,0,1-.4-.27,29.74,29.74,0,0,1-1.8-6.92,30.62,30.62,0,0,1-.29-4.16,29.66,29.66,0,0,1,.6-6,.42.42,0,0,1,.5-.34.43.43,0,0,1,.33.51,29.43,29.43,0,0,0-.58,5.78,30.48,30.48,0,0,0,.28,4,29.26,29.26,0,0,0,1.76,6.73.42.42,0,0,1-.24.55Zm57.28-13.25a.43.43,0,0,1-.43-.39q-.06-.84-.18-1.68a.43.43,0,0,1,.37-.48.43.43,0,0,1,.48.37c.08.57.14,1.15.19,1.72a.43.43,0,0,1-.4.46Zm-1.46-7.13a.44.44,0,0,1-.41-.29c-.17-.54-.37-1.07-.58-1.58a.43.43,0,0,1,.8-.32c.21.53.41,1.07.59,1.62a.42.42,0,0,1-.26.54ZM284,114a.35.35,0,0,1-.14,0,.43.43,0,0,1-.26-.55c.2-.54.41-1.08.63-1.61a.43.43,0,1,1,.79.33c-.22.52-.43,1-.62,1.57A.42.42,0,0,1,284,114Zm53.69-4.92a.42.42,0,0,1-.37-.22,29.33,29.33,0,0,0-12.09-11.4.43.43,0,0,1,.39-.76,30.06,30.06,0,0,1,12.43,11.74.42.42,0,0,1-.15.58A.42.42,0,0,1,337.7,109.08ZM292,102a.45.45,0,0,1-.32-.14.43.43,0,0,1,0-.6,30,30,0,0,1,15.39-7.45.44.44,0,0,1,.49.36.43.43,0,0,1-.35.49,29.15,29.15,0,0,0-14.95,7.23A.48.48,0,0,1,292,102Zm21.13-7.72h0l-1.14,0h-.54a.41.41,0,0,1-.44-.42.44.44,0,0,1,.42-.44H312l1.12,0a.44.44,0,0,1,.41.44A.43.43,0,0,1,313.13,94.31Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 311.991px 123.575px"
                            id="elsi3fn1vl5ae"
                            class="animable"
                        ></path>
                        <g id="el6noi75r62oj">
                            <g style="opacity: 0.5; transform-origin: 311.991px 123.575px" class="animable">
                                <path
                                    d="M312,153.73a30,30,0,0,1-16.06-4.66.42.42,0,0,1-.13-.59.44.44,0,0,1,.59-.13,29.16,29.16,0,0,0,15.6,4.53h.39a.43.43,0,0,1,0,.85Zm12.78-2.86a.44.44,0,0,1-.39-.25.43.43,0,0,1,.21-.57c.5-.24,1-.49,1.49-.76a.43.43,0,0,1,.58.17.42.42,0,0,1-.17.58c-.5.28-1,.54-1.54.79A.58.58,0,0,1,324.74,150.87Zm5.1-3.09a.44.44,0,0,1-.34-.17.43.43,0,0,1,.09-.6,29.37,29.37,0,0,0,9.91-13.33.43.43,0,1,1,.8.29,30.12,30.12,0,0,1-10.2,13.72A.43.43,0,0,1,329.84,147.78Zm-37.15-1.17a.47.47,0,0,1-.27-.1q-.66-.57-1.29-1.17a.43.43,0,0,1,0-.6.42.42,0,0,1,.6,0c.41.38.82.76,1.25,1.13a.43.43,0,0,1-.28.75Zm-8.35-11.71a.43.43,0,0,1-.4-.27,29.74,29.74,0,0,1-1.8-6.92,30.62,30.62,0,0,1-.29-4.16,29.66,29.66,0,0,1,.6-6,.42.42,0,0,1,.5-.34.43.43,0,0,1,.33.51,29.43,29.43,0,0,0-.58,5.78,30.48,30.48,0,0,0,.28,4,29.26,29.26,0,0,0,1.76,6.73.42.42,0,0,1-.24.55Zm57.28-13.25a.43.43,0,0,1-.43-.39q-.06-.84-.18-1.68a.43.43,0,0,1,.37-.48.43.43,0,0,1,.48.37c.08.57.14,1.15.19,1.72a.43.43,0,0,1-.4.46Zm-1.46-7.13a.44.44,0,0,1-.41-.29c-.17-.54-.37-1.07-.58-1.58a.43.43,0,0,1,.8-.32c.21.53.41,1.07.59,1.62a.42.42,0,0,1-.26.54ZM284,114a.35.35,0,0,1-.14,0,.43.43,0,0,1-.26-.55c.2-.54.41-1.08.63-1.61a.43.43,0,1,1,.79.33c-.22.52-.43,1-.62,1.57A.42.42,0,0,1,284,114Zm53.69-4.92a.42.42,0,0,1-.37-.22,29.33,29.33,0,0,0-12.09-11.4.43.43,0,0,1,.39-.76,30.06,30.06,0,0,1,12.43,11.74.42.42,0,0,1-.15.58A.42.42,0,0,1,337.7,109.08ZM292,102a.45.45,0,0,1-.32-.14.43.43,0,0,1,0-.6,30,30,0,0,1,15.39-7.45.44.44,0,0,1,.49.36.43.43,0,0,1-.35.49,29.15,29.15,0,0,0-14.95,7.23A.48.48,0,0,1,292,102Zm21.13-7.72h0l-1.14,0h-.54a.41.41,0,0,1-.44-.42.44.44,0,0,1,.42-.44H312l1.12,0a.44.44,0,0,1,.41.44A.43.43,0,0,1,313.13,94.31Z"
                                    style="fill: rgb(255, 255, 255); transform-origin: 311.991px 123.575px"
                                    id="el4os229xfkvv"
                                    class="animable"
                                ></path>
                            </g>
                        </g>
                    </g>
                    <g
                        id="freepik--character-3--inject-49"
                        class="animable"
                        style="transform-origin: 296.515px 225.578px"
                    >
                        <path
                            d="M313.85,217a19.26,19.26,0,0,1,.95,14.63c-.12.38-.26.75-.41,1.12-.25.61-.52,1.2-.83,1.79-.22.42-.46.84-.72,1.24a19.11,19.11,0,0,1-7.87,7.07,2.06,2.06,0,0,1-.26.12,14,14,0,0,1-1.33.57,16.45,16.45,0,0,1-1.8.59,18,18,0,0,1-2.78.54,17.76,17.76,0,0,1-2.82.13,20.36,20.36,0,0,1-2.21-.18,17.39,17.39,0,0,1-1.75-.33A19.32,19.32,0,1,1,313.85,217Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 296.495px 225.493px"
                            id="elv0gy53f6j09"
                            class="animable"
                        ></path>
                        <path
                            d="M293.77,244.58a17.39,17.39,0,0,1-1.75-.33,19.44,19.44,0,0,1-2.56-.8,15.73,15.73,0,0,1,1.43-3.82s0,0,0,0Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 291.615px 242.105px"
                            id="elq0cpjq1gmcc"
                            class="animable"
                        ></path>
                        <g id="elhj74gj7ftto">
                            <path
                                d="M293.77,244.58a17.39,17.39,0,0,1-1.75-.33,19.44,19.44,0,0,1-2.56-.8,15.73,15.73,0,0,1,1.43-3.82s0,0,0,0Z"
                                style="
                                    fill: rgb(255, 255, 255);
                                    isolation: isolate;
                                    opacity: 0.3;
                                    transform-origin: 291.615px 242.105px;
                                "
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M312.45,231.24c.22.55.44,1.12.65,1.72l0,.08a12.56,12.56,0,0,1,.43,1.46c-.22.42-.46.84-.72,1.24a19.11,19.11,0,0,1-7.87,7.07,2.06,2.06,0,0,1-.26.12,14,14,0,0,1-1.33.57,16.45,16.45,0,0,1-1.8.59,18,18,0,0,1-2.78.54,17.76,17.76,0,0,1-2.82.13,27.7,27.7,0,0,1-4.31-5.62c-3.43-5.64-6.05-12.71-6.08-15.17h0c0-1,1.11-2,2.78-2.86l.34-.17.17-.08a44.56,44.56,0,0,1,7.7-2.55l.48-.11,1.53-.37h0c.73-.16,1.41-.31,2-.43h0l1.67-.33,1.49-.26c0,.09.05.19.08.28C304.63,219.15,309.07,222.82,312.45,231.24Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 299.545px 230.79px"
                            id="elpju58ov3n1"
                            class="animable"
                        ></path>
                        <path
                            d="M314.17,231c.07.6.15,1.19.22,1.75-.25.61-.52,1.2-.83,1.79-.22.42-.46.84-.72,1.24a19.11,19.11,0,0,1-7.87,7.07,2.06,2.06,0,0,1-.26.12,14,14,0,0,1-1.33.57,16.45,16.45,0,0,1-1.8.59,18,18,0,0,1-2.78.54,17.76,17.76,0,0,1-2.82.13,20.36,20.36,0,0,1-2.21-.18,17.39,17.39,0,0,1-1.75-.33l-.19-.51c-1.21-3.23-1-4-.94-4.11s0,0,0,0l.76-.46c1.18-.7,3.55-2.08,5.88-3.22l.43-.21,1.14-.5q2.64-1.12,5.4-2l1.62-.49,1.2-.34q2.54-.7,5.11-1.15C313,231.13,313.6,231,314.17,231Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 302.614px 237.905px"
                            id="elk2sjs738v7"
                            class="animable"
                        ></path>
                        <g id="el84bnp7ig9j">
                            <path
                                d="M314.17,231c.07.6.15,1.19.22,1.75-.25.61-.52,1.2-.83,1.79-.22.42-.46.84-.72,1.24a19.11,19.11,0,0,1-7.87,7.07,2.06,2.06,0,0,1-.26.12,14,14,0,0,1-1.33.57,16.45,16.45,0,0,1-1.8.59,18,18,0,0,1-2.78.54,17.76,17.76,0,0,1-2.82.13,20.36,20.36,0,0,1-2.21-.18,17.39,17.39,0,0,1-1.75-.33l-.19-.51c-1.21-3.23-1-4-.94-4.11s0,0,0,0l.76-.46c1.18-.7,3.55-2.08,5.88-3.22l.43-.21,1.14-.5q2.64-1.12,5.4-2l1.62-.49,1.2-.34q2.54-.7,5.11-1.15C313,231.13,313.6,231,314.17,231Z"
                                style="
                                    fill: rgb(255, 255, 255);
                                    isolation: isolate;
                                    opacity: 0.3;
                                    transform-origin: 302.614px 237.905px;
                                "
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M306.12,235.35l3.43,1.57a21.27,21.27,0,0,0-4.84,6,14,14,0,0,1-1.33.57,16.45,16.45,0,0,1-1.8.59,18,18,0,0,1-2.78.54,13,13,0,0,0-3.28-1.39,15.92,15.92,0,0,1,2.25-4.26,16.92,16.92,0,0,0-4,.67,41.57,41.57,0,0,1,3.78-3.73c.51-.43,1-.86,1.55-1.22a10.43,10.43,0,0,1,1.74-1,22.75,22.75,0,0,1,2.92-1.08,8.15,8.15,0,0,1,3.58-.22,7.74,7.74,0,0,1,2.72,1Z"
                            style="fill: rgb(255, 255, 255); transform-origin: 301.915px 238.453px"
                            id="elvp1hk5h6aa"
                            class="animable"
                        ></path>
                        <path
                            d="M305.66,233.76a.54.54,0,0,1,0,.11.73.73,0,0,0-.07.21.43.43,0,0,0,0,0c-.36,1.33-1.57,5.89-2.18,9.37a16.45,16.45,0,0,1-1.8.59,21,21,0,0,1-2.86-6.82c-.06-.3-.12-.61-.17-.92Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 302.121px 238.9px"
                            id="el0ls2t42pmbej"
                            class="animable"
                        ></path>
                        <path
                            d="M301.27,238.83c4-2.63,4.39-5.07,4.39-5.07-4-1.23-3.87-6.75-3.87-6.75l-4.66,3.46a16.69,16.69,0,0,1,1.25,2.06c1.57,3.1.17,3.82.17,3.82C298.48,238.48,301.27,238.83,301.27,238.83Z"
                            style="fill: rgb(238, 193, 187); transform-origin: 301.395px 232.92px"
                            id="elir8haaxhoi"
                            class="animable"
                        ></path>
                        <g id="elc51eef17zkc">
                            <path
                                d="M297.13,230.47a16.69,16.69,0,0,1,1.25,2.06,6.34,6.34,0,0,0,3.41-5.52Z"
                                style="isolation: isolate; opacity: 0.2; transform-origin: 299.46px 229.77px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M293,214.74c-4.58,1.94-5,5-3.36,9.87,2.08,6.08,5.16,9.71,10.35,6C307,225.64,300.56,211.52,293,214.74Z"
                            style="fill: rgb(238, 193, 187); transform-origin: 295.882px 223.188px"
                            id="el12d5iqw8h0nk"
                            class="animable"
                        ></path>
                        <path
                            d="M292.44,223.1a10.36,10.36,0,0,1-.52,2.47,1.36,1.36,0,0,0,1.42,0Z"
                            style="fill: rgb(212, 130, 125); transform-origin: 292.63px 224.435px"
                            id="elabwoh8cdf2m"
                            class="animable"
                        ></path>
                        <path
                            d="M295.09,221.54c.15.38.48.61.73.51s.34-.49.19-.87-.48-.61-.73-.51S294.94,221.16,295.09,221.54Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 295.55px 221.36px"
                            id="el7fg38af1sgy"
                            class="animable"
                        ></path>
                        <path
                            d="M295.39,220.65h-1S295.12,221.19,295.39,220.65Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 294.89px 220.77px"
                            id="el9br3fg5hjvt"
                            class="animable"
                        ></path>
                        <path
                            d="M290.34,223.33c.15.38.47.61.73.51s.33-.49.18-.87-.47-.61-.73-.51S290.19,223,290.34,223.33Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 290.795px 223.15px"
                            id="elok96b4wd9sa"
                            class="animable"
                        ></path>
                        <path
                            d="M290.64,222.44h-1S290.37,223,290.64,222.44Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 290.14px 222.564px"
                            id="elx6qwlnqxddp"
                            class="animable"
                        ></path>
                        <path
                            d="M293.8,218.58a.21.21,0,0,1-.19-.11.22.22,0,0,1,.08-.3,2.8,2.8,0,0,1,2.49-.15.22.22,0,0,1,.09.3.22.22,0,0,1-.3.09,2.39,2.39,0,0,0-2.06.14A.2.2,0,0,1,293.8,218.58Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 294.939px 218.189px"
                            id="el1e7xv9ysfks"
                            class="animable"
                        ></path>
                        <path
                            d="M288.72,221a.28.28,0,0,1-.12,0,.22.22,0,0,1-.06-.31,2.52,2.52,0,0,1,1.84-1.24.22.22,0,0,1,.23.21.23.23,0,0,1-.21.23h0a2.09,2.09,0,0,0-1.49,1A.26.26,0,0,1,288.72,221Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 289.555px 220.228px"
                            id="el3bhhg3wlc0m"
                            class="animable"
                        ></path>
                        <path
                            d="M294.77,227.09a12.38,12.38,0,0,1,1.21,1.37l.28-.15c1.28-.7,1.64-1.45,1.65-2.06a1.78,1.78,0,0,0-.21-.87,1.93,1.93,0,0,0-.28-.42,6.8,6.8,0,0,1-2.22,1.89A4.88,4.88,0,0,1,294.77,227.09Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 296.34px 226.71px"
                            id="el1pt7rkouoo2h"
                            class="animable"
                        ></path>
                        <path
                            d="M295.2,226.85l.37.39c1.2-.66,2-1.29,2.13-1.86a1.93,1.93,0,0,0-.28-.42A6.8,6.8,0,0,1,295.2,226.85Z"
                            style="fill: rgb(255, 255, 255); transform-origin: 296.45px 226.1px"
                            id="elkbpp9xe4rx"
                            class="animable"
                        ></path>
                        <path
                            d="M296.26,228.31c1.28-.7,1.64-1.45,1.65-2.06a4.73,4.73,0,0,0-1.26,1.05A1.76,1.76,0,0,0,296.26,228.31Z"
                            style="fill: rgb(222, 87, 83); transform-origin: 297.085px 227.28px"
                            id="elannkd7tvcda"
                            class="animable"
                        ></path>
                        <path
                            d="M301.22,220.34s-3.73-2.86-4.64-5.9c0,0-10.64.13-7.19,9.53,0,0-4.35-7.8,3.45-11.31s12.63,8,10,13.17C302.85,225.83,303.54,222.13,301.22,220.34Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 295.871px 218.918px"
                            id="el9zkai8fogv8"
                            class="animable"
                        ></path>
                        <path
                            d="M300.88,221.62a2.18,2.18,0,0,1,1.39-2.75c1.48-.44,3.39,2.19.15,4.38C302,223.56,301.47,223.19,300.88,221.62Z"
                            style="fill: rgb(238, 193, 187); transform-origin: 302.482px 221.086px"
                            id="el47x0vk1slfv"
                            class="animable"
                        ></path>
                        <path
                            d="M295.18,214.58a18.8,18.8,0,0,0,7.73,9.22,6.68,6.68,0,0,1,3.1,7.3s4.95-5-1.78-12.15c0,0-.89-8.92-7.39-8.26,0,0-1.15-2.28-5.92.59s-6.69,9.1-4.79,14.91,7.7,10.49,7.7,10.49S281.39,218.88,295.18,214.58Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 296.585px 223.256px"
                            id="elq02fniflz0s"
                            class="animable"
                        ></path>
                        <path
                            d="M295.49,214.53a14.71,14.71,0,0,0,1.57,4.14,21.38,21.38,0,0,0,2.6,3.67,18.22,18.22,0,0,0,3.34,3,12.23,12.23,0,0,0,4.07,1.94,12.52,12.52,0,0,1-4.16-1.8,19,19,0,0,1-3.49-3,23,23,0,0,1-2.78-3.65,14.85,14.85,0,0,1-1.78-4.28Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 300.965px 220.905px"
                            id="elf9ovgga7sfp"
                            class="animable"
                        ></path>
                        <path
                            d="M314.8,231.59c-.12.38-.26.75-.41,1.12-.25.61-.52,1.2-.83,1.79-.22.42-.46.84-.72,1.24a9,9,0,0,1,.26-2.78,4.79,4.79,0,0,1,1.07-2Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 313.811px 233.35px"
                            id="elk4vemysj0r"
                            class="animable"
                        ></path>
                        <g id="ellprxn0j9wg">
                            <path
                                d="M314.8,231.59c-.12.38-.26.75-.41,1.12-.25.61-.52,1.2-.83,1.79-.22.42-.46.84-.72,1.24a9,9,0,0,1,.26-2.78,4.79,4.79,0,0,1,1.07-2Z"
                                style="
                                    fill: rgb(255, 255, 255);
                                    isolation: isolate;
                                    opacity: 0.3;
                                    transform-origin: 313.811px 233.35px;
                                "
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M296.51,248.17a23.1,23.1,0,0,1-5.55-.68.33.33,0,0,1,.16-.63,22,22,0,0,0,12.51-.52.32.32,0,0,1,.41.2.34.34,0,0,1-.2.41A22.63,22.63,0,0,1,296.51,248.17ZM288,246.49l-.12,0c-.4-.16-.8-.34-1.19-.53a.32.32,0,0,1,.27-.58c.39.19.77.36,1.16.52a.32.32,0,0,1,.18.42A.33.33,0,0,1,288,246.49ZM311.93,242a.3.3,0,0,1-.23-.1.32.32,0,0,1,0-.45c.31-.29.6-.59.89-.9a.32.32,0,1,1,.47.44c-.29.32-.6.63-.92.93A.35.35,0,0,1,311.93,242Zm-32.68-1.93A.32.32,0,0,1,279,240a22.79,22.79,0,0,1-5.08-11.84.33.33,0,0,1,.29-.36.32.32,0,0,1,.35.28,22.09,22.09,0,0,0,4.94,11.51.33.33,0,0,1-.05.46A.31.31,0,0,1,279.25,240.07Zm35.61-1.48a.3.3,0,0,1-.18-.06.32.32,0,0,1-.08-.45,22.09,22.09,0,0,0,4-11.88.3.3,0,0,1,.33-.31.32.32,0,0,1,.31.34,22.71,22.71,0,0,1-4.07,12.22A.35.35,0,0,1,314.86,238.59ZM274.1,225.18h0a.32.32,0,0,1-.31-.33c0-.44,0-.88.07-1.31a.32.32,0,0,1,.35-.29.31.31,0,0,1,.29.35c0,.42-.06.84-.07,1.26A.32.32,0,0,1,274.1,225.18Zm43-8.07a.32.32,0,0,1-.29-.2c-.17-.39-.34-.77-.53-1.15a.32.32,0,1,1,.58-.29c.19.4.37.79.54,1.19a.32.32,0,0,1-.17.42A.28.28,0,0,1,317.14,217.11ZM277,214.73a.28.28,0,0,1-.15,0,.33.33,0,0,1-.13-.44A22.7,22.7,0,0,1,286,205.3a.33.33,0,1,1,.3.58,21.93,21.93,0,0,0-9,8.69A.31.31,0,0,1,277,214.73Zm37.43-2.37a.33.33,0,0,1-.26-.13c-.25-.34-.52-.68-.79-1a.33.33,0,0,1,0-.45.32.32,0,0,1,.46,0q.4.5.81,1a.33.33,0,0,1-.07.45A.28.28,0,0,1,314.43,212.36Zm-3-3.32a.35.35,0,0,1-.22-.08,22.05,22.05,0,0,0-11.33-5.33.32.32,0,0,1-.27-.37.33.33,0,0,1,.37-.27,22.77,22.77,0,0,1,11.66,5.49.33.33,0,0,1,0,.45A.35.35,0,0,1,311.39,209Zm-22.29-4.41a.33.33,0,0,1-.31-.21.32.32,0,0,1,.2-.41c.41-.15.83-.28,1.24-.4a.32.32,0,0,1,.4.22.32.32,0,0,1-.22.4c-.4.11-.81.24-1.21.38A.18.18,0,0,1,289.1,204.63Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 296.515px 225.578px"
                            id="el0knsewlow0on"
                            class="animable"
                        ></path>
                        <g id="elwv4hwfju7ct">
                            <g style="opacity: 0.5; transform-origin: 296.515px 225.578px" class="animable">
                                <path
                                    d="M296.51,248.17a23.1,23.1,0,0,1-5.55-.68.33.33,0,0,1,.16-.63,22,22,0,0,0,12.51-.52.32.32,0,0,1,.41.2.34.34,0,0,1-.2.41A22.63,22.63,0,0,1,296.51,248.17ZM288,246.49l-.12,0c-.4-.16-.8-.34-1.19-.53a.32.32,0,0,1,.27-.58c.39.19.77.36,1.16.52a.32.32,0,0,1,.18.42A.33.33,0,0,1,288,246.49ZM311.93,242a.3.3,0,0,1-.23-.1.32.32,0,0,1,0-.45c.31-.29.6-.59.89-.9a.32.32,0,1,1,.47.44c-.29.32-.6.63-.92.93A.35.35,0,0,1,311.93,242Zm-32.68-1.93A.32.32,0,0,1,279,240a22.79,22.79,0,0,1-5.08-11.84.33.33,0,0,1,.29-.36.32.32,0,0,1,.35.28,22.09,22.09,0,0,0,4.94,11.51.33.33,0,0,1-.05.46A.31.31,0,0,1,279.25,240.07Zm35.61-1.48a.3.3,0,0,1-.18-.06.32.32,0,0,1-.08-.45,22.09,22.09,0,0,0,4-11.88.3.3,0,0,1,.33-.31.32.32,0,0,1,.31.34,22.71,22.71,0,0,1-4.07,12.22A.35.35,0,0,1,314.86,238.59ZM274.1,225.18h0a.32.32,0,0,1-.31-.33c0-.44,0-.88.07-1.31a.32.32,0,0,1,.35-.29.31.31,0,0,1,.29.35c0,.42-.06.84-.07,1.26A.32.32,0,0,1,274.1,225.18Zm43-8.07a.32.32,0,0,1-.29-.2c-.17-.39-.34-.77-.53-1.15a.32.32,0,1,1,.58-.29c.19.4.37.79.54,1.19a.32.32,0,0,1-.17.42A.28.28,0,0,1,317.14,217.11ZM277,214.73a.28.28,0,0,1-.15,0,.33.33,0,0,1-.13-.44A22.7,22.7,0,0,1,286,205.3a.33.33,0,1,1,.3.58,21.93,21.93,0,0,0-9,8.69A.31.31,0,0,1,277,214.73Zm37.43-2.37a.33.33,0,0,1-.26-.13c-.25-.34-.52-.68-.79-1a.33.33,0,0,1,0-.45.32.32,0,0,1,.46,0q.4.5.81,1a.33.33,0,0,1-.07.45A.28.28,0,0,1,314.43,212.36Zm-3-3.32a.35.35,0,0,1-.22-.08,22.05,22.05,0,0,0-11.33-5.33.32.32,0,0,1-.27-.37.33.33,0,0,1,.37-.27,22.77,22.77,0,0,1,11.66,5.49.33.33,0,0,1,0,.45A.35.35,0,0,1,311.39,209Zm-22.29-4.41a.33.33,0,0,1-.31-.21.32.32,0,0,1,.2-.41c.41-.15.83-.28,1.24-.4a.32.32,0,0,1,.4.22.32.32,0,0,1-.22.4c-.4.11-.81.24-1.21.38A.18.18,0,0,1,289.1,204.63Z"
                                    style="fill: rgb(255, 255, 255); transform-origin: 296.515px 225.578px"
                                    id="elmyuwi5blyxo"
                                    class="animable"
                                ></path>
                            </g>
                        </g>
                    </g>
                    <g
                        id="freepik--character-2--inject-49"
                        class="animable"
                        style="transform-origin: 227.955px 140.449px"
                    >
                        <path
                            d="M257.2,147.21A29.85,29.85,0,0,1,244,165.82a30.58,30.58,0,0,1-2.67,1.52l-.81.38-.39.18a29.85,29.85,0,0,1-5.33,1.8c-.84.2-1.68.36-2.54.48a26.85,26.85,0,0,1-4.58.31,9.92,9.92,0,0,1-1.09,0,29.43,29.43,0,0,1-5.38-.72c-.81-.19-1.61-.4-2.38-.66a11.1,11.1,0,0,1-1.15-.39,27.84,27.84,0,0,1-5.25-2.5l-.26-.15c-.45-.28-.89-.57-1.32-.88a28.76,28.76,0,0,1-2.67-2.07,26.84,26.84,0,0,1-2.4-2.37.38.38,0,0,1-.12-.13c-.26-.27-.51-.57-.76-.86-.43-.53-.85-1.06-1.24-1.62a30,30,0,1,1,53.5-10.9Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 227.927px 140.503px"
                            id="elq3smprbu2db"
                            class="animable"
                        ></path>
                        <path
                            d="M206,156.94l-.33,3.65c-.26-.27-.51-.57-.76-.86-.43-.53-.85-1.06-1.24-1.62A8.94,8.94,0,0,1,206,156.94Z"
                            style="fill: rgb(224, 224, 224); transform-origin: 204.835px 158.765px"
                            id="elh07z6f3qdlt"
                            class="animable"
                        ></path>
                        <path
                            d="M233.31,167.36h0a10,10,0,0,1-.64,2.12,5,5,0,0,1-.37.69,26.85,26.85,0,0,1-4.58.31,9.92,9.92,0,0,1-1.09,0,29.43,29.43,0,0,1-5.38-.72c-.81-.19-1.61-.4-2.38-.66a11.1,11.1,0,0,1-1.15-.39,27.84,27.84,0,0,1-5.25-2.5,3.36,3.36,0,0,1-.14-.45,6.06,6.06,0,0,1-.2-1.47,9.7,9.7,0,0,1,1-4.26c.07-.14.14-.27.2-.41l.32-.61a.76.76,0,0,1,.07-.13,17,17,0,0,1,2.39-3.21,9.57,9.57,0,0,1,.79-.77,11.91,11.91,0,0,1,2.93-2.07h0a5.87,5.87,0,0,1,1.82-.5c2.47-.3,5.18.73,7.17,1.73l.06,0c.19.1.39.19.57.3,1.2.63,2,1.19,2.26,1.29,0,0,.31.79.67,2,.11.38.23.8.34,1.25.21.83.4,1.76.55,2.74a20.54,20.54,0,0,1,.27,3.17A13.87,13.87,0,0,1,233.31,167.36Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 222.835px 161.386px"
                            id="elhvctk6lpl6"
                            class="animable"
                        ></path>
                        <path
                            d="M242.53,134.29s2.24,12.08-2,15.43-26.75,1.57-29.65-3.13,5.53-18.75,5.53-18.75Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 226.697px 139.644px"
                            id="elsucdxog9etk"
                            class="animable"
                        ></path>
                        <path
                            d="M241.26,163.76l-1.09,4.14a29.85,29.85,0,0,1-5.33,1.8c-.84.2-1.68.36-2.54.48a26.85,26.85,0,0,1-4.58.31,9.92,9.92,0,0,1-1.09,0,29.43,29.43,0,0,1-5.38-.72c-.81-.19-1.61-.4-2.38-.66a11.1,11.1,0,0,1-1.15-.39,27.84,27.84,0,0,1-5.25-2.5l-.26-.15c-.45-.28-.89-.57-1.32-.88a28.76,28.76,0,0,1-2.67-2.07,26.84,26.84,0,0,1-2.4-2.37,22.61,22.61,0,0,1,2.21-4s.47-.2,1.31-.46h0a31.33,31.33,0,0,1,3.64-.89c1-.18,2.06-.35,3.24-.46l.59-.05.41,0h0c.23,0,.47,0,.71,0,.75,0,1.54-.06,2.35,0,.22,0,.44,0,.67,0a31.79,31.79,0,0,1,4,.44c.72.12,1.42.28,2.11.46h0a29.41,29.41,0,0,1,2.92,1l1.06.43.67.31h0l.58.27c.28.13.54.26.81.41a35.81,35.81,0,0,1,4.17,2.52h0A33.17,33.17,0,0,1,241.26,163.76Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 223.54px 162.684px"
                            id="elflh7i17g88u"
                            class="animable"
                        ></path>
                        <path
                            d="M215.29,131.46s.13-19.46,16.84-13.7c21,7.23,6.69,32-3.6,28S215.29,131.46,215.29,131.46Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 229.111px 131.444px"
                            id="elhcny9da9qlb"
                            class="animable"
                        ></path>
                        <g id="el93qgixsc199">
                            <path
                                d="M233.24,161.68l-4.72,6.58-1.19,1.66-.38-.6-4.11-6.69a38.92,38.92,0,0,0-4,6.45,11.1,11.1,0,0,1-1.15-.39c.17-4.95.52-7.8.52-7.8l-5,2.77-1.12.61-1.16.65-.19.1,2.36-8a13,13,0,0,1,2.37-1.21c.18-.08.37-.15.55-.21s.64-.21,1-.29l.67-.14a11.82,11.82,0,0,1,2.35-.22,8.83,8.83,0,0,1,.89,0,15.11,15.11,0,0,1,5.34,1.48,22.71,22.71,0,0,1,4.06,2.52c.34.25.65.51.93.75l.67.58A16.59,16.59,0,0,1,233.24,161.68Z"
                                style="isolation: isolate; opacity: 0.2; transform-origin: 221.99px 162.429px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M219.43,165.4l4.83-6.88,6.26-1.24c-4.24-4.62.08-11.78.08-11.78l-8.75,1a27.49,27.49,0,0,1,.08,3.65c-.32,5.25-2.69,5.13-2.69,5.13l1,2.62Z"
                            style="fill: rgb(228, 137, 123); transform-origin: 224.92px 155.45px"
                            id="el919rcrixaz"
                            class="animable"
                        ></path>
                        <g id="el4vi3kb6cj1q">
                            <path
                                d="M221.85,146.49a27.49,27.49,0,0,1,.08,3.65c4.22-.66,8.67-4.64,8.67-4.64Z"
                                style="isolation: isolate; opacity: 0.2; transform-origin: 226.225px 147.82px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M227.11,122.24c-7.45-1-10.42,2.6-12,10.21-2,9.51-.87,16.63,8.75,15.89C236.87,147.34,239.5,124,227.11,122.24Z"
                            style="fill: rgb(228, 137, 123); transform-origin: 224.708px 135.235px"
                            id="elmdmblge5y8f"
                            class="animable"
                        ></path>
                        <path
                            d="M220,132.71a15.73,15.73,0,0,1-2.61,2.79,2.09,2.09,0,0,0,1.85,1.12Z"
                            style="fill: rgb(222, 87, 83); transform-origin: 218.695px 134.665px"
                            id="elknefhj94n7m"
                            class="animable"
                        ></path>
                        <path
                            d="M224.6,132.74c-.1.62.14,1.16.55,1.23s.82-.37.92-1-.15-1.16-.55-1.23S224.7,132.13,224.6,132.74Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 225.335px 132.855px"
                            id="el7p4jxh8mfzn"
                            class="animable"
                        ></path>
                        <path
                            d="M225.68,131.82l-1.24-.74S224.92,132.3,225.68,131.82Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 225.06px 131.506px"
                            id="el07ie3vsx2peh"
                            class="animable"
                        ></path>
                        <path
                            d="M217,131.37c-.1.61.14,1.16.55,1.23s.82-.38.92-1-.15-1.16-.56-1.23S217.13,130.76,217,131.37Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 217.735px 131.485px"
                            id="elhiu7koflene"
                            class="animable"
                        ></path>
                        <path
                            d="M218.11,130.44l-1.24-.74S217.34,130.93,218.11,130.44Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 217.49px 130.128px"
                            id="el24zc0keg1cm"
                            class="animable"
                        ></path>
                        <path
                            d="M228.47,129.56a.37.37,0,0,1-.32-.18,3.56,3.56,0,0,0-2.76-1.4.38.38,0,0,1-.37-.38.36.36,0,0,1,.38-.37,4.27,4.27,0,0,1,3.39,1.77.37.37,0,0,1-.13.51A.41.41,0,0,1,228.47,129.56Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 226.931px 128.395px"
                            id="elc4spibimz5m"
                            class="animable"
                        ></path>
                        <path
                            d="M217,127.09a.37.37,0,0,1-.16-.7,3.89,3.89,0,0,1,3.4-.19.38.38,0,0,1,.15.5.39.39,0,0,1-.51.16,3.11,3.11,0,0,0-2.72.2A.45.45,0,0,1,217,127.09Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 218.534px 126.494px"
                            id="elx6ycn1rvye"
                            class="animable"
                        ></path>
                        <path
                            d="M233.5,136s-2.63-6.62-1.43-11.27c0,0-13.94-8.12-16.78,6.78,0,0,.43-13.52,13.3-12s10.17,20.26,2.76,24.92C231.35,144.36,235.11,140.09,233.5,136Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 226.433px 131.91px"
                            id="elaie6hwkkigj"
                            class="animable"
                        ></path>
                        <path
                            d="M232.06,137.36a3.3,3.3,0,0,1,3.94-2.5c2.28.58,2.71,5.48-3.2,5.81C232,140.72,231.6,139.85,232.06,137.36Z"
                            style="fill: rgb(228, 137, 123); transform-origin: 234.714px 137.726px"
                            id="el8o107yrqen"
                            class="animable"
                        ></path>
                        <path
                            d="M218.09,139.51a18.78,18.78,0,0,1,.6,2.69h.48c2.21,0,3.23-.71,3.7-1.51a2.81,2.81,0,0,0,.36-1.3,2.47,2.47,0,0,0-.06-.76,10.33,10.33,0,0,1-4.33.86C218.38,139.52,218.09,139.51,218.09,139.51Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 220.664px 140.415px"
                            id="el1qy1pf1ja6a"
                            class="animable"
                        ></path>
                        <path
                            d="M218.84,139.5l.2.79c2.08,0,3.54-.26,4.19-.89a2.47,2.47,0,0,0-.06-.76A10.33,10.33,0,0,1,218.84,139.5Z"
                            style="fill: rgb(255, 255, 255); transform-origin: 221.039px 139.465px"
                            id="el53t43feup1m"
                            class="animable"
                        ></path>
                        <path
                            d="M219.17,142.21c2.21,0,3.23-.71,3.7-1.51a7.08,7.08,0,0,0-2.45.47A2.65,2.65,0,0,0,219.17,142.21Z"
                            style="fill: rgb(222, 87, 83); transform-origin: 221.02px 141.455px"
                            id="elqm1kiksqs5q"
                            class="animable"
                        ></path>
                        <path
                            d="M227.19,122.82s1.28,12.7,9,13.63-2-16.29-2-16.29-11.94-6.53-19.11-.71.17,12,.17,12S216.16,121.89,227.19,122.82Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 225.553px 126.761px"
                            id="elyb7i80h4crb"
                            class="animable"
                        ></path>
                        <path
                            d="M231,134.27a.42.42,0,0,1-.15,0c-5.78-3.86-3.73-12.25-3.71-12.33a.26.26,0,0,1,.31-.19.26.26,0,0,1,.19.31c0,.08-2,8.12,3.5,11.78a.26.26,0,0,1-.14.47Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 229.009px 128.027px"
                            id="eleis2slxe5le"
                            class="animable"
                        ></path>
                        <polygon
                            points="229.01 153.82 224.26 158.52 226.89 167.11 232.29 158.09 229.01 153.82"
                            style="fill: rgb(38, 50, 56); transform-origin: 228.275px 160.465px"
                            id="el2zxc9d7rarm"
                            class="animable"
                        ></polygon>
                        <polygon
                            points="221.37 153.17 220.29 157.89 213.82 162.4 217.38 154.61 221.37 153.17"
                            style="fill: rgb(38, 50, 56); transform-origin: 217.595px 157.785px"
                            id="elr0uhks0axq"
                            class="animable"
                        ></polygon>
                        <path
                            d="M242.44,163.54l-1.07,3.8-.81.38-.39.18a29.85,29.85,0,0,1-5.33,1.8c-.84.2-1.68.36-2.54.48a26.85,26.85,0,0,1-4.58.31c.26-.78.53-1.51.8-2.23a77.5,77.5,0,0,1,3.42-7.89c.28-.57.54-1,.75-1.43s.36-.66.47-.84l.15-.25,3.59,2.24s0,0,0,0Z"
                            style="fill: rgb(224, 224, 224); transform-origin: 235.08px 164.172px"
                            id="elodm8byp2twn"
                            class="animable"
                        ></path>
                        <path
                            d="M216.26,154.93a10.29,10.29,0,0,0-.75.93,26.9,26.9,0,0,0-1.84,3,.76.76,0,0,0-.07.13l-.32.61c-.06.14-.13.27-.2.41-.65,1.32-1.37,2.94-2.11,4.91a.85.85,0,0,0-.08.24,28.76,28.76,0,0,1-2.67-2.07,26.84,26.84,0,0,1-2.4-2.37,2.48,2.48,0,0,0-.17.37l0-.5c-.26-.27-.51-.57-.76-.86a25.39,25.39,0,0,1,1.09-2.79l3.31-.65h0l3.06-.6Z"
                            style="fill: rgb(224, 224, 224); transform-origin: 210.575px 160.045px"
                            id="elwdaruygjl6b"
                            class="animable"
                        ></path>
                        <path
                            d="M219.8,152.81a7.53,7.53,0,0,0-1.39,1.42,6.9,6.9,0,0,0-.43.59,2.37,2.37,0,0,0-.28.4,51.88,51.88,0,0,0-3.66,6.71c-.07.16-.15.31-.21.47-.2.41-.39.83-.58,1.26-.31.68-.62,1.38-.92,2.08,0,.1-.09.2-.12.3-.45-.28-.89-.57-1.32-.88a28.76,28.76,0,0,1-2.67-2.07l1.22-1.13-2-3a24.23,24.23,0,0,1,5-3.31l.58-.29a42.9,42.9,0,0,1,6.76-2.58Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 213.62px 159.41px"
                            id="el48ir0dvs5ut"
                            class="animable"
                        ></path>
                        <g id="elc7z098u685n">
                            <path
                                d="M219.8,152.81a7.53,7.53,0,0,0-1.39,1.42,6.9,6.9,0,0,0-.43.59,2.37,2.37,0,0,0-.28.4,51.88,51.88,0,0,0-3.66,6.71c-.07.16-.15.31-.21.47-.2.41-.39.83-.58,1.26-.31.68-.62,1.38-.92,2.08,0,.1-.09.2-.12.3-.45-.28-.89-.57-1.32-.88a28.76,28.76,0,0,1-2.67-2.07l1.22-1.13-2-3a24.23,24.23,0,0,1,5-3.31l.58-.29a42.9,42.9,0,0,1,6.76-2.58Z"
                                style="
                                    fill: rgb(255, 255, 255);
                                    isolation: isolate;
                                    opacity: 0.7;
                                    transform-origin: 213.62px 159.41px;
                                "
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M233.31,167.37l1.53,2.33c-.84.2-1.68.36-2.54.48a26.85,26.85,0,0,1-4.58.31,9.92,9.92,0,0,1-1.09,0c.11-.39.21-.76.32-1.14.48-1.67,1-3.27,1.46-4.74.71-2.16,1.38-4.06,1.93-5.54.29-.75.54-1.41.75-1.93a3.86,3.86,0,0,0,.15-.39l.44-1.07a19.55,19.55,0,0,1,5.22,4.44s0,0,0,0q.22.25.42.51h0a18.36,18.36,0,0,1,1.43,2l-5.26,2.2-1.46.61,1.26,1.9Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 232.69px 163.092px"
                            id="elznnehm8hzqr"
                            class="animable"
                        ></path>
                        <g id="elub6wx9jjvf">
                            <path
                                d="M233.31,167.37l1.53,2.33c-.84.2-1.68.36-2.54.48a26.85,26.85,0,0,1-4.58.31,9.92,9.92,0,0,1-1.09,0c.11-.39.21-.76.32-1.14.48-1.67,1-3.27,1.46-4.74.71-2.16,1.38-4.06,1.93-5.54.29-.75.54-1.41.75-1.93a3.86,3.86,0,0,0,.15-.39l.44-1.07a19.55,19.55,0,0,1,5.22,4.44s0,0,0,0q.22.25.42.51h0a18.36,18.36,0,0,1,1.43,2l-5.26,2.2-1.46.61,1.26,1.9Z"
                                style="
                                    fill: rgb(255, 255, 255);
                                    isolation: isolate;
                                    opacity: 0.7;
                                    transform-origin: 232.69px 163.092px;
                                "
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M244,165.82a30.58,30.58,0,0,1-2.67,1.52l-.81.38,1.88-4.18A8.32,8.32,0,0,1,244,165.82Z"
                            style="fill: rgb(224, 224, 224); transform-origin: 242.26px 165.63px"
                            id="elkv7z13jmpxg"
                            class="animable"
                        ></path>
                        <path
                            d="M230.76,175.67a.5.5,0,0,1-.5-.46.51.51,0,0,1,.46-.54c.65,0,1.31-.12,1.95-.21a.5.5,0,1,1,.14,1c-.67.09-1.34.17-2,.22Zm6.87-1.26a.49.49,0,0,1-.48-.36.5.5,0,0,1,.34-.62A34.41,34.41,0,0,0,253.87,163a.5.5,0,1,1,.75.65,35.29,35.29,0,0,1-16.85,10.78A.36.36,0,0,1,237.63,174.41ZM216,173.66a.51.51,0,0,1-.17,0,35,35,0,0,1-16.06-11.92.5.5,0,1,1,.8-.6,34.08,34.08,0,0,0,15.6,11.58.5.5,0,0,1,.3.64A.48.48,0,0,1,216,173.66Zm-18.54-15.95a.49.49,0,0,1-.44-.26c-.32-.59-.63-1.19-.92-1.8a.5.5,0,1,1,.9-.43c.28.59.58,1.18.9,1.75a.51.51,0,0,1-.2.68A.53.53,0,0,1,197.47,157.71Zm63.88-7a.36.36,0,0,1-.14,0,.5.5,0,0,1-.34-.62c.18-.62.35-1.26.5-1.9a.5.5,0,1,1,1,.22c-.15.66-.32,1.32-.51,2A.49.49,0,0,1,261.35,150.71Zm1.37-8.4h0a.5.5,0,0,1-.48-.52c0-.44,0-.88,0-1.32v-.65a.5.5,0,0,1,1,0v.67c0,.45,0,.9,0,1.36A.5.5,0,0,1,262.72,142.31Zm-69.53-.87a.5.5,0,0,1-.5-.5v-.4a35.68,35.68,0,0,1,5.44-18.85.49.49,0,0,1,.69-.16.51.51,0,0,1,.16.69,34.09,34.09,0,0,0-4.41,10.62,34.51,34.51,0,0,0-.88,7.7v.39a.5.5,0,0,1-.5.51Zm69.09-6.11a.51.51,0,0,1-.5-.41,34.29,34.29,0,0,0-8.48-17.5.49.49,0,0,1,0-.7.5.5,0,0,1,.71,0,35.24,35.24,0,0,1,8.73,18,.5.5,0,0,1-.41.58Zm-60.77-16.9a.52.52,0,0,1-.33-.12.49.49,0,0,1-.05-.7c.44-.52.89-1,1.36-1.51a.5.5,0,0,1,.71,0,.49.49,0,0,1,0,.7q-.68.72-1.32,1.47A.52.52,0,0,1,201.51,118.43Zm40-9.45a.48.48,0,0,1-.2,0c-.6-.25-1.21-.49-1.83-.71a.5.5,0,1,1,.33-.94c.64.23,1.27.47,1.89.73a.5.5,0,0,1-.19,1Zm-26.32-.33a.5.5,0,0,1-.47-.31.51.51,0,0,1,.28-.65A35.24,35.24,0,0,1,235,105.93a.5.5,0,1,1-.2,1,34.23,34.23,0,0,0-19.36,1.71A.57.57,0,0,1,215.21,108.65Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 227.955px 140.449px"
                            id="elqwkg6idulkb"
                            class="animable"
                        ></path>
                        <g id="elwm9l7v5cn7">
                            <g style="opacity: 0.5; transform-origin: 227.955px 140.449px" class="animable">
                                <path
                                    d="M230.76,175.67a.5.5,0,0,1-.5-.46.51.51,0,0,1,.46-.54c.65,0,1.31-.12,1.95-.21a.5.5,0,1,1,.14,1c-.67.09-1.34.17-2,.22Zm6.87-1.26a.49.49,0,0,1-.48-.36.5.5,0,0,1,.34-.62A34.41,34.41,0,0,0,253.87,163a.5.5,0,1,1,.75.65,35.29,35.29,0,0,1-16.85,10.78A.36.36,0,0,1,237.63,174.41ZM216,173.66a.51.51,0,0,1-.17,0,35,35,0,0,1-16.06-11.92.5.5,0,1,1,.8-.6,34.08,34.08,0,0,0,15.6,11.58.5.5,0,0,1,.3.64A.48.48,0,0,1,216,173.66Zm-18.54-15.95a.49.49,0,0,1-.44-.26c-.32-.59-.63-1.19-.92-1.8a.5.5,0,1,1,.9-.43c.28.59.58,1.18.9,1.75a.51.51,0,0,1-.2.68A.53.53,0,0,1,197.47,157.71Zm63.88-7a.36.36,0,0,1-.14,0,.5.5,0,0,1-.34-.62c.18-.62.35-1.26.5-1.9a.5.5,0,1,1,1,.22c-.15.66-.32,1.32-.51,2A.49.49,0,0,1,261.35,150.71Zm1.37-8.4h0a.5.5,0,0,1-.48-.52c0-.44,0-.88,0-1.32v-.65a.5.5,0,0,1,1,0v.67c0,.45,0,.9,0,1.36A.5.5,0,0,1,262.72,142.31Zm-69.53-.87a.5.5,0,0,1-.5-.5v-.4a35.68,35.68,0,0,1,5.44-18.85.49.49,0,0,1,.69-.16.51.51,0,0,1,.16.69,34.09,34.09,0,0,0-4.41,10.62,34.51,34.51,0,0,0-.88,7.7v.39a.5.5,0,0,1-.5.51Zm69.09-6.11a.51.51,0,0,1-.5-.41,34.29,34.29,0,0,0-8.48-17.5.49.49,0,0,1,0-.7.5.5,0,0,1,.71,0,35.24,35.24,0,0,1,8.73,18,.5.5,0,0,1-.41.58Zm-60.77-16.9a.52.52,0,0,1-.33-.12.49.49,0,0,1-.05-.7c.44-.52.89-1,1.36-1.51a.5.5,0,0,1,.71,0,.49.49,0,0,1,0,.7q-.68.72-1.32,1.47A.52.52,0,0,1,201.51,118.43Zm40-9.45a.48.48,0,0,1-.2,0c-.6-.25-1.21-.49-1.83-.71a.5.5,0,1,1,.33-.94c.64.23,1.27.47,1.89.73a.5.5,0,0,1-.19,1Zm-26.32-.33a.5.5,0,0,1-.47-.31.51.51,0,0,1,.28-.65A35.24,35.24,0,0,1,235,105.93a.5.5,0,1,1-.2,1,34.23,34.23,0,0,0-19.36,1.71A.57.57,0,0,1,215.21,108.65Z"
                                    style="fill: rgb(255, 255, 255); transform-origin: 227.955px 140.449px"
                                    id="eldjs6g7qypl6"
                                    class="animable"
                                ></path>
                            </g>
                        </g>
                    </g>
                    <g
                        id="freepik--character-1--inject-49"
                        class="animable"
                        style="transform-origin: 175.961px 287.074px"
                    >
                        <path
                            d="M145.69,212.58c2.42,4,4.8,8,7.15,12.08s4.69,8.13,7,12l.11.18c0,.06,0,0,.05.06l0,.1c0,.08.15.18.21.28l.35.34.45.36a15.57,15.57,0,0,0,2.39,1.45,47.36,47.36,0,0,0,6,2.44c4.23,1.44,8.75,2.66,13.19,3.75l-.52,4.89a78.76,78.76,0,0,1-14.58-1.38,46.46,46.46,0,0,1-7.41-2,24.25,24.25,0,0,1-3.85-1.83l-1-.66c-.34-.25-.68-.52-1-.79s-.67-.62-1-1l-.49-.59-.22-.29-.14-.18c-1.47-2-2.83-4-4.15-6s-2.63-4-3.89-6c-2.54-4-5-8.05-7.32-12.19Z"
                            style="fill: rgb(255, 181, 115); transform-origin: 159.805px 231.545px"
                            id="elg8e8thf2xxq"
                            class="animable"
                        ></path>
                        <path
                            d="M133.74,213.44c-1.3,6.38,12.55,22.52,12.55,22.52l10.29-7.59a67.61,67.61,0,0,0-7.6-15.62C143.91,205.47,135.19,206.35,133.74,213.44Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 145.117px 221.825px"
                            id="elkveygyj88to"
                            class="animable"
                        ></path>
                        <g id="elcmesz3egtuq">
                            <path
                                d="M133.74,213.44c-1.3,6.38,12.55,22.52,12.55,22.52l10.29-7.59a67.61,67.61,0,0,0-7.6-15.62C143.91,205.47,135.19,206.35,133.74,213.44Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.5; transform-origin: 145.117px 221.825px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="elo4hbka39hc">
                            <path
                                d="M133.65,214.23c2.47-1.62,5.58-1,9.25,3.59a53.64,53.64,0,0,1,7.77,14.91L146.29,236S133.38,221,133.65,214.23Z"
                                style="opacity: 0.1; transform-origin: 142.158px 224.71px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M141.11,207.71S151.9,227,149.62,266l-36.07,5c-1-5.5-1.3-33-10.27-58.34a94.71,94.71,0,0,1,11.86-3.2,131.32,131.32,0,0,1,15.34-2.13A68.38,68.38,0,0,1,141.11,207.71Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 126.608px 239.135px"
                            id="eld87omnojkjc"
                            class="animable"
                        ></path>
                        <g id="elwdqb73u8j2d">
                            <path
                                d="M149.62,266l-36.07,5c-.64-3.44-1-15.51-3.36-30.28-.63-3.94-1.41-8.08-2.38-12.29a146.33,146.33,0,0,0-4.53-15.77,94.71,94.71,0,0,1,11.86-3.2,133.59,133.59,0,0,1,15.34-2.14,69.1,69.1,0,0,1,10.63.43S151.9,227,149.62,266Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.5; transform-origin: 126.608px 239.137px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M122.27,410.29l-8.84.14a.65.65,0,0,0-.61.51l-1.33,6.5a1.08,1.08,0,0,0,.85,1.26,1,1,0,0,0,.24,0c2.85-.09,4.93-.3,8.52-.36,2.22,0,8.89.1,12,.05s3.4-3.07,2.15-3.33c-5.63-1.14-9.88-2.76-11.7-4.34A1.8,1.8,0,0,0,122.27,410.29Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 123.706px 414.497px"
                            id="elru1a02jlr2b"
                            class="animable"
                        ></path>
                        <path
                            d="M202.79,410.29l-8.83.14a.65.65,0,0,0-.62.51l-1.33,6.5a1.08,1.08,0,0,0,.85,1.26,1,1,0,0,0,.24,0c2.86-.09,4.93-.3,8.53-.36,2.21,0,8.88.1,11.94.05s3.4-3.07,2.15-3.33c-5.63-1.14-9.88-2.76-11.7-4.34A1.78,1.78,0,0,0,202.79,410.29Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 204.195px 414.498px"
                            id="ellzzyfqderbm"
                            class="animable"
                        ></path>
                        <g id="elk6we8ro5dvr">
                            <path
                                d="M122.27,410.29l-8.84.14a.65.65,0,0,0-.61.51l-1.33,6.5a1.08,1.08,0,0,0,.85,1.26,1,1,0,0,0,.24,0c2.85-.09,4.93-.3,8.52-.36,2.22,0,8.89.1,12,.05s3.4-3.07,2.15-3.33c-5.63-1.14-9.88-2.76-11.7-4.34A1.8,1.8,0,0,0,122.27,410.29Z"
                                style="fill: rgb(250, 250, 250); opacity: 0.6; transform-origin: 123.706px 414.497px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="elhqa5x22nfbb">
                            <path
                                d="M202.79,410.29l-8.83.14a.65.65,0,0,0-.62.51l-1.33,6.5a1.08,1.08,0,0,0,.85,1.26,1,1,0,0,0,.24,0c2.86-.09,4.93-.3,8.53-.36,2.21,0,8.88.1,11.94.05s3.4-3.07,2.15-3.33c-5.63-1.14-9.88-2.76-11.7-4.34A1.78,1.78,0,0,0,202.79,410.29Z"
                                style="fill: rgb(250, 250, 250); opacity: 0.6; transform-origin: 204.195px 414.498px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M204,410.74H192s-10.6-62.81-17.12-70c-3.74-4.11-14.05-16.25-22.14-25.84C146.9,308,142.22,302.45,142,302.15v0s-.48,32.3-1.8,45.19-16.65,63.42-16.65,63.42h-12s7.24-60.07,6.1-73.92c-.61-7.28-4.39-34.37-4.56-54.41,0-5.34.55-11.45.55-11.45l36.07-5s3.64,8.64,5.12,11.36c1.16,2.14,33.9,41.86,40.07,60.05S204,410.74,204,410.74Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 157.775px 338.37px"
                            id="elbmjzxwrt31"
                            class="animable"
                        ></path>
                        <path
                            d="M114.26,191.94c1.65,4.8,3.88,13.71.88,17.48a47.45,47.45,0,0,1,14.26,6.66c1-3.23,1.69-6.31,1.08-8.79-5.69-.55-6.11-4.65-5.69-8.62Z"
                            style="fill: rgb(255, 181, 115); transform-origin: 122.485px 204.01px"
                            id="el8em0cqsqwcg"
                            class="animable"
                        ></path>
                        <g id="elyrs83b0fkom">
                            <path
                                d="M118.55,194.69l6.24,4a15.31,15.31,0,0,0-.1,2.78c-2.14,0-5.35-1.91-5.88-4.08A7.79,7.79,0,0,1,118.55,194.69Z"
                                style="opacity: 0.2; transform-origin: 121.658px 198.08px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M127.68,172.61c5.36,1.44,4.92,13.24,2.81,14.7C126.54,190,121,170.82,127.68,172.61Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 128.26px 180.03px"
                            id="elqlqafhpvf5e"
                            class="animable"
                        ></path>
                        <path
                            d="M112.64,184.6c1.34,6.62,1.79,10.57,5.64,13.53,5.79,4.45,13.61.24,14.28-6.65.6-6.2-1.69-16-8.6-17.74A9.22,9.22,0,0,0,112.64,184.6Z"
                            style="fill: rgb(255, 181, 115); transform-origin: 122.543px 186.705px"
                            id="elqeh0bkpbyo"
                            class="animable"
                        ></path>
                        <path
                            d="M106.69,181.14c1.1,4.4,6.3,12.71,8.85,12.12,2.76-.63,2.74-6.81.58-12.12Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 112.185px 187.215px"
                            id="elxdp755juak"
                            class="animable"
                        ></path>
                        <path
                            d="M110.65,192.38a6.41,6.41,0,0,0,4.35,2.26c2.25.18,2.94-1.94,2-3.83-.89-1.7-3.13-3.85-5.2-3.14A2.89,2.89,0,0,0,110.65,192.38Z"
                            style="fill: rgb(255, 181, 115); transform-origin: 113.636px 191.091px"
                            id="elb9kbtwt8uuj"
                            class="animable"
                        ></path>
                        <path
                            d="M123,185.06c.08.54.43.94.78.89s.59-.53.51-1.07-.42-.95-.78-.9S123,184.51,123,185.06Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 123.653px 184.965px"
                            id="elhop8u1sxdqj"
                            class="animable"
                        ></path>
                        <path
                            d="M129.18,184.2c.08.55.43,1,.78.9s.58-.53.51-1.08-.43-.94-.78-.89S129.11,183.66,129.18,184.2Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 129.825px 184.12px"
                            id="elyqkkd70s6e"
                            class="animable"
                        ></path>
                        <path
                            d="M127.26,184.74a19.7,19.7,0,0,0,3.25,4.29,3.14,3.14,0,0,1-2.53.85Z"
                            style="fill: rgb(237, 137, 62); transform-origin: 128.885px 187.32px"
                            id="el3vqtdrw27rt"
                            class="animable"
                        ></path>
                        <path
                            d="M126.62,191.6a.16.16,0,0,0,.12-.18.15.15,0,0,0-.18-.13,4.33,4.33,0,0,1-3.75-1.2.16.16,0,1,0-.24.21,4.6,4.6,0,0,0,4,1.31Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 124.632px 190.846px"
                            id="elk1xpcn8px7"
                            class="animable"
                        ></path>
                        <path
                            d="M120.94,183.32a.3.3,0,0,0,.2-.15,2.56,2.56,0,0,1,1.9-1.35.33.33,0,0,0,0-.65,3.23,3.23,0,0,0-2.42,1.68.32.32,0,0,0,.12.44A.29.29,0,0,0,120.94,183.32Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 121.945px 182.248px"
                            id="elg05nribeky5"
                            class="animable"
                        ></path>
                        <path
                            d="M131.62,181.71l.09-.05a.31.31,0,0,0,.09-.44,3.17,3.17,0,0,0-2.54-1.48.32.32,0,0,0,0,.64,2.58,2.58,0,0,1,2,1.2A.33.33,0,0,0,131.62,181.71Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 130.398px 180.731px"
                            id="elg1scvngxnsg"
                            class="animable"
                        ></path>
                        <path
                            d="M109.87,188A13.47,13.47,0,0,1,106,178c.29-6.23,12.46-9.79,18.59-8.9s3.7,7.27,3.7,7.27-8.45,1-11.51,2.13-.64,2.66-.64,2.66Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 117.377px 178.482px"
                            id="el6p8jnoy5i6f"
                            class="animable"
                        ></path>
                        <polygon
                            points="110.64 210.43 113.63 206.69 123.34 208.56 128.27 214.21 128.89 207.69 130.71 205.5 134.69 207.23 134.69 211.31 131.86 210.38 129.4 216.08 121.65 212.89 119.92 215.09 110.64 210.43"
                            style="fill: rgb(64, 123, 255); transform-origin: 122.665px 210.79px"
                            id="elci955inze79"
                            class="animable"
                        ></polygon>
                        <g id="elfsyfv61ica9">
                            <polygon
                                points="110.64 210.43 113.63 206.69 123.34 208.56 128.27 214.21 128.89 207.69 130.71 205.5 134.69 207.23 134.69 211.31 131.86 210.38 129.4 216.08 121.65 212.89 119.92 215.09 110.64 210.43"
                                style="fill: rgb(255, 255, 255); opacity: 0.6; transform-origin: 122.665px 210.79px"
                                class="animable"
                            ></polygon>
                        </g>
                        <g id="el64c9vptuulv">
                            <polygon
                                points="129.4 216.08 130.34 209.26 134.69 211.31 131.86 210.38 129.4 216.08"
                                style="opacity: 0.1; transform-origin: 132.045px 212.67px"
                                class="animable"
                            ></polygon>
                        </g>
                        <g id="eliixwgftu1x">
                            <polygon
                                points="129.4 216.08 122.22 210.79 119.92 215.09 121.65 212.89 129.4 216.08"
                                style="opacity: 0.1; transform-origin: 124.66px 213.435px"
                                class="animable"
                            ></polygon>
                        </g>
                        <g id="eletzzihcu3ra">
                            <path
                                d="M110.19,240.68c-.63-3.94-1.41-8.08-2.38-12.29a7.56,7.56,0,0,1,4.64-2.71S113.44,235.22,110.19,240.68Z"
                                style="opacity: 0.1; transform-origin: 110.201px 233.18px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M108.84,220.62c-.75,4.11-1.49,8.35-2.13,12.5-.34,2.07-.61,4.15-.86,6.2s-.41,4.07-.45,5.93c0,.46,0,.9,0,1.32s.07.82.08,1a1.55,1.55,0,0,0-.35-.49c-.16-.13-.25-.12-.17-.05a3.49,3.49,0,0,0,1.59.48,15.66,15.66,0,0,0,2.64.15,79.19,79.19,0,0,0,12.17-1.52l1.68,4.63A48.16,48.16,0,0,1,110,255.36a23.07,23.07,0,0,1-3.85.37,12.42,12.42,0,0,1-4.73-.83A7.94,7.94,0,0,1,98.61,253a7.66,7.66,0,0,1-1.83-3.34,17.22,17.22,0,0,1-.41-2.2q-.12-1-.18-1.92a58.77,58.77,0,0,1,.07-7.05c.13-2.27.38-4.5.63-6.72.55-4.43,1.27-8.74,2.21-13.13Z"
                            style="fill: rgb(255, 181, 115); transform-origin: 109.578px 237.186px"
                            id="elubipjx300vb"
                            class="animable"
                        ></path>
                        <path
                            d="M103.28,212.62c-9.68,4.06-9.07,27.17-9.07,27.17l13.19.92a118.25,118.25,0,0,0,6.11-17.78C115.49,214.34,109.72,209.92,103.28,212.62Z"
                            style="fill: rgb(64, 123, 255); transform-origin: 104.054px 226.27px"
                            id="el1mnvhovidqm"
                            class="animable"
                        ></path>
                        <g id="el80w0gfr90ik">
                            <path
                                d="M103.28,212.62c-9.68,4.06-9.07,27.17-9.07,27.17l13.19.92a118.25,118.25,0,0,0,6.11-17.78C115.49,214.34,109.72,209.92,103.28,212.62Z"
                                style="fill: rgb(255, 255, 255); opacity: 0.5; transform-origin: 104.054px 226.27px"
                                class="animable"
                            ></path>
                        </g>
                        <g id="elmk4wmy5edp">
                            <path
                                d="M152.73,314.94C146.9,308,142.22,302.45,142,302.15v0l.21-5.85A30.26,30.26,0,0,1,152.73,314.94Z"
                                style="opacity: 0.2; transform-origin: 147.365px 305.62px"
                                class="animable"
                            ></path>
                        </g>
                        <path
                            d="M227.42,247.76l-20.49,11.85-20,11.57c-.71.41-1.43.79-2.16,1.15l0,0c-8.21,4.72-15.61,6.5-22.1,6.5-19.56,0-30.8-16.13-30.8-16.13a38.44,38.44,0,0,1,8.61-59.82l20.33-11.76L181,179.48l7.93,1.66,3.34,5.77,6.67,11.54-20.65,12-19.83,11.47a18.45,18.45,0,0,0,1.62,32.8,18.53,18.53,0,0,0,9-2.47L188.38,241l21.1-12.21,7.93,1.67,5,8.66Z"
                            style="fill: rgb(38, 50, 56); transform-origin: 174.336px 229.155px"
                            id="elxk7g5wif2pa"
                            class="animable"
                        ></path>
                        <polygon
                            points="198.89 198.45 178.24 210.41 170.38 208.7 160.8 191.14 180.95 179.48 188.88 181.14 192.22 186.91 198.89 198.45"
                            style="fill: rgb(64, 123, 255); transform-origin: 179.845px 194.945px"
                            id="ellmwg3yvcq1n"
                            class="animable"
                        ></polygon>
                        <polygon
                            points="227.42 247.76 206.93 259.61 198.13 258.46 188.38 240.99 209.48 228.78 217.41 230.45 222.42 239.11 227.42 247.76"
                            style="fill: rgb(64, 123, 255); transform-origin: 207.9px 244.195px"
                            id="elh2iovd00g7"
                            class="animable"
                        ></polygon>
                        <g id="elt9hkjunmlhs">
                            <g style="opacity: 0.2; transform-origin: 170.388px 227.075px" class="animable">
                                <path
                                    d="M126.43,255.48a38.53,38.53,0,0,1,14-52.58L181,179.48l10,17.31-40.48,23.42a18.48,18.48,0,1,0,18.51,32l40.48-23.43,10,17.32L179,269.52A38.53,38.53,0,0,1,126.43,255.48Z"
                                    style="fill: rgb(255, 255, 255); transform-origin: 170.388px 227.075px"
                                    id="el2dft17p244m"
                                    class="animable"
                                ></path>
                            </g>
                        </g>
                        <g id="elo2jscefd90b">
                            <polygon
                                points="180.95 179.48 188.88 181.14 198.89 198.45 190.97 196.79 180.95 179.48"
                                style="fill: rgb(255, 255, 255); opacity: 0.4; transform-origin: 189.92px 188.965px"
                                class="animable"
                            ></polygon>
                        </g>
                        <g id="elfkxh3d7i7h8">
                            <polygon
                                points="209.48 228.78 217.41 230.45 227.42 247.76 219.5 246.1 209.48 228.78"
                                style="fill: rgb(255, 255, 255); opacity: 0.4; transform-origin: 218.45px 238.27px"
                                class="animable"
                            ></polygon>
                        </g>
                        <polygon
                            points="159.09 188.01 159.42 188.62 159.09 188.96 159.09 188.01"
                            style="fill: rgb(64, 123, 255); transform-origin: 159.255px 188.485px"
                            id="el5mfzp0uf74s"
                            class="animable"
                        ></polygon>
                        <path
                            d="M118.67,246.83l7.42-6.27,4.38,7.28S125.9,253,120.6,251Z"
                            style="fill: rgb(255, 181, 115); transform-origin: 124.57px 246.01px"
                            id="eluplasfltcq"
                            class="animable"
                        ></path>
                        <polygon
                            points="132.85 239.1 134.81 245.3 130.47 247.84 126.09 240.56 132.85 239.1"
                            style="fill: rgb(255, 181, 115); transform-origin: 130.45px 243.47px"
                            id="ele8ymbvphd1r"
                            class="animable"
                        ></polygon>
                        <polygon
                            points="193.88 180.21 200.82 170.18 195.66 166.61 209.48 155.44 202.62 165.35 207.78 168.92 193.88 180.21"
                            style="fill: rgb(64, 123, 255); transform-origin: 201.68px 167.825px"
                            id="ellanmoalzesr"
                            class="animable"
                        ></polygon>
                        <polygon
                            points="201.68 191.4 212.61 186 209.83 180.37 227.34 177.31 216.53 182.64 219.31 188.27 201.68 191.4"
                            style="fill: rgb(64, 123, 255); transform-origin: 214.51px 184.355px"
                            id="el99sendoi8dm"
                            class="animable"
                        ></polygon>
                        <polygon
                            points="229.09 240.81 241.11 238.82 240.09 232.62 257.72 234.77 245.84 236.74 246.86 242.93 229.09 240.81"
                            style="fill: rgb(64, 123, 255); transform-origin: 243.405px 237.775px"
                            id="elpr8d1ddgkc"
                            class="animable"
                        ></polygon>
                        <polygon
                            points="222.46 232.06 230.86 223.22 226.31 218.9 241.69 209.99 233.38 218.72 237.93 223.05 222.46 232.06"
                            style="fill: rgb(64, 123, 255); transform-origin: 232.075px 221.025px"
                            id="el29h1vf0kchp"
                            class="animable"
                        ></polygon>
                        <g id="elpsjnallwycb">
                            <g style="opacity: 0.5; transform-origin: 225.8px 199.185px" class="animable">
                                <polygon
                                    points="193.88 180.21 200.82 170.18 195.66 166.61 209.48 155.44 202.62 165.35 207.78 168.92 193.88 180.21"
                                    style="fill: rgb(255, 255, 255); transform-origin: 201.68px 167.825px"
                                    id="elcs6furop3s4"
                                    class="animable"
                                ></polygon>
                                <polygon
                                    points="201.68 191.4 212.61 186 209.83 180.37 227.34 177.31 216.53 182.64 219.31 188.27 201.68 191.4"
                                    style="fill: rgb(255, 255, 255); transform-origin: 214.51px 184.355px"
                                    id="elvpy20vkxbc"
                                    class="animable"
                                ></polygon>
                                <polygon
                                    points="229.09 240.81 241.11 238.82 240.09 232.62 257.72 234.77 245.84 236.74 246.86 242.93 229.09 240.81"
                                    style="fill: rgb(255, 255, 255); transform-origin: 243.405px 237.775px"
                                    id="elt92sspqhd6f"
                                    class="animable"
                                ></polygon>
                                <polygon
                                    points="222.46 232.06 230.86 223.22 226.31 218.9 241.69 209.99 233.38 218.72 237.93 223.05 222.46 232.06"
                                    style="fill: rgb(255, 255, 255); transform-origin: 232.075px 221.025px"
                                    id="elfp3p3lxh0tb"
                                    class="animable"
                                ></polygon>
                            </g>
                        </g>
                    </g>
                    <defs>
                        <filter id="active" height="200%">
                            <feMorphology in="SourceAlpha" result="DILATED" operator="dilate" radius="2"></feMorphology>
                            <feFlood flood-color="#32DFEC" flood-opacity="1" result="PINK"></feFlood>
                            <feComposite in="PINK" in2="DILATED" operator="in" result="OUTLINE"></feComposite>
                            <feMerge>
                                <feMergeNode in="OUTLINE"></feMergeNode>
                                <feMergeNode in="SourceGraphic"></feMergeNode>
                            </feMerge>
                        </filter>
                        <filter id="hover" height="200%">
                            <feMorphology in="SourceAlpha" result="DILATED" operator="dilate" radius="2"></feMorphology>
                            <feFlood flood-color="#ff0000" flood-opacity="0.5" result="PINK"></feFlood>
                            <feComposite in="PINK" in2="DILATED" operator="in" result="OUTLINE"></feComposite>
                            <feMerge>
                                <feMergeNode in="OUTLINE"></feMergeNode>
                                <feMergeNode in="SourceGraphic"></feMergeNode>
                            </feMerge>
                            <feColorMatrix
                                type="matrix"
                                values="0   0   0   0   0                0   1   0   0   0                0   0   0   0   0                0   0   0   1   0 "
                            ></feColorMatrix>
                        </filter>
                    </defs>
                </svg>
            </div>
            <!-- END Animated Image -->
        </div>
        <!-- form -->
        <form method="post" action="{{ brand_route("paymentlink.store") }}" class="w-full sm:max-w-[320px]">
            @csrf
            <input type="hidden" name="currency" value="{{ $currency }}" autocomplete="off" />
            <div class="relative mb-5 flex w-full flex-col">
                <svg
                    width="16"
                    viewBox="0 0 16 18"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                    class="absolute top-[16px] left-4"
                >
                    <path
                        d="M14.8225 16.5503V14.8225C14.8225 13.906 14.4584 13.027 13.8104 12.379C13.1623 11.7309 12.2834 11.3669 11.3669 11.3669H4.45562C3.53913 11.3669 2.66018 11.7309 2.01213 12.379C1.36407 13.027 1 13.906 1 14.8225V16.5503"
                        stroke="#94A9C7"
                        stroke-width="2"
                        stroke-linecap="round"
                        stroke-linejoin="round"
                    ></path>
                    <path
                        d="M7.91119 7.91124C9.81967 7.91124 11.3668 6.36411 11.3668 4.45562C11.3668 2.54713 9.81967 1 7.91119 1C6.0027 1 4.45557 2.54713 4.45557 4.45562C4.45557 6.36411 6.0027 7.91124 7.91119 7.91124Z"
                        stroke="#6D7F9A"
                        stroke-width="2"
                        stroke-linecap="round"
                        stroke-linejoin="round"
                    ></path>
                </svg>
                <input
                    name="name"
                    type="text"
                    class="input-primary"
                    placeholder="{{ __("checkout.paymentlink.full_name") }}"
                    required
                />
            </div>
            <div class="relative mb-5 flex w-full flex-col">
                <svg
                    width="18"
                    viewBox="0 0 20 16"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                    class="absolute top-[18px] left-4"
                >
                    <path
                        d="M2.72781 1H16.5503C17.5006 1 18.2781 1.77751 18.2781 2.72781V13.0947C18.2781 14.045 17.5006 14.8225 16.5503 14.8225H2.72781C1.77751 14.8225 1 14.045 1 13.0947V2.72781C1 1.77751 1.77751 1 2.72781 1Z"
                        stroke="#94A9C7"
                        stroke-width="2"
                        stroke-linecap="round"
                        stroke-linejoin="round"
                    ></path>
                    <path
                        d="M18.2781 2.72781L9.63905 8.77515L1 2.72781"
                        stroke="#6D7F9A"
                        stroke-width="2"
                        stroke-linecap="round"
                        stroke-linejoin="round"
                    ></path>
                </svg>
                <input
                    name="email"
                    type="text"
                    class="input-primary"
                    placeholder="{{ __("checkout.paymentlink.email") }}"
                    required
                />
            </div>
            <div class="relative mb-5 flex w-full flex-col">
                <svg
                    width="16"
                    viewBox="0 0 15 15"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                    class="absolute top-[16px] left-4"
                >
                    <path
                        d="M13.2698 15H13.1718C1.83943 14.3481 0.23041 4.78269 0.00549307 1.86346C-0.0126299 1.63649 0.0141949 1.40817 0.0844303 1.19158C0.154666 0.974998 0.266931 0.774406 0.414795 0.601299C0.562658 0.428192 0.743213 0.285974 0.946114 0.182792C1.14902 0.0796102 1.37027 0.0174933 1.59721 5.40918e-07H4.77489C5.0059 -0.000223169 5.23165 0.0689484 5.4229 0.198555C5.61416 0.328162 5.7621 0.512233 5.84757 0.726924L6.72417 2.88462C6.80857 3.09435 6.82952 3.32428 6.78441 3.54582C6.73929 3.76737 6.63011 3.97077 6.47042 4.13077L5.24203 5.37115C5.43391 6.46197 5.9561 7.4675 6.73795 8.25171C7.51981 9.03591 8.52359 9.56094 9.61349 9.75577L10.865 8.51539C11.0273 8.3574 11.2325 8.25072 11.4551 8.20866C11.6776 8.16659 11.9076 8.191 12.1164 8.27885L14.2906 9.15C14.502 9.2382 14.6823 9.38736 14.8087 9.57846C14.935 9.76957 15.0016 9.99397 15 10.2231V13.2692C15 13.7283 14.8177 14.1685 14.4932 14.4931C14.1688 14.8177 13.7287 15 13.2698 15ZM1.73563 1.15385C1.58267 1.15385 1.43598 1.21463 1.32783 1.32282C1.21967 1.43102 1.15891 1.57776 1.15891 1.73077V1.77692C1.4242 5.19231 3.1255 13.2692 13.2352 13.8462C13.311 13.8508 13.3869 13.8405 13.4587 13.8158C13.5305 13.791 13.5967 13.7524 13.6535 13.702C13.7102 13.6516 13.7565 13.5905 13.7897 13.5222C13.8228 13.4538 13.8421 13.3797 13.8466 13.3038V10.2231L11.6724 9.35192L10.0172 10.9962L9.74037 10.9615C4.72299 10.3327 4.04247 5.31346 4.04247 5.26154L4.00787 4.98462L5.64572 3.32885L4.78066 1.15385H1.73563Z"
                        fill="#6D7F9A"
                    ></path>
                </svg>
                <input
                    name="phone"
                    type="text"
                    class="input-primary"
                    placeholder="{{ __("checkout.paymentlink.phone") }}"
                    required
                />
            </div>
            <div class="relative mb-5 flex w-full flex-col">
                @if ($currency === "BDT")
                    <svg
                        width="18"
                        viewBox="0 0 22 22"
                        fill="none"
                        xmlns="http://www.w3.org/2000/svg"
                        class="absolute top-[16px] left-4"
                    >
                        <path
                            fill-rule="evenodd"
                            clip-rule="evenodd"
                            d="M7.4043 10.6809C7.4043 10.1638 7.82344 9.74469 8.34047 9.74469H13.9575C14.4745 9.74469 14.8937 10.1638 14.8937 10.6809C14.8937 11.1979 14.4745 11.617 13.9575 11.617H8.34047C7.82344 11.617 7.4043 11.1979 7.4043 10.6809Z"
                            fill="#6D7F9A"
                        ></path>
                        <path
                            fill-rule="evenodd"
                            clip-rule="evenodd"
                            d="M7.4043 6.93617C7.4043 6.41914 7.82344 6 8.34047 6C8.90366 6 9.62386 6.24223 10.1976 6.86183C10.7842 7.49546 11.149 8.44509 11.149 9.74468V13.9574C11.149 14.4415 11.3047 14.7201 11.4599 14.8753C11.6239 15.0393 11.8487 15.1277 12.0851 15.1277C12.3216 15.1277 12.5464 15.0393 12.7104 14.8753C12.8656 14.7201 13.0213 14.4415 13.0213 13.9574C13.0213 13.4404 13.4404 13.0213 13.9575 13.0213C14.4745 13.0213 14.8937 13.4404 14.8937 13.9574C14.8937 14.8776 14.5813 15.6523 14.0343 16.1992C13.4962 16.7373 12.7848 17 12.0851 17C11.3855 17 10.6741 16.7373 10.1359 16.1992C9.58904 15.6523 9.27664 14.8776 9.27664 13.9574V9.74468C9.27664 8.79746 9.01721 8.34284 8.82376 8.13392C8.61731 7.91096 8.40139 7.87234 8.34047 7.87234C7.82344 7.87234 7.4043 7.4532 7.4043 6.93617Z"
                            fill="#6D7F9A"
                        ></path>
                        <path
                            fill-rule="evenodd"
                            clip-rule="evenodd"
                            d="M11 2.2C6.13989 2.2 2.2 6.13989 2.2 11C2.2 15.8601 6.13989 19.8 11 19.8C15.8601 19.8 19.8 15.8601 19.8 11C19.8 6.13989 15.8601 2.2 11 2.2ZM0 11C0 4.92486 4.92486 0 11 0C17.0751 0 22 4.92486 22 11C22 17.0751 17.0751 22 11 22C4.92486 22 0 17.0751 0 11Z"
                            fill="#94A9C7"
                        ></path>
                    </svg>
                @else
                    <svg
                        width="12"
                        viewBox="0 0 13 22"
                        fill="none"
                        xmlns="http://www.w3.org/2000/svg"
                        class="absolute top-[15px] left-4"
                    >
                        <path
                            d="M6.18335 1V20.0059"
                            stroke="#94A9C7"
                            stroke-width="2"
                            stroke-linecap="round"
                            stroke-linejoin="round"
                        ></path>
                        <path
                            d="M10.503 4.45563H4.02367C3.22174 4.45563 2.45266 4.77419 1.88561 5.34124C1.31856 5.90829 1 6.67737 1 7.4793C1 8.28122 1.31856 9.0503 1.88561 9.61735C2.45266 10.1844 3.22174 10.503 4.02367 10.503H8.3432C9.14512 10.503 9.91421 10.8215 10.4813 11.3886C11.0483 11.9556 11.3669 12.7247 11.3669 13.5266C11.3669 14.3286 11.0483 15.0976 10.4813 15.6647C9.91421 16.2317 9.14512 16.5503 8.3432 16.5503H1"
                            stroke="#6D7F9A"
                            stroke-width="2"
                            stroke-linecap="round"
                            stroke-linejoin="round"
                        ></path>
                    </svg>
                @endif
                <input
                    name="amount"
                    type="text"
                    class="input-primary"
                    placeholder="{{ __("checkout.paymentlink.amount") }}"
                    required
                />
            </div>
            <div class="relative mb-5 flex w-full flex-col">
                <svg
                    width="18"
                    viewBox="0 0 20 20"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                    class="absolute top-[16px] left-4"
                >
                    <path
                        d="M18.2781 1L8.77515 10.503"
                        stroke="#94A9C7"
                        stroke-width="2"
                        stroke-linecap="round"
                        stroke-linejoin="round"
                    ></path>
                    <path
                        d="M18.2781 1L12.2308 18.2781L8.77515 10.503L1 7.04734L18.2781 1Z"
                        stroke="#6D7F9A"
                        stroke-width="2"
                        stroke-linecap="round"
                        stroke-linejoin="round"
                    ></path>
                </svg>
                <input
                    name="reference"
                    type="text"
                    class="input-primary"
                    placeholder="{{ __("checkout.paymentlink.reference") }}"
                />
            </div>
            <div class="w-full">
                <button type="submit" class="w-full">
                    <div class="btn-primary w-full">{{ __("checkout.paymentlink.submit") }}</div>
                </button>
            </div>
        </form>
        <!-- END form -->
    </div>
    <!-- END Full Design -->
@endsection

@push("script")
    <script>
        {!! $themeSettings->payment_link_js !!};
    </script>
@endpush
