<?php

declare(strict_types=1);

use Illuminate\Broadcasting\BroadcastEvent;
use Illuminate\Events\CallQueuedListener;
use Illuminate\Mail\SendQueuedMailable;
use Illuminate\Notifications\SendQueuedNotifications;
use Illuminate\Queue\CallQueuedClosure;
use Revoltify\Brandify\Models\Brand;
use Revoltify\Brandify\Models\Domain;
use Revoltify\Brandify\Resolvers\DomainResolver;

return [
    /*
    |--------------------------------------------------------------------------
    | Brand & Domain Models
    |--------------------------------------------------------------------------
    */
    'models' => [
        'brand' => Brand::class,
        'domain' => Domain::class,
    ],

    /*
    |--------------------------------------------------------------------------
    | Queue Configuration
    |--------------------------------------------------------------------------
    */
    'queue' => [
        'brand_aware_by_default' => false,

        'queueable_to_job' => [
            SendQueuedMailable::class => 'mailable',
            SendQueuedNotifications::class => 'notification',
            CallQueuedClosure::class => 'closure',
            CallQueuedListener::class => 'class',
            BroadcastEvent::class => 'event',
        ],

        'brand_aware_jobs' => [
            // ...
        ],

        'not_brand_aware_jobs' => [
            // ...
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Bootstrappers
    |--------------------------------------------------------------------------
    |
    | The bootstrappers array lets you register classes that will be run when
    | a brand is initialized. These classes should implement the
    | BootstrapperInterface.
    */
    'bootstrappers' => [
        // ...
    ],

    /*
    |--------------------------------------------------------------------------
    | Resolver Configuration
    |--------------------------------------------------------------------------
    |
    | Configure brand resolution settings including the resolver class
    | and any resolver-specific settings
    |
    */
    'resolver' => [
        // The resolver class to use for brand resolution
        'class' => DomainResolver::class,

        // Cache configuration for the resolver
        'cache' => [
            'enabled' => env('BRANDIFY_CACHE_ENABLED', true),
            'ttl' => env('BRANDIFY_CACHE_TTL', 300),
        ],
    ],
];
