<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['dark' => ($appearance ?? 'system') == 'dark']); ?>" data-appearance="<?php echo e($appearance ?? 'system'); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <?php echo ($SEOData??false)? seo($SEOData):seo(); ?>



    <script>
        (function () {
            const root = document.documentElement;
            const appearance = root.dataset.appearance || 'system';
            const mediaQuery = window.matchMedia ? window.matchMedia('(prefers-color-scheme: dark)') : null;

            const resolveAppearance = (mode) => {
                if (mode === 'light' || mode === 'dark') {
                    return mode;
                }

                return mediaQuery && mediaQuery.matches ? 'dark' : 'light';
            };

            const resolved = resolveAppearance(appearance);

            root.classList.toggle('dark', resolved === 'dark');
            root.style.colorScheme = resolved === 'dark' ? 'dark' : 'light';
            root.dataset.resolvedAppearance = resolved;
        })();
    </script>

    <link rel="icon" href="/favicon.ico" sizes="any">
    <link rel="icon" href="/favicon.svg" type="image/svg+xml">
    <link rel="apple-touch-icon" href="/apple-touch-icon.png">

    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600" rel="stylesheet" />

    <?php if(config('services.google_analytics.id') && app()->environment('production')): ?>
    <!-- Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e(config('services.google_analytics.id')); ?>"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());
        gtag('config', '<?php echo e(config('services.google_analytics.id')); ?>', {
            page_path: window.location.pathname,
        });
    </script>
    <?php endif; ?>

    <?php echo app('Illuminate\Foundation\Vite')->reactRefresh(); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/app.tsx', "resources/js/pages/{$page['component']}.tsx"]); ?>
    <?php if (!isset($__inertiaSsrDispatched)) { $__inertiaSsrDispatched = true; $__inertiaSsrResponse = app(\Inertia\Ssr\Gateway::class)->dispatch($page); }  if ($__inertiaSsrResponse) { echo $__inertiaSsrResponse->head; } ?>
</head>

<body class="font-sans antialiased">
    <?php if (!isset($__inertiaSsrDispatched)) { $__inertiaSsrDispatched = true; $__inertiaSsrResponse = app(\Inertia\Ssr\Gateway::class)->dispatch($page); }  if ($__inertiaSsrResponse) { echo $__inertiaSsrResponse->body; } else { ?><div id="app" data-page="<?php echo e(json_encode($page)); ?>"></div><?php } ?>
</body>

</html><?php /**PATH /home/sourovme/diuqbank.com/releases/30/resources/views/app.blade.php ENDPATH**/ ?>